/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.mixin;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.mixin.MixinModelRegistry;
import org.eclipse.dltk.core.search.index.Index;
import org.eclipse.dltk.core.search.indexing.IndexDocument;
import org.eclipse.dltk.core.search.indexing.core.AbstractProjectIndexer;
import org.eclipse.dltk.core.search.indexing.core.ReconcileSourceModuleRequest;
import org.eclipse.dltk.core.search.indexing.core.RemoveIndexRequest;
import org.eclipse.dltk.internal.core.mixin.MixinIndexer;

public class MixinProjectIndexer
extends AbstractProjectIndexer {
    public void doIndexing(IndexDocument document) {
        new MixinIndexer(document).indexDocument();
        MixinModelRegistry.clearKeysCache(DLTKLanguageManager.getLanguageToolkit(document.getSourceModule()));
    }

    public Index getProjectIndex(IScriptProject project) {
        String path = project.getProject().getFullPath().toString();
        return this.getIndexManager().getSpecialIndex("#special#mixin#", path, path);
    }

    public Index getProjectFragmentIndex(IProjectFragment fragment) {
        String path = fragment.getPath().toString();
        return this.getIndexManager().getSpecialIndex("#special#mixin#", path, path);
    }

    public void removeProject(IPath projectPath) {
        this.requestIfNotWaiting(new RemoveIndexRequest(this, (IPath)new Path("#special#mixin#" + projectPath.toString())));
    }

    public void removeLibrary(IScriptProject project, IPath path) {
        this.requestIfNotWaiting(new RemoveIndexRequest(this, (IPath)new Path("#special#mixin#" + path.toString())));
    }

    public void reconciled(ISourceModule workingCopy, IDLTKLanguageToolkit toolkit) {
        this.request(new ReconcileSourceModuleRequest(this, workingCopy, toolkit));
    }
}

