/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.dltk.compiler.problem.IProblemReporter;
import org.eclipse.dltk.compiler.task.ITaskReporter;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.builder.IBuildParticipant;
import org.eclipse.dltk.core.builder.IBuildParticipantExtension;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.internal.core.AccumulatingProblemReporter;
import org.eclipse.dltk.internal.core.builder.AbstractBuildContext;
import org.eclipse.dltk.internal.core.builder.BuildParticipantManager;

class StructureBuilder {
    StructureBuilder() {
    }

    static void build(String natureId, ISourceModule module, AccumulatingProblemReporter reporter) {
        IBuildParticipant participant;
        NullProgressMonitor monitor = new NullProgressMonitor();
        IScriptProject project = module.getScriptProject();
        IBuildParticipant[] participants = StructureBuilder.beginBuild(natureId, project);
        if (participants.length == 0) {
            return;
        }
        ReconcileBuildContext context = new ReconcileBuildContext(module, reporter);
        try {
            int k = 0;
            while (k < participants.length) {
                participant = participants[k];
                participant.build(context);
                ++k;
            }
        }
        catch (CoreException e) {
            DLTKCore.error("error", e);
        }
        int j = 0;
        while (j < participants.length) {
            participant = participants[j];
            if (participant instanceof IBuildParticipantExtension) {
                ((IBuildParticipantExtension)((Object)participant)).endBuild((IProgressMonitor)monitor);
            }
            ++j;
        }
    }

    private static IBuildParticipant[] beginBuild(String natureId, IScriptProject project) {
        IBuildParticipant[] participants = BuildParticipantManager.getBuildParticipants(project, natureId);
        int count = 0;
        int j = 0;
        while (j < participants.length) {
            IBuildParticipant participant = participants[j];
            boolean useParticipant = participant instanceof IBuildParticipantExtension ? ((IBuildParticipantExtension)((Object)participant)).beginBuild(10) : true;
            if (useParticipant) {
                if (count < j) {
                    participants[count] = participants[j];
                }
                ++count;
            }
            ++j;
        }
        return BuildParticipantManager.copyFirst(participants, count);
    }

    private static class ReconcileBuildContext
    extends AbstractBuildContext {
        final AccumulatingProblemReporter reporter;

        protected ReconcileBuildContext(ISourceModule module, AccumulatingProblemReporter reporter) {
            super(module, 10);
            this.reporter = reporter;
        }

        public IFileHandle getFileHandle() {
            return null;
        }

        public IProblemReporter getProblemReporter() {
            return this.reporter;
        }

        public ITaskReporter getTaskReporter() {
            return this.reporter;
        }
    }
}

