/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.internal.environment;

import java.net.URI;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.core.internal.environment.LazyFileHandle;

public abstract class LazyEnvironment
implements IEnvironment {
    private static final boolean DEBUG = false;
    private final String environmentId;
    private IEnvironment environment;

    public LazyEnvironment(String environmentId) {
        this.environmentId = environmentId;
    }

    private void initialize() {
        if (this.environment == null) {
            this.environment = this.resolveEnvironment(this.environmentId);
        }
    }

    protected abstract IEnvironment resolveEnvironment(String var1);

    public boolean connect() {
        this.initialize();
        return this.environment != null && this.environment.connect();
    }

    public String convertPathToString(IPath path) {
        this.initialize();
        return this.environment != null ? this.environment.convertPathToString(path) : path.toString();
    }

    public String getCanonicalPath(IPath path) {
        this.initialize();
        return this.environment != null ? this.environment.getCanonicalPath(path) : path.toString();
    }

    public IFileHandle getFile(IPath path) {
        return new LazyFileHandle(this.environmentId, path);
    }

    public IFileHandle getFile(URI locationURI) {
        this.initialize();
        return this.environment != null ? this.environment.getFile(locationURI) : null;
    }

    public String getId() {
        return this.environmentId;
    }

    public String getName() {
        this.initialize();
        return this.environment != null ? this.environment.getName() : this.generateName();
    }

    private String generateName() {
        return String.valueOf(this.getClass().getSimpleName()) + '[' + this.environmentId + ']';
    }

    public String getPathsSeparator() {
        this.initialize();
        return this.environment != null ? this.environment.getPathsSeparator() : ":";
    }

    public char getPathsSeparatorChar() {
        this.initialize();
        return this.environment != null ? this.environment.getPathsSeparatorChar() : (char)':';
    }

    public String getSeparator() {
        this.initialize();
        return this.environment != null ? this.environment.getSeparator() : "/";
    }

    public char getSeparatorChar() {
        this.initialize();
        return this.environment != null ? this.environment.getSeparatorChar() : (char)'/';
    }

    public URI getURI(IPath location) {
        this.initialize();
        return this.environment != null ? this.environment.getURI(location) : null;
    }

    public boolean isConnected() {
        this.initialize();
        return this.environment != null ? this.environment.isConnected() : false;
    }

    public boolean isLocal() {
        this.initialize();
        return this.environment != null ? this.environment.isLocal() : false;
    }

    public Object getAdapter(Class adapter) {
        this.initialize();
        return this.environment != null ? this.environment.getAdapter(adapter) : null;
    }

    public int hashCode() {
        return this.environmentId.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof IEnvironment) {
            IEnvironment other = (IEnvironment)obj;
            return this.environmentId.equals(other.getId());
        }
        return false;
    }
}

