/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.compiler.problem;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.compiler.problem.IProblem;
import org.eclipse.dltk.compiler.problem.IProblemFactory;
import org.eclipse.dltk.compiler.problem.IProblemIdentifierExtension;
import org.eclipse.dltk.core.DLTKCore;

public class DefaultProblemFactory
implements IProblemFactory {
    public String getMarkerType(IProblem problem) {
        if (problem.getID() instanceof IProblemIdentifierExtension) {
            return ((IProblemIdentifierExtension)((Object)problem.getID())).getMarkerType();
        }
        return problem.isTask() ? this.getTaskMarkerType() : this.getProblemMarkerType();
    }

    protected String getProblemMarkerType() {
        return "org.eclipse.dltk.core.task";
    }

    protected String getTaskMarkerType() {
        return "org.eclipse.dltk.core.task";
    }

    public IMarker createMarker(IResource resource, IProblem problem) throws CoreException {
        String markerType = this.getMarkerType(problem);
        return resource.createMarker(markerType);
    }

    public void deleteMarkers(IResource resource) throws CoreException {
        resource.deleteMarkers("org.eclipse.dltk.core.problem", true, 2);
        resource.deleteMarkers("org.eclipse.dltk.core.task", true, 2);
    }

    public boolean isValidMarker(IMarker marker) {
        try {
            return this.isValidMarkerType(marker.getType());
        }
        catch (CoreException e) {
            DLTKCore.error(e);
            return false;
        }
    }

    protected boolean isValidMarkerType(String markerType) {
        return markerType.startsWith("org.eclipse.dltk");
    }
}

