/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.validation;

import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.builder.IBuildContext;
import org.eclipse.dltk.core.builder.IBuildParticipant;
import org.eclipse.dltk.internal.javascript.ti.ITypeInferenceContext;
import org.eclipse.dltk.internal.javascript.ti.IValueReference;
import org.eclipse.dltk.internal.javascript.ti.TypeInferencer2;
import org.eclipse.dltk.internal.javascript.ti.TypeInferencerVisitor;
import org.eclipse.dltk.internal.javascript.validation.JavaScriptValidations;
import org.eclipse.dltk.internal.javascript.validation.ValidationMessages;
import org.eclipse.dltk.javascript.ast.CallExpression;
import org.eclipse.dltk.javascript.ast.Expression;
import org.eclipse.dltk.javascript.ast.Identifier;
import org.eclipse.dltk.javascript.ast.PropertyExpression;
import org.eclipse.dltk.javascript.ast.Script;
import org.eclipse.dltk.javascript.core.JavaScriptProblems;
import org.eclipse.dltk.javascript.parser.Reporter;
import org.eclipse.dltk.javascript.typeinfo.model.Element;
import org.eclipse.dltk.javascript.typeinfo.model.Method;
import org.eclipse.dltk.javascript.typeinfo.model.Parameter;
import org.eclipse.dltk.javascript.typeinfo.model.ParameterKind;
import org.eclipse.dltk.javascript.typeinfo.model.Property;
import org.eclipse.dltk.javascript.typeinfo.model.Type;
import org.eclipse.dltk.javascript.typeinfo.model.TypeKind;
import org.eclipse.emf.common.util.EList;
import org.eclipse.osgi.util.NLS;

public class TypeInfoValidator
implements IBuildParticipant,
JavaScriptProblems {
    public void build(IBuildContext context) throws CoreException {
        Script script = JavaScriptValidations.parse(context);
        if (script == null) {
            return;
        }
        TypeInferencer2 inferencer = new TypeInferencer2();
        inferencer.setModelElement((IModelElement)context.getSourceModule());
        inferencer.setVisitor(new ValidationVisitor(inferencer, JavaScriptValidations.createReporter(context)));
        inferencer.doInferencing(script);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ValidationVisitor
    extends TypeInferencerVisitor {
        private final Reporter reporter;
        private final Map<ASTNode, VisitorMode> modes = new IdentityHashMap<ASTNode, VisitorMode>();
        private final Stack<ASTNode> visitStack = new Stack();

        public ValidationVisitor(ITypeInferenceContext context, Reporter reporter) {
            super(context);
            this.reporter = reporter;
        }

        public IValueReference visit(ASTNode node) {
            this.visitStack.push(node);
            try {
                IValueReference iValueReference = (IValueReference)super.visit(node);
                return iValueReference;
            }
            finally {
                this.visitStack.pop();
            }
        }

        private VisitorMode currentMode() {
            VisitorMode mode = this.modes.get(this.visitStack.peek());
            return mode != null ? mode : VisitorMode.NORMAL;
        }

        @Override
        public IValueReference visitCallExpression(CallExpression node) {
            ASTNode expression = node.getExpression();
            Object methodNode = expression instanceof PropertyExpression ? ((PropertyExpression)expression).getProperty() : expression;
            this.modes.put(expression, VisitorMode.CALL);
            IValueReference reference = this.visit(expression);
            this.modes.remove(expression);
            List callArgs = node.getArguments();
            IValueReference[] arguments = new IValueReference[callArgs.size()];
            int i = 0;
            int size = callArgs.size();
            while (i < size) {
                arguments[i] = this.visit((ASTNode)callArgs.get(i));
                ++i;
            }
            if (reference != null) {
                List<Method> methods = JavaScriptValidations.extractElements(reference, Method.class);
                if (methods != null) {
                    Method method = this.selectMethod(methods, arguments);
                    if (method == null) {
                        Type type = JavaScriptValidations.typeOf(reference.getParent());
                        if (type != null && type.getKind() == TypeKind.JAVA) {
                            this.reporter.reportProblem(0x4000002, NLS.bind((String)ValidationMessages.MethodNotSelected, (Object[])new String[]{reference.getName(), type.getName(), this.describeArgTypes(arguments)}), methodNode.sourceStart(), methodNode.sourceEnd());
                        }
                        return null;
                    }
                    if (!this.validateParameterCount(method, callArgs)) {
                        this.reporter.reportProblem(0x4000002, NLS.bind((String)ValidationMessages.MethodNotApplicable, (Object[])new String[]{method.getName(), this.describeParamTypes(method.getParameters()), method.getDeclaringType().getName(), this.describeArgTypes(arguments)}), methodNode.sourceStart(), methodNode.sourceEnd());
                    }
                    if (method.isDeprecated()) {
                        this.reporter.reportProblem(0x4000003, NLS.bind((String)ValidationMessages.DeprecatedMethod, (Object)reference.getName(), (Object)method.getDeclaringType().getName()), methodNode.sourceStart(), methodNode.sourceEnd());
                    }
                } else {
                    Type type = JavaScriptValidations.typeOf(reference.getParent());
                    if (type != null && type.getKind() == TypeKind.JAVA) {
                        this.reporter.reportProblem(0x4000001, NLS.bind((String)ValidationMessages.UndefinedMethod, (Object)reference.getName(), (Object)type.getName()), methodNode.sourceStart(), methodNode.sourceEnd());
                    }
                }
                return reference.getChild("()");
            }
            return null;
        }

        private String describeParamTypes(EList<Parameter> parameters) {
            StringBuilder sb = new StringBuilder();
            for (Parameter parameter : parameters) {
                if (sb.length() != 0) {
                    sb.append(',');
                }
                if (parameter.getType() != null) {
                    sb.append(parameter.getType().getName());
                    continue;
                }
                sb.append('?');
            }
            return sb.toString();
        }

        private String describeArgTypes(IValueReference[] arguments) {
            StringBuilder sb = new StringBuilder();
            IValueReference[] iValueReferenceArray = arguments;
            int n = arguments.length;
            int n2 = 0;
            while (n2 < n) {
                IValueReference argument = iValueReferenceArray[n2];
                if (sb.length() != 0) {
                    sb.append(',');
                }
                if (argument.getDeclaredType() != null) {
                    sb.append(argument.getDeclaredType().getName());
                } else {
                    Set<Type> types = argument.getTypes();
                    if (types.size() == 1) {
                        sb.append(types.iterator().next().getName());
                    } else {
                        sb.append('?');
                    }
                }
                ++n2;
            }
            return sb.toString();
        }

        private Method selectMethod(List<Method> methods, IValueReference[] arguments) {
            if (methods.size() == 1) {
                return methods.get(0);
            }
            Method argCountMatches = null;
            for (Method method : methods) {
                if (method.getParameters().size() != arguments.length) continue;
                if (argCountMatches == null) {
                    argCountMatches = method;
                    continue;
                }
                argCountMatches = null;
                break;
            }
            if (argCountMatches != null) {
                return argCountMatches;
            }
            return methods.get(0);
        }

        private <E extends Element> E extractElement(IValueReference reference, Class<E> elementType) {
            List<E> elements = JavaScriptValidations.extractElements(reference, elementType);
            return (E)(elements != null ? (Element)elements.get(0) : null);
        }

        private boolean validateParameterCount(Method method, List<ASTNode> callArgs) {
            EList<Parameter> params = method.getParameters();
            if (params.size() == callArgs.size()) {
                return true;
            }
            if (params.size() < callArgs.size() && !params.isEmpty() && ((Parameter)params.get(params.size() - 1)).getKind() == ParameterKind.VARARGS) {
                return true;
            }
            return params.size() > callArgs.size() && ((Parameter)params.get(callArgs.size())).getKind() == ParameterKind.OPTIONAL;
        }

        @Override
        public IValueReference visitPropertyExpression(PropertyExpression node) {
            Expression propName;
            IValueReference object = this.visit((ASTNode)node.getObject());
            IValueReference result = this.extractNamedChild(object, propName = node.getProperty());
            if (result != null) {
                if (this.currentMode() != VisitorMode.CALL) {
                    this.validateProperty(result, propName);
                }
                return result;
            }
            return null;
        }

        @Override
        public IValueReference visitIdentifier(Identifier node) {
            IValueReference result = this.peekContext().getChild(node.getName());
            Property property = this.extractElement(result, Property.class);
            if (property != null && property.isDeprecated()) {
                this.reportDeprecatedProperty(property, null, (ASTNode)node);
            }
            return result;
        }

        private void validateProperty(IValueReference result, Expression propName) {
            Type type;
            Property property = this.extractElement(result, Property.class);
            if (property != null) {
                if (property.isDeprecated()) {
                    Property parentProperty = this.extractElement(result.getParent(), Property.class);
                    if (parentProperty != null && parentProperty.getDeclaringType() == null) {
                        this.reportDeprecatedProperty(property, parentProperty, (ASTNode)propName);
                    } else {
                        this.reportDeprecatedProperty(property, property.getDeclaringType(), (ASTNode)propName);
                    }
                }
            } else if (JavaScriptValidations.extractElements(result, Method.class) == null && (type = JavaScriptValidations.typeOf(result.getParent())) != null && type.getKind() == TypeKind.JAVA) {
                this.reporter.reportProblem(0x2000001, NLS.bind((String)ValidationMessages.UndefinedProperty, (Object)result.getName(), (Object)type.getName()), propName.sourceStart(), propName.sourceEnd());
            }
        }

        private void reportDeprecatedProperty(Property property, Element owner, ASTNode node) {
            String msg = owner instanceof Type ? NLS.bind((String)ValidationMessages.DeprecatedProperty, (Object)property.getName(), (Object)owner.getName()) : (owner instanceof Property ? NLS.bind((String)ValidationMessages.DeprecatedPropertyOfInstance, (Object)property.getName(), (Object)owner.getName()) : NLS.bind((String)ValidationMessages.DeprecatedPropertyNoType, (Object)property.getName()));
            this.reporter.reportProblem(0x2000002, msg, node.sourceStart(), node.sourceEnd());
        }

        @Override
        protected Type resolveType(org.eclipse.dltk.javascript.ast.Type type) {
            Type result = super.resolveType(type);
            if (result != null) {
                if (result.getKind() == TypeKind.UNKNOWN) {
                    this.reporter.reportProblem(0x1000001, NLS.bind((String)ValidationMessages.UnknownType, (Object)type.getName()), type.sourceStart(), type.sourceEnd());
                } else if (result.isDeprecated()) {
                    this.reporter.reportProblem(0x1000002, NLS.bind((String)ValidationMessages.DeprecatedType, (Object)type.getName()), type.sourceStart(), type.sourceEnd());
                }
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum VisitorMode {
        NORMAL,
        CALL;

    }
}

