/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.ti;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.internal.javascript.ti.ITypeInferenceContext;
import org.eclipse.dltk.internal.javascript.ti.IValueCollection;
import org.eclipse.dltk.internal.javascript.ti.IValueReference;
import org.eclipse.dltk.internal.javascript.ti.IValueTypeFactory;
import org.eclipse.dltk.internal.javascript.ti.PositionReachedException;
import org.eclipse.dltk.internal.javascript.ti.TypeInferencerVisitor;
import org.eclipse.dltk.internal.javascript.ti.ValueTypeFactoryImpl;
import org.eclipse.dltk.javascript.ast.Script;
import org.eclipse.dltk.javascript.core.JavaScriptPlugin;
import org.eclipse.dltk.javascript.typeinfo.IElementResolver;
import org.eclipse.dltk.javascript.typeinfo.ITypeProvider;
import org.eclipse.dltk.javascript.typeinfo.TypeInfoManager;
import org.eclipse.dltk.javascript.typeinfo.model.Element;
import org.eclipse.dltk.javascript.typeinfo.model.Type;
import org.eclipse.dltk.javascript.typeinfo.model.TypeInfoModelFactory;
import org.eclipse.dltk.javascript.typeinfo.model.TypeInfoModelLoader;
import org.eclipse.dltk.javascript.typeinfo.model.TypeKind;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeInferencer2
implements ITypeInferenceContext {
    private TypeInferencerVisitor visitor;
    private IModelElement modelElement;
    private final Map<String, Type> types = new HashMap<String, Type>();
    private final Set<String> activeTypeRequests = new HashSet<String>();
    private static final String PROXY_SCHEME = "proxy";
    private static final String PROXY_OPAQUE_PART = "dltk/javascript/typeinfo/type";
    private final ResourceSet typeRS = new TypeResourceSet();
    private Resource typesResource = null;
    private IValueTypeFactory factory = new ValueTypeFactoryImpl(this);
    private Map<String, Element> elements = new HashMap<String, Element>();

    private void initializeVisitor() {
        if (this.visitor == null) {
            this.visitor = new TypeInferencerVisitor(this);
        } else {
            this.visitor.initialize();
        }
    }

    public void setVisitor(TypeInferencerVisitor visitor) {
        this.visitor = visitor;
    }

    public void setModelElement(IModelElement modelElement) {
        this.modelElement = modelElement;
    }

    public void doInferencing(Script script) {
        try {
            this.initializeVisitor();
            this.visitor.visit((ASTNode)script);
        }
        catch (PositionReachedException e) {
            throw e;
        }
        catch (RuntimeException e) {
            this.log(e);
        }
        catch (AssertionError e) {
            this.log((Throwable)((Object)e));
        }
    }

    protected void log(Throwable e) {
        JavaScriptPlugin.error(e);
    }

    public IValueReference evaluate(ASTNode node) {
        this.initializeVisitor();
        return (IValueReference)this.visitor.visit(node);
    }

    public IValueCollection getCollection() {
        return this.visitor.getCollection();
    }

    @Override
    public Type getType(String typeName) {
        boolean queryProviders;
        if (typeName == null || typeName.length() == 0) {
            return null;
        }
        return this.getType(typeName, queryProviders, true, !(queryProviders = this.canQueryTypeProviders()), true);
    }

    @Override
    public Set<String> listTypes(String prefix) {
        HashSet<String> result = new HashSet<String>();
        Set<String> typeNames = TypeInfoModelLoader.getInstance().listTypes(prefix);
        if (typeNames != null) {
            result.addAll(typeNames);
        }
        ITypeProvider[] iTypeProviderArray = TypeInfoManager.getTypeProviders();
        int n = iTypeProviderArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeProvider provider = iTypeProviderArray[n2];
            typeNames = provider.listTypes(this, prefix);
            if (typeNames != null) {
                result.addAll(typeNames);
            }
            ++n2;
        }
        return result;
    }

    @Override
    public IModelElement getModelElement() {
        return this.modelElement;
    }

    private Type getType(String typeName, boolean queryProviders, boolean queryPredefined, boolean allowProxy, boolean allowUnknown) {
        Type type = this.types.get(typeName);
        if (type != null) {
            return type;
        }
        type = this.loadType(typeName, queryProviders, queryPredefined);
        if (type != null) {
            this.types.put(typeName, type);
            this.addToResource(type);
            return type;
        }
        if (allowProxy) {
            type = this.createProxy(typeName);
            return type;
        }
        if (allowUnknown) {
            type = this.createUnknown(typeName);
            this.addToResource(type);
            this.types.put(typeName, type);
            return type;
        }
        return null;
    }

    private Type createUnknown(String typeName) {
        Type type = TypeInfoModelFactory.eINSTANCE.createType();
        type.setName(typeName);
        type.setKind(TypeKind.UNKNOWN);
        return type;
    }

    private boolean canQueryTypeProviders() {
        return this.activeTypeRequests.isEmpty();
    }

    private Type loadType(String typeName, boolean queryProviders, boolean queryPredefined) {
        Type type;
        if (queryProviders && this.activeTypeRequests.add(typeName)) {
            try {
                ITypeProvider[] iTypeProviderArray = TypeInfoManager.getTypeProviders();
                int n = iTypeProviderArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ITypeProvider provider = iTypeProviderArray[n2];
                    Type type2 = provider.getType(this, typeName);
                    if (type2 != null && !this.isProxy(type2)) {
                        Type type3 = type2;
                        return type3;
                    }
                    ++n2;
                }
            }
            finally {
                this.activeTypeRequests.remove(typeName);
            }
        }
        if (queryPredefined && (type = TypeInfoModelLoader.getInstance().getType(typeName)) != null) {
            return type;
        }
        return null;
    }

    private void addToResource(Type type) {
        EObject object = (EObject)type;
        if (object.eResource() == null) {
            if (this.typesResource == null) {
                this.typesResource = new ResourceImpl(URI.createGenericURI((String)PROXY_SCHEME, (String)PROXY_OPAQUE_PART, null));
                this.typeRS.getResources().add((Object)this.typesResource);
            }
            this.typesResource.getContents().add((Object)object);
        }
    }

    private Type createProxy(String typeName) {
        Type type = TypeInfoModelFactory.eINSTANCE.createType();
        ((InternalEObject)type).eSetProxyURI(URI.createGenericURI((String)PROXY_SCHEME, (String)PROXY_OPAQUE_PART, (String)typeName));
        return type;
    }

    private boolean isProxy(Type type) {
        return type instanceof EObject && ((EObject)type).eIsProxy();
    }

    @Override
    public IValueTypeFactory getFactory() {
        return this.factory;
    }

    @Override
    public Element resolve(String name) {
        Element element = this.elements.get(name);
        if (element != null) {
            return element;
        }
        IElementResolver[] iElementResolverArray = TypeInfoManager.getElementResolvers();
        int n = iElementResolverArray.length;
        int n2 = 0;
        while (n2 < n) {
            IElementResolver resolver = iElementResolverArray[n2];
            element = resolver.resolveElement(this, name);
            if (element != null) {
                this.elements.put(name, element);
                return element;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public Set<String> listGlobals(String prefix) {
        HashSet<String> result = new HashSet<String>();
        IElementResolver[] iElementResolverArray = TypeInfoManager.getElementResolvers();
        int n = iElementResolverArray.length;
        int n2 = 0;
        while (n2 < n) {
            IElementResolver resolver = iElementResolverArray[n2];
            Set<String> globals = resolver.listGlobals(this, prefix);
            if (globals != null) {
                result.addAll(globals);
            }
            ++n2;
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum TypeResolveMode {
        SIMPLE,
        PROXY,
        UNKNOWN;

    }

    private class TypeResourceSet
    extends ResourceSetImpl {
        private TypeResourceSet() {
        }

        public EObject getEObject(URI uri, boolean loadOnDemand) {
            if (TypeInferencer2.PROXY_SCHEME.equals(uri.scheme()) && TypeInferencer2.PROXY_OPAQUE_PART.equals(uri.opaquePart())) {
                Type type = TypeInferencer2.this.getType(uri.fragment(), true, false, false, false);
                if (type == null) {
                    return (EObject)TypeInferencer2.this.createUnknown(uri.fragment());
                }
                if (type instanceof EObject) {
                    return (EObject)type;
                }
                JavaScriptPlugin.error("proxy resolved to " + type.getClass().getName() + " which is not EObject");
                return (EObject)TypeInferencer2.this.createUnknown(uri.fragment());
            }
            return super.getEObject(uri, loadOnDemand);
        }
    }
}

