/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtbot.swt.finder.widgets;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swtbot.swt.finder.ReferenceBy;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.swtbot.swt.finder.SWTBotWidget;
import org.eclipse.swtbot.swt.finder.exceptions.WidgetNotFoundException;
import org.eclipse.swtbot.swt.finder.matchers.WidgetMatcherFactory;
import org.eclipse.swtbot.swt.finder.results.ArrayResult;
import org.eclipse.swtbot.swt.finder.results.BoolResult;
import org.eclipse.swtbot.swt.finder.results.IntResult;
import org.eclipse.swtbot.swt.finder.results.ListResult;
import org.eclipse.swtbot.swt.finder.results.Result;
import org.eclipse.swtbot.swt.finder.results.StringResult;
import org.eclipse.swtbot.swt.finder.results.WidgetResult;
import org.eclipse.swtbot.swt.finder.utils.MessageFormat;
import org.eclipse.swtbot.swt.finder.utils.StringUtils;
import org.eclipse.swtbot.swt.finder.utils.TableCollection;
import org.eclipse.swtbot.swt.finder.utils.TableRow;
import org.eclipse.swtbot.swt.finder.utils.internal.Assert;
import org.eclipse.swtbot.swt.finder.waits.DefaultCondition;
import org.eclipse.swtbot.swt.finder.waits.ICondition;
import org.eclipse.swtbot.swt.finder.widgets.AbstractSWTBotControl;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeColumn;
import org.eclipse.swtbot.swt.finder.widgets.SiriusSWTBotTreeItem;
import org.eclipse.swtbot.swt.finder.widgets.TimeoutException;
import org.hamcrest.Matcher;
import org.hamcrest.SelfDescribing;

@SWTBotWidget(clasz=Tree.class, preferredName="tree", referenceBy={ReferenceBy.LABEL})
public class SiriusSWTBotTree
extends AbstractSWTBotControl<Tree> {
    public SiriusSWTBotTree(Tree tree, SelfDescribing description) throws WidgetNotFoundException {
        super((Control)tree, description);
    }

    public SiriusSWTBotTree(Tree tree) throws WidgetNotFoundException {
        this(tree, null);
    }

    public static SiriusSWTBotTree tree(SWTBot bot) {
        return SiriusSWTBotTree.tree(bot, 0);
    }

    public static SiriusSWTBotTree tree(SWTBot bot, int index) {
        Matcher matcher = WidgetMatcherFactory.allOf((Matcher[])new Matcher[]{WidgetMatcherFactory.widgetOfType(Tree.class)});
        return new SiriusSWTBotTree((Tree)bot.widget(matcher, index), (SelfDescribing)matcher);
    }

    public int rowCount() {
        return this.syncExec(new IntResult(){

            public Integer run() {
                return ((Tree)SiriusSWTBotTree.this.widget).getItems().length;
            }
        });
    }

    public int columnCount() {
        return this.syncExec(new IntResult(){

            public Integer run() {
                return ((Tree)SiriusSWTBotTree.this.widget).getColumnCount();
            }
        });
    }

    public List<String> columns() {
        final int columnCount = this.columnCount();
        return this.syncExec((ListResult)new ListResult<String>(){

            public List<String> run() {
                String[] columns = new String[columnCount];
                int i = 0;
                while (i < columnCount) {
                    columns[i] = ((Tree)SiriusSWTBotTree.this.widget).getColumn(i).getText();
                    ++i;
                }
                return new ArrayList<String>(Arrays.asList(columns));
            }
        });
    }

    public SWTBotTreeColumn header(final String label) throws WidgetNotFoundException {
        TreeColumn column = (TreeColumn)this.syncExec((Result)new Result<TreeColumn>(){

            public TreeColumn run() {
                TreeColumn[] columns;
                TreeColumn[] treeColumnArray = columns = ((Tree)SiriusSWTBotTree.this.widget).getColumns();
                int n = columns.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeColumn column = treeColumnArray[n2];
                    if (column.getText().equals(label)) {
                        return column;
                    }
                    ++n2;
                }
                return null;
            }
        });
        return new SWTBotTreeColumn(column, (Tree)this.widget);
    }

    public String cell(final int row, final int column) {
        int rowCount = this.rowCount();
        int columnCount = this.columnCount();
        Assert.isLegal((row < rowCount ? 1 : 0) != 0, (Object)("The row number (" + row + ") is more than the number of rows(" + rowCount + ") in the tree."));
        Assert.isLegal((column < columnCount ? 1 : 0) != 0, (Object)("The column number (" + column + ") is more than the number of column(" + columnCount + ") in the tree."));
        return this.syncExec(new StringResult(){

            public String run() {
                TreeItem item = ((Tree)SiriusSWTBotTree.this.widget).getItem(row);
                return item.getText(column);
            }
        });
    }

    public String cell(int row, String columnName) {
        List<String> columns = this.columns();
        Assert.isLegal((boolean)columns.contains(columnName), (Object)("The column `" + columnName + "' is not found."));
        int columnIndex = columns.indexOf(columnName);
        if (columnIndex == -1) {
            return "";
        }
        return this.cell(row, columnIndex);
    }

    public int selectionCount() {
        return this.syncExec(new IntResult(){

            public Integer run() {
                return ((Tree)SiriusSWTBotTree.this.widget).getSelectionCount();
            }
        });
    }

    public TableCollection selection() {
        final int columnCount = this.columnCount();
        return (TableCollection)this.syncExec((Result)new Result<TableCollection>(){

            public TableCollection run() {
                TreeItem[] items;
                TableCollection selection = new TableCollection();
                TreeItem[] treeItemArray = items = ((Tree)SiriusSWTBotTree.this.widget).getSelection();
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem item = treeItemArray[n2];
                    TableRow tableRow = new TableRow();
                    if (columnCount == 0) {
                        tableRow.add(item.getText());
                    } else {
                        int j = 0;
                        while (j < columnCount) {
                            tableRow.add(item.getText(j));
                            ++j;
                        }
                    }
                    selection.add(tableRow);
                    ++n2;
                }
                return selection;
            }
        });
    }

    public SiriusSWTBotTree select(String ... items) {
        this.waitForEnabled();
        this.setFocus();
        if (items.length > 1) {
            this.assertMultiSelect();
        } else if (items.length == 0) {
            return this.unselect();
        }
        ArrayList<TreeItem> selection = new ArrayList<TreeItem>();
        String[] stringArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            SiriusSWTBotTreeItem si = this.getTreeItem(item);
            selection.add((TreeItem)si.widget);
            ++n2;
        }
        int i = 0;
        while (i < selection.size()) {
            int stateMask = i == 0 ? 0 : SWT.MOD1;
            this.notifySelect((TreeItem)selection.get(i), stateMask);
            ++i;
        }
        return this;
    }

    public SiriusSWTBotTree select(SiriusSWTBotTreeItem ... items) {
        this.assertEnabled();
        this.setFocus();
        if (items.length > 1) {
            this.assertMultiSelect();
        } else if (items.length == 0) {
            return this.unselect();
        }
        int i = 0;
        while (i < items.length) {
            int stateMask = i == 0 ? 0 : SWT.MOD1;
            this.notifySelect((TreeItem)items[i].widget, stateMask);
            ++i;
        }
        return this;
    }

    public void selectAll() {
        this.assertMultiSelect();
        this.waitForEnabled();
        this.setFocus();
        TreeItem first = (TreeItem)this.syncExec((Result)new Result<TreeItem>(){

            public TreeItem run() {
                if (((Tree)SiriusSWTBotTree.this.widget).getItemCount() == 0) {
                    return null;
                }
                return ((Tree)SiriusSWTBotTree.this.widget).getItem(0);
            }
        });
        if (first == null) {
            return;
        }
        this.notifySelect(first, 0);
        TreeItem last = (TreeItem)this.syncExec((Result)new Result<TreeItem>(){

            public TreeItem run() {
                if (((Tree)SiriusSWTBotTree.this.widget).getItemCount() == 0) {
                    return null;
                }
                TreeItem last = ((Tree)SiriusSWTBotTree.this.widget).getItem(((Tree)SiriusSWTBotTree.this.widget).getItemCount() - 1);
                while (last.getExpanded() && last.getItemCount() > 0) {
                    last = last.getItem(last.getItemCount() - 1);
                }
                return last;
            }
        });
        if (last != null && last != first) {
            this.notifySelect(last, SWT.MOD2, this.selectAllRunnable());
        }
    }

    private Runnable selectAllRunnable() {
        return new Runnable(){

            @Override
            public void run() {
                ((Tree)SiriusSWTBotTree.this.widget).selectAll();
            }
        };
    }

    public SiriusSWTBotTree unselect() {
        TreeItem[] selection;
        this.waitForEnabled();
        this.log.debug(MessageFormat.format((String)"Unselecting all in {0}", (Object[])new Object[]{this}).toString());
        TreeItem[] treeItemArray = selection = (TreeItem[])this.syncExec((ArrayResult)new ArrayResult<TreeItem>(){

            public TreeItem[] run() {
                return ((Tree)SiriusSWTBotTree.this.widget).getSelection();
            }
        });
        int n = selection.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            this.notifyUnselect(item);
            ++n2;
        }
        return this;
    }

    private Runnable unselectRunnable(final TreeItem item) {
        return new Runnable(){

            @Override
            public void run() {
                ((Tree)SiriusSWTBotTree.this.widget).deselect(item);
            }
        };
    }

    public SiriusSWTBotTree select(int ... indices) {
        this.waitForEnabled();
        this.setFocus();
        if (indices.length > 1) {
            this.assertMultiSelect();
        } else if (indices.length == 0) {
            return this.unselect();
        }
        ArrayList<TreeItem> selection = new ArrayList<TreeItem>();
        int[] nArray = indices;
        int n = indices.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            selection.add(this.getItem(index));
            ++n2;
        }
        this.log.debug(MessageFormat.format((String)"Selecting rows {0} in {1}", (Object[])new Object[]{Arrays.toString(indices), this}).toString());
        int i = 0;
        while (i < selection.size()) {
            int stateMask = i == 0 ? 0 : SWT.MOD1;
            this.notifySelect((TreeItem)selection.get(i), stateMask);
            ++i;
        }
        return this;
    }

    private Runnable selectRunnable(final TreeItem item, final boolean add) {
        return new Runnable(){

            @Override
            public void run() {
                if (add) {
                    ((Tree)SiriusSWTBotTree.this.widget).select(item);
                } else {
                    ((Tree)SiriusSWTBotTree.this.widget).setSelection(item);
                }
            }
        };
    }

    @Deprecated
    protected void notifySelect() {
    }

    private void notifyUnselect(TreeItem unselected) {
        this.notifySelect(unselected, SWT.MOD1, this.unselectRunnable(unselected));
    }

    private void notifySelect(TreeItem selected, int stateMask) {
        this.notifySelect(selected, stateMask, this.selectRunnable(selected, (stateMask & SWT.MOD1) != 0));
    }

    private void notifySelect(TreeItem selected, int stateMask, Runnable runnable) {
        SiriusSWTBotTreeItem item = new SiriusSWTBotTreeItem(selected);
        this.notify(6);
        this.notify(5);
        this.notify(26);
        this.notify(15);
        this.notify(3, item.createMouseEvent(1, stateMask, 1));
        this.notify(13, item.createSelectionEvent(stateMask | 0x80000), this.widget, runnable);
        this.notify(4, item.createMouseEvent(1, stateMask | 0x80000, 1));
    }

    public SiriusSWTBotTreeItem expandNode(String ... nodes) throws WidgetNotFoundException {
        Assert.isNotEmpty((Object[])nodes);
        this.log.debug(MessageFormat.format((String)"Expanding nodes {0} in tree {1}", (Object[])new Object[]{StringUtils.join((Object[])nodes, (String)">"), this}).toString());
        this.waitForEnabled();
        SiriusSWTBotTreeItem item = this.getTreeItem(nodes[0]).expand();
        String[] tail = new String[nodes.length - 1];
        System.arraycopy(nodes, 1, tail, 0, nodes.length - 1);
        if (tail.length > 0) {
            item = item.expandNode(tail);
        }
        return item;
    }

    public SiriusSWTBotTreeItem collapseNode(String nodeText) throws WidgetNotFoundException {
        this.waitForEnabled();
        return this.getTreeItem(nodeText).collapse();
    }

    public int visibleRowCount() {
        return this.syncExec(new IntResult(){

            public Integer run() {
                TreeItem[] items = ((Tree)SiriusSWTBotTree.this.widget).getItems();
                return this.getVisibleChildrenCount(items);
            }

            private int getVisibleChildrenCount(TreeItem item) {
                if (item.getExpanded()) {
                    return this.getVisibleChildrenCount(item.getItems());
                }
                return 0;
            }

            private int getVisibleChildrenCount(TreeItem[] items) {
                int count = 0;
                TreeItem[] treeItemArray = items;
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem item = treeItemArray[n2];
                    int j = this.getVisibleChildrenCount(item) + 1;
                    count += j;
                    ++n2;
                }
                return count;
            }
        });
    }

    public SiriusSWTBotTreeItem expandNode(final String nodeText, final boolean recursive) throws WidgetNotFoundException {
        this.waitForEnabled();
        return (SiriusSWTBotTreeItem)((Object)this.syncExec((Result)new Result<SiriusSWTBotTreeItem>(){

            public SiriusSWTBotTreeItem run() {
                SiriusSWTBotTreeItem item;
                try {
                    item = SiriusSWTBotTree.this.getTreeItem(nodeText);
                    this.expandNode(item);
                }
                catch (WidgetNotFoundException e) {
                    throw new RuntimeException(e);
                }
                return item;
            }

            private void expandNode(SiriusSWTBotTreeItem item) throws WidgetNotFoundException {
                item.expand();
                if (recursive) {
                    this.expandTreeItem((TreeItem)item.widget);
                }
            }

            private void expandTreeItem(TreeItem node) throws WidgetNotFoundException {
                TreeItem[] items;
                TreeItem[] treeItemArray = items = node.getItems();
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem item = treeItemArray[n2];
                    this.expandNode(new SiriusSWTBotTreeItem(item));
                    ++n2;
                }
            }
        }));
    }

    public SiriusSWTBotTreeItem getTreeItem(final String nodeText) throws WidgetNotFoundException {
        try {
            new SWTBot().waitUntil((ICondition)new DefaultCondition(){

                public String getFailureMessage() {
                    return "Could not find node with text " + nodeText;
                }

                public boolean test() throws Exception {
                    return SiriusSWTBotTree.this.getItem(nodeText) != null;
                }
            });
        }
        catch (TimeoutException e) {
            throw new WidgetNotFoundException("Timed out waiting for tree item " + nodeText, (Throwable)e);
        }
        return new SiriusSWTBotTreeItem(this.getItem(nodeText));
    }

    private TreeItem getItem(final int index) {
        return (TreeItem)this.syncExec((Result)new WidgetResult<TreeItem>(){

            public TreeItem run() {
                return ((Tree)SiriusSWTBotTree.this.widget).getItem(index);
            }
        });
    }

    private TreeItem getItem(final String nodeText) {
        return (TreeItem)this.syncExec((Result)new WidgetResult<TreeItem>(){

            public TreeItem run() {
                TreeItem[] items;
                TreeItem[] treeItemArray = items = ((Tree)SiriusSWTBotTree.this.widget).getItems();
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem item = treeItemArray[n2];
                    if (item.getText().equals(nodeText)) {
                        return item;
                    }
                    ++n2;
                }
                return null;
            }
        });
    }

    public SiriusSWTBotTreeItem[] getAllItems() {
        return (SiriusSWTBotTreeItem[])this.syncExec((ArrayResult)new ArrayResult<SiriusSWTBotTreeItem>(){

            public SiriusSWTBotTreeItem[] run() {
                TreeItem[] items = ((Tree)SiriusSWTBotTree.this.widget).getItems();
                SiriusSWTBotTreeItem[] result = new SiriusSWTBotTreeItem[items.length];
                int i = 0;
                while (i < items.length) {
                    try {
                        result[i] = new SiriusSWTBotTreeItem(items[i]);
                    }
                    catch (WidgetNotFoundException widgetNotFoundException) {
                        return new SiriusSWTBotTreeItem[0];
                    }
                    ++i;
                }
                return result;
            }
        });
    }

    public boolean hasItems() {
        return this.syncExec(new BoolResult(){

            public Boolean run() {
                if (((Tree)SiriusSWTBotTree.this.widget).getItemCount() > 0) {
                    return true;
                }
                return false;
            }
        });
    }

    private void assertMultiSelect() {
        Assert.isLegal((boolean)this.hasStyle(this.widget, 2), (Object)"Tree does not support SWT.MULTI, cannot make multiple selections.");
    }

    public void waitForEnabled() {
        super.waitForEnabled();
    }
}

