/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.actions;

import java.util.List;
import java.util.ListIterator;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.diagram.ui.actions.internal.RouterAction;
import org.eclipse.gmf.runtime.diagram.ui.actions.internal.l10n.DiagramUIActionsMessages;
import org.eclipse.gmf.runtime.diagram.ui.actions.internal.l10n.DiagramUIActionsPluginImages;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ITreeBranchEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.l10n.DiagramUIPluginImages;
import org.eclipse.gmf.runtime.notation.Routing;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IWorkbenchPage;

public class TabbarRouterAction
extends RouterAction {
    public TabbarRouterAction(IWorkbenchPage workbenchPage, Routing routerType) {
        super(workbenchPage, routerType);
    }

    protected boolean calculateEnabled() {
        Command command;
        if ("treeRoutingStyleAction".equals(this.getId())) {
            List selected = this.getSelectedObjects();
            if (selected.size() < 1) {
                return false;
            }
            ListIterator li = this.getOperationSet().listIterator();
            while (li.hasNext()) {
                if (li.next() instanceof ITreeBranchEditPart) continue;
                return false;
            }
        }
        return (command = this.getCommand()) != null && command.canExecute();
    }

    public static RouterAction createTreeRouterAction(IWorkbenchPage workbenchPage) {
        TabbarRouterAction action = new TabbarRouterAction(workbenchPage, Routing.TREE_LITERAL);
        action.setId("treeRoutingStyleAction");
        action.setText(DiagramUIActionsMessages.ChangeRouterAction_Tree_ActionLabelText);
        action.setToolTipText(DiagramUIActionsMessages.ChangeRouterAction_Tree_ActionToolTipText);
        ImageDescriptor enabledImage = DiagramUIPluginImages.DESC_CHANGEROUTERACTION_TREE;
        action.setImageDescriptor(enabledImage);
        action.setDisabledImageDescriptor(DiagramUIPluginImages.DESC_CHANGEROUTERACTION_TREE_DISABLED);
        action.setHoverImageDescriptor(enabledImage);
        return action;
    }

    public static RouterAction createRectilinearRouterAction(IWorkbenchPage workbenchPage) {
        TabbarRouterAction action = new TabbarRouterAction(workbenchPage, Routing.RECTILINEAR_LITERAL);
        action.setId("rectilinearRoutingStyleAction");
        action.setText(DiagramUIActionsMessages.ChangeRouterAction_Rectilinear_ActionLabelText);
        action.setToolTipText(DiagramUIActionsMessages.ChangeRouterAction_Rectilinear_ActionToolTipText);
        action.setImageDescriptor(DiagramUIActionsPluginImages.DESC_CHANGEROUTERACTION_RECTILINEAR);
        action.setDisabledImageDescriptor(DiagramUIActionsPluginImages.DESC_CHANGEROUTERACTION_RECTILINEAR_DISABLED);
        action.setHoverImageDescriptor(DiagramUIActionsPluginImages.DESC_CHANGEROUTERACTION_RECTILINEAR);
        return action;
    }

    public static RouterAction createObliqueRouterAction(IWorkbenchPage workbenchPage) {
        TabbarRouterAction action = new TabbarRouterAction(workbenchPage, Routing.MANUAL_LITERAL);
        action.setId("obliqueRoutingStyleAction");
        action.setText(DiagramUIActionsMessages.ChangeRouterAction_Oblique_ActionLabelText);
        action.setToolTipText(DiagramUIActionsMessages.ChangeRouterAction_Oblique_ActionToolTipText);
        ImageDescriptor enabledImage = DiagramUIPluginImages.DESC_CHANGEROUTERACTION_OBLIQUE;
        action.setImageDescriptor(enabledImage);
        action.setDisabledImageDescriptor(DiagramUIPluginImages.DESC_CHANGEROUTERACTION_OBLIQUE_DISABLED);
        action.setHoverImageDescriptor(enabledImage);
        return action;
    }
}

