/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.graphical.edit.policies;

import java.util.Iterator;
import java.util.Optional;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.figures.ResizableCompartmentFigure;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.description.AbstractNodeMapping;
import org.eclipse.sirius.diagram.description.NodeMapping;
import org.eclipse.sirius.diagram.description.tool.ContainerCreationDescription;
import org.eclipse.sirius.diagram.description.tool.NodeCreationDescription;
import org.eclipse.sirius.diagram.model.business.internal.helper.MappingHelper;
import org.eclipse.sirius.diagram.tools.api.command.IDiagramCommandFactory;
import org.eclipse.sirius.diagram.tools.api.command.IDiagramCommandFactoryProvider;
import org.eclipse.sirius.diagram.ui.business.internal.query.RequestQuery;
import org.eclipse.sirius.diagram.ui.business.internal.view.RootLayoutData;
import org.eclipse.sirius.diagram.ui.edit.api.part.AbstractDiagramContainerEditPart;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.CreationUtil;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.SiriusContainerEditPolicy;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.AbstractDNodeListCompartmentEditPart;
import org.eclipse.sirius.diagram.ui.tools.api.draw2d.ui.figures.FigureUtilities;
import org.eclipse.sirius.diagram.ui.tools.api.editor.DDiagramEditor;
import org.eclipse.sirius.viewpoint.description.RepresentationElementMapping;
import org.eclipse.sirius.viewpoint.description.tool.AbstractToolDescription;

public class NodeCreationEditPolicy
extends SiriusContainerEditPolicy {
    protected Command getCreateCommand(CreateRequest request) {
        AbstractToolDescription tool = this.getTool(request);
        GraphicalEditPart hostEditPartToUse = (GraphicalEditPart)this.getHost();
        if (this.getHost() instanceof GraphicalEditPart) {
            boolean isBorderNodeCreationRequest = new RequestQuery((Request)request).isDropOrCreationOfBorderNode();
            if (tool instanceof NodeCreationDescription) {
                Optional<GraphicalEditPart> optionalEditPartToUse;
                NodeCreationDescription nodeCreationDescriptionTool = (NodeCreationDescription)tool;
                if (isBorderNodeCreationRequest && (optionalEditPartToUse = this.getParentEditPartWithExpectedMapping((GraphicalEditPart)this.getHost(), (EList<AbstractNodeMapping>)nodeCreationDescriptionTool.getExtraMappings(), (EList<NodeMapping>)nodeCreationDescriptionTool.getNodeMappings())).isPresent()) {
                    hostEditPartToUse = optionalEditPartToUse.get();
                }
            }
        }
        if (!(hostEditPartToUse.getModel() instanceof Node)) {
            return null;
        }
        EObject containerElement = ((Node)hostEditPartToUse.getModel()).getElement();
        Command result = null;
        if (containerElement instanceof DDiagramElementContainer) {
            DDiagramElementContainer viewNodeContainer = (DDiagramElementContainer)containerElement;
            if (tool instanceof NodeCreationDescription) {
                result = this.getCreateNodeInContainerCommand(request, (NodeCreationDescription)tool, viewNodeContainer, (EditPart)hostEditPartToUse);
            } else if (tool instanceof ContainerCreationDescription) {
                result = this.getCreateContainerInContainerCommand(request, (ContainerCreationDescription)tool, viewNodeContainer);
            }
        } else if (containerElement instanceof DNode) {
            DNode viewNode = (DNode)containerElement;
            if (tool instanceof NodeCreationDescription) {
                result = this.getCreateNodeOnNodeCommand(request, (NodeCreationDescription)tool, viewNode, (EditPart)hostEditPartToUse);
            }
        }
        return result;
    }

    protected Command getCreateNodeOnNodeCommand(CreateRequest request, NodeCreationDescription tool, DNode viewnode, EditPart parentEditPartToUse) {
        CreationUtil creationUtil = new CreationUtil(this.getDiagramCommandFactory(), this.getRealLayoutData(request, parentEditPartToUse), parentEditPartToUse);
        return creationUtil.getNodeCreationCommand(viewnode, tool);
    }

    protected Command getCreateContainerInContainerCommand(CreateRequest request, ContainerCreationDescription tool, DDiagramElementContainer viewNodeContainer) {
        CreationUtil creationUtil = new CreationUtil(request, this.getDiagramCommandFactory(), this.getRealLocation(request, this.getHost()), this.getHost());
        return creationUtil.getContainerCreationDescription(viewNodeContainer, tool);
    }

    protected Command getCreateNodeInContainerCommand(CreateRequest request, NodeCreationDescription tool, DDiagramElementContainer viewNodeContainer, EditPart parentEditPartToUse) {
        CreationUtil creationUtil = new CreationUtil(this.getDiagramCommandFactory(), this.getRealLayoutData(request, parentEditPartToUse), parentEditPartToUse);
        return creationUtil.getNodeCreationCommand(viewNodeContainer, tool);
    }

    protected AbstractToolDescription getTool(CreateRequest request) {
        if (request.getNewObject() instanceof AbstractToolDescription) {
            return (AbstractToolDescription)request.getNewObject();
        }
        return null;
    }

    protected Point getRealLocation(CreateRequest request, EditPart parentEditPartToUse) {
        return this.getRealLayoutData(request, parentEditPartToUse).getLocation();
    }

    protected RootLayoutData getRealLayoutData(CreateRequest request, EditPart parentEditPartToUse) {
        Point realLocation;
        Point location = request.getLocation().getCopy();
        if (location != null && parentEditPartToUse instanceof GraphicalEditPart) {
            GraphicalEditPart graphicalParentEditPart = (GraphicalEditPart)parentEditPartToUse;
            IFigure fig = graphicalParentEditPart.getFigure();
            fig.translateToRelative((Translatable)location);
            Point containerLocation = fig.getBounds().getLocation();
            location = new Point(location.x - containerLocation.x, location.y - containerLocation.y);
            if (fig instanceof ResizableCompartmentFigure) {
                boolean isBorderNodeCreationRequest = new RequestQuery((Request)request).isDropOrCreationOfBorderNode();
                Point scrollOffset = isBorderNodeCreationRequest ? new Point(0, 0) : ((ResizableCompartmentFigure)fig).getScrollPane().getViewport().getViewLocation();
                Point shiftFromMarginOffset = FigureUtilities.getShiftFromMarginOffset((ResizableCompartmentFigure)fig, isBorderNodeCreationRequest, parentEditPartToUse);
                realLocation = new Point(location.x + scrollOffset.x - shiftFromMarginOffset.x, location.y + scrollOffset.y - shiftFromMarginOffset.y);
            } else {
                realLocation = location;
            }
        } else {
            realLocation = location;
        }
        return new RootLayoutData(parentEditPartToUse, realLocation.getCopy(), CreationUtil.adaptRequestSizeToZoomFactor(request, parentEditPartToUse));
    }

    private Optional<GraphicalEditPart> getParentEditPartWithExpectedMapping(GraphicalEditPart editPart, EList<AbstractNodeMapping> extraMappings, EList<NodeMapping> nodeMappings) {
        Iterator iterator;
        AbstractDNode abstractDNode;
        RepresentationElementMapping representationElementMapping;
        Node node;
        EObject eObject;
        Object object;
        Optional<GraphicalEditPart> result = Optional.empty();
        AbstractNodeMapping currentEditPartMapping = null;
        if (editPart != null && (object = editPart.getModel()) instanceof Node && (eObject = (node = (Node)object).getElement()) instanceof AbstractDNode && (representationElementMapping = (abstractDNode = (AbstractDNode)eObject).getMapping()) instanceof AbstractNodeMapping) {
            AbstractNodeMapping abstractNodeMapping;
            currentEditPartMapping = abstractNodeMapping = (AbstractNodeMapping)representationElementMapping;
        }
        if (editPart instanceof AbstractDNodeListCompartmentEditPart) {
            result = this.getParentEditPartWithExpectedMapping((GraphicalEditPart)editPart.getParent(), extraMappings, nodeMappings);
        } else if (editPart.getParent() instanceof AbstractDiagramContainerEditPart && ((AbstractDiagramContainerEditPart)editPart.getParent()).isRegionContainer()) {
            result = this.getParentEditPartWithExpectedMapping((GraphicalEditPart)((AbstractDiagramContainerEditPart)editPart.getParent()), extraMappings, nodeMappings);
        } else if (currentEditPartMapping != null) {
            iterator = nodeMappings.iterator();
            while (iterator.hasNext()) {
                NodeMapping nodeMapping = (NodeMapping)iterator.next();
                if (!MappingHelper.getAllBorderedNodeMappings(currentEditPartMapping).contains((Object)nodeMapping)) continue;
                result = Optional.of(editPart);
                break;
            }
        }
        if (result.isEmpty() && extraMappings.contains(currentEditPartMapping) && (iterator = editPart.getParent()) instanceof GraphicalEditPart) {
            GraphicalEditPart graphicalEditPart = (GraphicalEditPart)iterator;
            result = this.getParentEditPartWithExpectedMapping(graphicalEditPart, extraMappings, nodeMappings);
        }
        return result;
    }

    private IDiagramCommandFactory getDiagramCommandFactory() {
        DDiagramEditor diagramEditor = (DDiagramEditor)this.getHost().getViewer().getProperty("org.eclipse.sirius.diagram.ui.part.SiriusDiagramEditorID");
        if (diagramEditor == null) {
            return null;
        }
        TransactionalEditingDomain transactionalEditingDomain = TransactionUtil.getEditingDomain((ResourceSet)diagramEditor.getEditingDomain().getResourceSet());
        Object adapter = diagramEditor.getAdapter(IDiagramCommandFactoryProvider.class);
        IDiagramCommandFactoryProvider cmdFactoryProvider = (IDiagramCommandFactoryProvider)adapter;
        IDiagramCommandFactory diagramCommandFactory = cmdFactoryProvider.getCommandFactory(transactionalEditingDomain);
        return diagramCommandFactory;
    }
}

