/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.wizards.newmodel;

import java.util.Map;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.provider.EcoreEditPlugin;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.sirius.common.tools.DslCommonPlugin;
import org.eclipse.sirius.common.tools.api.ecore.EPackageMetaData;
import org.eclipse.sirius.ui.tools.internal.wizards.newmodel.CreateEMFModelWizardDataModel;
import org.eclipse.sirius.viewpoint.provider.Messages;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.FilteredList;

public class SelectEMFMetamodelWizardPage
extends WizardPage {
    private static final String PACKAGE_SEPARATOR = "::";
    private final Image ePacakgeIcon = ExtendedImageRegistry.getInstance().getImage(EcoreEditPlugin.INSTANCE.getImage("full/obj16/EPackage"));
    private Text metamodelFilterText;
    private FilteredList metamodelFilteredList;
    private String metamodelFilter;
    private Browser documentationBrowser;
    private EPackage.Registry packageRegistry;
    private CreateEMFModelWizardDataModel dataModel;

    public SelectEMFMetamodelWizardPage(EPackage.Registry packageRegistry, CreateEMFModelWizardDataModel dataModel) {
        super("SelectEMFMetamodelWizardPage");
        this.packageRegistry = packageRegistry;
        this.dataModel = dataModel;
        this.setTitle(Messages.SelectEMFMetamodelWizardPage_title);
        this.setDescription(Messages.SelectEMFMetamodelWizardPage_description);
    }

    public void setMetamodelFilter(String filter) {
        if (this.metamodelFilterText == null) {
            this.metamodelFilter = filter;
        } else {
            this.metamodelFilterText.setText(filter);
        }
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new GridLayout(1, false));
        CLabel lblSelectMetamodel = new CLabel(container, 0);
        lblSelectMetamodel.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        lblSelectMetamodel.setText(Messages.SelectEMFMetamodelWizardPage_metamodelLabel);
        this.createMetamodelFilterText(container);
        this.createMetamodelFilteredList(container);
        this.setMetamodelFilter("*");
        this.createMetamodelDocumentation(container);
    }

    private void createMetamodelFilterText(Composite parent) {
        this.metamodelFilterText = new Text(parent, 2048);
        this.metamodelFilterText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.metamodelFilterText.setText(this.metamodelFilter == null ? "" : this.metamodelFilter);
        this.metamodelFilterText.addListener(24, event -> this.metamodelFilteredList.setFilter(this.metamodelFilterText.getText()));
        this.metamodelFilterText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000002) {
                    SelectEMFMetamodelWizardPage.this.metamodelFilteredList.setFocus();
                }
            }
        });
    }

    private void createMetamodelFilteredList(Composite parent) {
        this.metamodelFilteredList = new FilteredList(parent, 68356, (ILabelProvider)new MetamodelsListLabelProvider(), true, false, false);
        this.metamodelFilteredList.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.metamodelFilteredList.setElements(this.packageRegistry.entrySet().toArray());
        this.metamodelFilteredList.setFilter(this.metamodelFilter == null ? "" : this.metamodelFilter);
        this.metamodelFilteredList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object[] selection = SelectEMFMetamodelWizardPage.this.metamodelFilteredList.getSelection();
                if (selection.length == 1) {
                    SelectEMFMetamodelWizardPage.this.dataModel.setSelectedPackage(((Map.Entry)selection[0]).getValue());
                    String documentation = SelectEMFMetamodelWizardPage.this.getDocumentation(SelectEMFMetamodelWizardPage.this.dataModel.getSelectedPackage());
                    if (SelectEMFMetamodelWizardPage.this.documentationBrowser != null) {
                        SelectEMFMetamodelWizardPage.this.documentationBrowser.setText(documentation);
                    }
                    SelectEMFMetamodelWizardPage.this.setPageComplete(true);
                } else {
                    SelectEMFMetamodelWizardPage.this.dataModel.setSelectedPackage(null);
                    if (SelectEMFMetamodelWizardPage.this.documentationBrowser != null) {
                        SelectEMFMetamodelWizardPage.this.documentationBrowser.setText("");
                    }
                    SelectEMFMetamodelWizardPage.this.setPageComplete(false);
                }
            }
        });
    }

    private void createMetamodelDocumentation(Composite parent) {
        Label lblDocumentation = new Label(parent, 0);
        lblDocumentation.setText(Messages.SelectEMFMetamodelWizardPage_documentationLabel);
        try {
            this.documentationBrowser = new Browser(parent, 2048);
            this.documentationBrowser.setLayoutData((Object)new GridData(4, 4, true, false, 1, 2));
        }
        catch (SWTError sWTError) {
            lblDocumentation.setText("");
        }
    }

    private String getQualifiedName(EPackage ePackage) {
        Object ePackageQualifiedName = "";
        if (ePackage != null) {
            EPackage eSuperPackage = ePackage.getESuperPackage();
            String eSuperPackageName = this.getQualifiedName(eSuperPackage);
            if (eSuperPackageName != null && !eSuperPackageName.isEmpty()) {
                ePackageQualifiedName = (String)ePackageQualifiedName + eSuperPackageName;
                ePackageQualifiedName = (String)ePackageQualifiedName + PACKAGE_SEPARATOR;
            }
            ePackageQualifiedName = (String)ePackageQualifiedName + ePackage.getName();
        }
        return ePackageQualifiedName;
    }

    private String getLabelFromEPackageExtraData(EPackage ePackage) {
        EPackageMetaData metaData = DslCommonPlugin.INSTANCE.getEPackageMetaData(ePackage.getNsURI());
        if (metaData != null) {
            return metaData.getDisplayName();
        }
        return null;
    }

    private String getDocumentationFromEPackageExtraData(EPackage ePackage) {
        EPackageMetaData metaData = DslCommonPlugin.INSTANCE.getEPackageMetaData(ePackage.getNsURI());
        if (metaData != null) {
            return metaData.getDocumentation();
        }
        return null;
    }

    private String getDocumentation(EPackage ePackage) {
        if (ePackage == null) {
            return null;
        }
        Object documentation = this.getDocumentationFromEPackageExtraData(ePackage);
        documentation = documentation == null ? "<code>" + ePackage.getNsURI() + "</code>" : (String)documentation + "<br><br><smaller><code>" + ePackage.getNsURI() + "</code></smaller>";
        return documentation;
    }

    private class MetamodelsListLabelProvider
    extends LabelProvider {
        private MetamodelsListLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof Map.Entry) {
                String label = null;
                Object value = ((Map.Entry)element).getValue();
                if (value instanceof EPackage) {
                    label = SelectEMFMetamodelWizardPage.this.getLabelFromEPackageExtraData((EPackage)value);
                    if (label == null) {
                        label = SelectEMFMetamodelWizardPage.this.getQualifiedName((EPackage)value);
                    }
                } else {
                    label = (String)((Map.Entry)element).getKey();
                }
                return label;
            }
            return super.getText(element);
        }

        public Image getImage(Object element) {
            return SelectEMFMetamodelWizardPage.this.ePacakgeIcon;
        }
    }
}

