/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.views.modelexplorer.extension.tab;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sirius.common.ui.SiriusTransPlugin;
import org.eclipse.sirius.common.ui.tools.api.util.ImageProvider;
import org.eclipse.sirius.ui.tools.api.views.modelexplorerview.IModelExplorerTabExtension;

public class ModelExplorerTabDescriptor {
    public static final String MODEL_EXPLORER_TAB_CLASS_NAME = "class";
    public static final String MODEL_EXPLORER_TAB_ICON = "icon";
    public static final String MODEL_EXPLORER_TAB_ID = "icon";
    private final IConfigurationElement element;
    private String extensionClassName;
    private IModelExplorerTabExtension extension;
    private ImageDescriptor imageDescriptor;
    private String id;

    public ModelExplorerTabDescriptor(IConfigurationElement configuration) {
        this.element = configuration;
        this.extensionClassName = configuration.getAttribute(MODEL_EXPLORER_TAB_CLASS_NAME);
    }

    public IModelExplorerTabExtension getTabExtension() {
        if (this.extension == null) {
            try {
                this.extension = (IModelExplorerTabExtension)this.element.createExecutableExtension(MODEL_EXPLORER_TAB_CLASS_NAME);
            }
            catch (CoreException e) {
                SiriusTransPlugin.INSTANCE.error(e.getMessage(), (Throwable)e);
            }
        }
        return this.extension;
    }

    public ImageDescriptor getImageDescriptor() {
        if (this.imageDescriptor == null) {
            String iconRelPath = this.element.getAttribute("icon");
            this.imageDescriptor = iconRelPath != null ? ImageProvider.getImageDescriptor((String)(this.element.getNamespaceIdentifier() + "/" + iconRelPath)) : ImageDescriptor.getMissingImageDescriptor();
        }
        return this.imageDescriptor;
    }

    public String getId() {
        if (this.id == null) {
            this.id = this.element.getAttribute("icon");
        }
        return this.id;
    }

    public String getExtensionClassName() {
        return this.extensionClassName;
    }
}

