/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tests.swtbot.support.api.view;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.sirius.tests.support.api.TestsUtil;
import org.eclipse.sirius.tests.swtbot.support.api.view.SiriusOutlineView;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.eclipse.swtbot.swt.finder.waits.Conditions;
import org.eclipse.swtbot.swt.finder.waits.DefaultCondition;
import org.eclipse.swtbot.swt.finder.waits.ICondition;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotButton;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.junit.Assert;

public class DesignerViews {
    private static final String OUTLINE = "Outline";
    private static final String WINDOW = "Window";
    private static final String SHOW_VIEW = "Show View";
    private final SWTWorkbenchBot bot;

    public DesignerViews(SWTWorkbenchBot bot) {
        this.bot = bot;
    }

    public SWTBotView openViewByAPI(String viewId, String viewTitle) {
        PlatformUI.getWorkbench().getDisplay().syncExec(() -> {
            try {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(viewId);
            }
            catch (PartInitException e) {
                Assert.fail((String)("Unable to open errorLog view : " + e.getMessage()));
            }
        });
        return this.bot.viewByTitle(viewTitle);
    }

    public SWTBotView openView(String categoryName, String viewName) {
        return this.openView(categoryName, viewName, viewName);
    }

    public SWTBotView openView(String categoryName, String labelInList, String viewTitle) {
        this.bot.menu(WINDOW).menu(SHOW_VIEW).menu("Other...").click();
        this.bot.waitUntil(Conditions.shellIsActive((String)SHOW_VIEW));
        this.bot.text().setText(labelInList);
        this.bot.sleep(500L);
        this.bot.tree().getTreeItem(categoryName).getNode(labelInList).select();
        SWTBotButton okButton = this.bot.button(TestsUtil.isOxygenPlatform() ? "Open" : IDialogConstants.OK_LABEL);
        this.bot.waitUntil((ICondition)new OKButtonEnabledCondition(okButton));
        okButton.click();
        return this.bot.viewByTitle(viewTitle);
    }

    public SiriusOutlineView openOutlineView() {
        this.openViewByAPI("org.eclipse.ui.views.ContentOutline", OUTLINE);
        return this.getOutlineView();
    }

    public SiriusOutlineView getOutlineView() {
        return new SiriusOutlineView(this.bot, this.bot.viewByTitle(OUTLINE));
    }

    private class OKButtonEnabledCondition
    extends DefaultCondition {
        private final SWTBotButton okButton;

        OKButtonEnabledCondition(SWTBotButton okButton) {
            this.okButton = okButton;
        }

        public String getFailureMessage() {
            return "ok button is not enabled";
        }

        public boolean test() throws Exception {
            return this.okButton.isEnabled();
        }
    }
}

