/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.ui.tools.api.wizard;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;

public class CheckboxTreeAndListGroup
implements ICheckStateListener,
ISelectionChangedListener,
ITreeViewerListener {
    private Object root;
    private Object currentTreeSelection;
    private List expandedTreeNodes = new ArrayList();
    private Map checkedStateStore = new HashMap(9);
    private List whiteCheckedTreeItems = new ArrayList();
    private ListenerList listeners = new ListenerList();
    private ITreeContentProvider treeContentProvider;
    private IStructuredContentProvider listContentProvider;
    private ILabelProvider treeLabelProvider;
    private ILabelProvider listLabelProvider;
    private CheckboxTreeViewer treeViewer;
    private CheckboxTableViewer listViewer;

    public CheckboxTreeAndListGroup(Composite parent, Object rootObject, ITreeContentProvider treeContentProvider, ILabelProvider treeLabelProvider, IStructuredContentProvider listContentProvider, ILabelProvider listLabelProvider, int style, int width, int height) {
        this.root = rootObject;
        this.treeContentProvider = treeContentProvider;
        this.listContentProvider = listContentProvider;
        this.treeLabelProvider = treeLabelProvider;
        this.listLabelProvider = listLabelProvider;
        this.createContents(parent, width, height, style);
    }

    public CheckboxTreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    public CheckboxTableViewer getListViewer() {
        return this.listViewer;
    }

    public void aboutToOpen() {
        Object primary;
        this.determineWhiteCheckedDescendents(this.root);
        this.checkNewTreeElements(this.treeContentProvider.getElements(this.root));
        this.currentTreeSelection = null;
        Object[] elements = this.treeContentProvider.getElements(this.root);
        Object object = primary = elements.length > 0 ? elements[0] : null;
        if (primary != null) {
            this.treeViewer.setSelection((ISelection)new StructuredSelection(primary));
        }
        this.treeViewer.getControl().setFocus();
    }

    public void addCheckStateListener(ICheckStateListener listener) {
        this.listeners.add((Object)listener);
    }

    private void addToHierarchyToCheckedStore(Object treeElement) {
        Object parent;
        if (!this.checkedStateStore.containsKey(treeElement)) {
            this.checkedStateStore.put(treeElement, new ArrayList());
        }
        if ((parent = this.treeContentProvider.getParent(treeElement)) != null) {
            this.addToHierarchyToCheckedStore(parent);
        }
    }

    protected boolean areAllChildrenWhiteChecked(Object treeElement) {
        Object[] children = this.treeContentProvider.getChildren(treeElement);
        int i = 0;
        while (i < children.length) {
            if (!this.whiteCheckedTreeItems.contains(children[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected boolean areAllElementsChecked(Object treeElement) {
        List checkedElements = (List)this.checkedStateStore.get(treeElement);
        if (checkedElements == null) {
            return false;
        }
        return this.getListItemsSize(treeElement) == checkedElements.size();
    }

    protected void checkNewTreeElements(Object[] elements) {
        int i = 0;
        while (i < elements.length) {
            Object currentElement = elements[i];
            if (currentElement != null) {
                boolean checked = this.checkedStateStore.containsKey(currentElement);
                this.treeViewer.setChecked(currentElement, checked);
                this.treeViewer.setGrayed(currentElement, checked && !this.whiteCheckedTreeItems.contains(currentElement));
            }
            ++i;
        }
    }

    public void checkStateChanged(final CheckStateChangedEvent event) {
        BusyIndicator.showWhile((Display)this.treeViewer.getControl().getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                if (event.getCheckable().equals(CheckboxTreeAndListGroup.this.treeViewer)) {
                    CheckboxTreeAndListGroup.this.treeItemChecked(event.getElement(), event.getChecked());
                } else {
                    CheckboxTreeAndListGroup.this.listItemChecked(event.getElement(), event.getChecked(), true);
                }
                CheckboxTreeAndListGroup.this.notifyCheckStateChangeListeners(event);
            }
        });
    }

    protected void createContents(Composite parent, int width, int height, int style) {
        Composite composite = new Composite(parent, style);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(parent.getFont());
        this.createTreeViewer(composite, width / 2, height);
        this.createListViewer(composite, width / 2, height);
        this.initialize();
    }

    protected void createListViewer(Composite parent, int width, int height) {
        this.listViewer = CheckboxTableViewer.newCheckList((Composite)parent, (int)2048);
        GridData data = new GridData(1808);
        data.widthHint = width;
        data.heightHint = height;
        this.listViewer.getTable().setLayoutData((Object)data);
        this.listViewer.getTable().setFont(parent.getFont());
        this.listViewer.setContentProvider((IContentProvider)this.listContentProvider);
        this.listViewer.setLabelProvider((IBaseLabelProvider)this.listLabelProvider);
        this.listViewer.addCheckStateListener((ICheckStateListener)this);
    }

    protected void createTreeViewer(Composite parent, int width, int height) {
        Tree tree = new Tree(parent, 2080);
        GridData data = new GridData(1808);
        data.widthHint = width;
        data.heightHint = height;
        tree.setLayoutData((Object)data);
        tree.setFont(parent.getFont());
        this.treeViewer = new CheckboxTreeViewer(tree);
        this.treeViewer.setContentProvider((IContentProvider)this.treeContentProvider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)this.treeLabelProvider);
        this.treeViewer.addTreeListener((ITreeViewerListener)this);
        this.treeViewer.addCheckStateListener((ICheckStateListener)this);
        this.treeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
    }

    protected boolean determineShouldBeAtLeastGrayChecked(Object treeElement) {
        boolean result = false;
        List checked = (List)this.checkedStateStore.get(treeElement);
        if (checked != null && !checked.isEmpty()) {
            result = true;
        }
        Object[] children = this.treeContentProvider.getChildren(treeElement);
        int i = 0;
        while (i < children.length) {
            if (this.checkedStateStore.containsKey(children[i])) {
                result = true;
            }
            ++i;
        }
        return result;
    }

    protected boolean determineShouldBeWhiteChecked(Object treeElement) {
        return this.areAllChildrenWhiteChecked(treeElement) && this.areAllElementsChecked(treeElement);
    }

    protected void determineWhiteCheckedDescendents(Object treeElement) {
        Object[] children = this.treeContentProvider.getElements(treeElement);
        int i = 0;
        while (i < children.length) {
            this.determineWhiteCheckedDescendents(children[i]);
            ++i;
        }
        if (this.determineShouldBeWhiteChecked(treeElement)) {
            this.setWhiteChecked(treeElement, true);
        }
    }

    public void expandAll() {
        this.treeViewer.expandAll();
    }

    public Iterator getAllCheckedListItems() {
        ArrayList result = new ArrayList();
        Iterator listCollectionsEnum = this.checkedStateStore.values().iterator();
        while (listCollectionsEnum.hasNext()) {
            Iterator currentCollection = ((List)listCollectionsEnum.next()).iterator();
            while (currentCollection.hasNext()) {
                result.add(currentCollection.next());
            }
        }
        return result.iterator();
    }

    public Set getAllCheckedTreeItems() {
        return this.checkedStateStore.keySet();
    }

    public int getCheckedElementCount() {
        return this.checkedStateStore.size();
    }

    protected int getListItemsSize(Object treeElement) {
        Object[] elements = this.listContentProvider.getElements(treeElement);
        return elements.length;
    }

    public Table getListTable() {
        return this.listViewer.getTable();
    }

    protected void grayCheckHierarchy(Object treeElement) {
        Object parent;
        if (this.checkedStateStore.containsKey(treeElement)) {
            return;
        }
        this.checkedStateStore.put(treeElement, new ArrayList());
        if (this.determineShouldBeWhiteChecked(treeElement)) {
            this.setWhiteChecked(treeElement, true);
        }
        if ((parent = this.treeContentProvider.getParent(treeElement)) != null) {
            this.grayCheckHierarchy(parent);
        }
    }

    public void initialCheckListItem(Object element) {
        Object parent;
        this.currentTreeSelection = parent = this.treeContentProvider.getParent(element);
        this.listItemChecked(element, true, false);
        this.updateHierarchy(parent);
    }

    public void initialCheckTreeItem(Object element) {
        this.treeItemChecked(element, true);
    }

    protected void initialize() {
        this.treeViewer.setInput(this.root);
    }

    protected void listItemChecked(Object listElement, boolean state, boolean updatingFromSelection) {
        List checkedListItems = (List)this.checkedStateStore.get(this.currentTreeSelection);
        if (state) {
            if (checkedListItems == null) {
                this.grayCheckHierarchy(this.currentTreeSelection);
                checkedListItems = (List)this.checkedStateStore.get(this.currentTreeSelection);
            }
            checkedListItems.add(listElement);
        } else {
            checkedListItems.remove(listElement);
            if (checkedListItems.isEmpty()) {
                this.ungrayCheckHierarchy(this.currentTreeSelection);
            }
        }
        if (updatingFromSelection) {
            this.updateHierarchy(this.currentTreeSelection);
        }
    }

    protected void notifyCheckStateChangeListeners(final CheckStateChangedEvent event) {
        Object[] array;
        Object[] objectArray = array = this.listeners.getListeners();
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            final ICheckStateListener l = (ICheckStateListener)element;
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.checkStateChanged(event);
                }
            });
            ++n2;
        }
    }

    protected void populateListViewer(Object treeElement) {
        this.listViewer.setInput(treeElement);
        List listItemsToCheck = (List)this.checkedStateStore.get(treeElement);
        if (listItemsToCheck != null) {
            Iterator listItemsEnum = listItemsToCheck.iterator();
            while (listItemsEnum.hasNext()) {
                this.listViewer.setChecked(listItemsEnum.next(), true);
            }
        }
    }

    public void removeCheckStateListener(ICheckStateListener listener) {
        this.listeners.remove((Object)listener);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        Object selectedElement = selection.getFirstElement();
        if (selectedElement == null) {
            this.currentTreeSelection = null;
            this.listViewer.setInput(this.currentTreeSelection);
            return;
        }
        this.populateListViewer(selectedElement);
        this.currentTreeSelection = selectedElement;
    }

    public void setAllSelections(final boolean selection) {
        BusyIndicator.showWhile((Display)this.treeViewer.getControl().getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                CheckboxTreeAndListGroup.this.setTreeChecked(CheckboxTreeAndListGroup.this.root, selection);
                CheckboxTreeAndListGroup.this.listViewer.setAllChecked(selection);
            }
        });
    }

    public void setListProviders(IStructuredContentProvider contentProvider, ILabelProvider labelProvider) {
        this.listViewer.setContentProvider((IContentProvider)contentProvider);
        this.listViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
    }

    public void setListSorter(ViewerSorter sorter) {
        this.listViewer.setSorter(sorter);
    }

    public void setRoot(Object newRoot) {
        this.root = newRoot;
        this.initialize();
    }

    protected void setTreeChecked(Object treeElement, boolean state) {
        if (treeElement != null) {
            if (treeElement.equals(this.currentTreeSelection)) {
                this.listViewer.setAllChecked(state);
            }
            if (state) {
                Object[] listItems = this.listContentProvider.getElements(treeElement);
                ArrayList<Object> listItemsChecked = new ArrayList<Object>();
                int i = 0;
                while (i < listItems.length) {
                    listItemsChecked.add(listItems[i]);
                    ++i;
                }
                this.checkedStateStore.put(treeElement, listItemsChecked);
            } else {
                this.checkedStateStore.remove(treeElement);
            }
            this.setWhiteChecked(treeElement, state);
            this.treeViewer.setChecked(treeElement, state);
            this.treeViewer.setGrayed(treeElement, false);
            Object[] children = this.treeContentProvider.getChildren(treeElement);
            int i = 0;
            while (i < children.length) {
                this.setTreeChecked(children[i], state);
                ++i;
            }
        }
    }

    public void setTreeProviders(ITreeContentProvider contentProvider, ILabelProvider labelProvider) {
        this.treeViewer.setContentProvider((IContentProvider)contentProvider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
    }

    public void setTreeSorter(ViewerSorter sorter) {
        this.treeViewer.setSorter(sorter);
    }

    protected void setWhiteChecked(Object treeElement, boolean isWhiteChecked) {
        if (isWhiteChecked) {
            if (!this.whiteCheckedTreeItems.contains(treeElement)) {
                this.whiteCheckedTreeItems.add(treeElement);
            }
        } else {
            this.whiteCheckedTreeItems.remove(treeElement);
        }
    }

    public void treeCollapsed(TreeExpansionEvent event) {
    }

    public void treeExpanded(TreeExpansionEvent event) {
        Object item = event.getElement();
        if (!this.expandedTreeNodes.contains(item)) {
            this.expandedTreeNodes.add(item);
            this.checkNewTreeElements(this.treeContentProvider.getChildren(item));
        }
    }

    protected void treeItemChecked(Object treeElement, boolean state) {
        this.setTreeChecked(treeElement, state);
        Object parent = this.treeContentProvider.getParent(treeElement);
        if (parent == null) {
            return;
        }
        if (state) {
            this.grayCheckHierarchy(parent);
        } else {
            this.ungrayCheckHierarchy(parent);
        }
        this.updateHierarchy(treeElement);
    }

    protected void ungrayCheckHierarchy(Object treeElement) {
        Object parent;
        if (!this.determineShouldBeAtLeastGrayChecked(treeElement)) {
            this.checkedStateStore.remove(treeElement);
        }
        if ((parent = this.treeContentProvider.getParent(treeElement)) != null) {
            this.ungrayCheckHierarchy(parent);
        }
    }

    protected void updateHierarchy(Object treeElement) {
        Object parent;
        boolean whiteChecked = this.determineShouldBeWhiteChecked(treeElement);
        boolean shouldBeAtLeastGray = this.determineShouldBeAtLeastGrayChecked(treeElement);
        this.treeViewer.setChecked(treeElement, shouldBeAtLeastGray);
        this.setWhiteChecked(treeElement, whiteChecked);
        if (!whiteChecked) {
            this.treeViewer.setGrayed(treeElement, shouldBeAtLeastGray);
        }
        if ((parent = this.treeContentProvider.getParent(treeElement)) != null) {
            this.updateHierarchy(parent);
        }
    }

    public void updateSelections(final Map items) {
        BusyIndicator.showWhile((Display)this.treeViewer.getControl().getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                for (Map.Entry entry : items.entrySet()) {
                    List selections = (List)entry.getValue();
                    if (selections.size() == 0) {
                        CheckboxTreeAndListGroup.this.checkedStateStore.remove(entry.getKey());
                        continue;
                    }
                    CheckboxTreeAndListGroup.this.checkedStateStore.put(entry.getKey(), selections);
                    Object parent = CheckboxTreeAndListGroup.this.treeContentProvider.getParent(entry.getKey());
                    if (parent == null) continue;
                    CheckboxTreeAndListGroup.this.addToHierarchyToCheckedStore(parent);
                }
                for (Map.Entry entry : items.entrySet()) {
                    CheckboxTreeAndListGroup.this.updateHierarchy(entry.getKey());
                    if (CheckboxTreeAndListGroup.this.currentTreeSelection == null || !CheckboxTreeAndListGroup.this.currentTreeSelection.equals(entry.getKey())) continue;
                    CheckboxTreeAndListGroup.this.listViewer.setAllChecked(false);
                    CheckboxTreeAndListGroup.this.listViewer.setCheckedElements(((List)entry.getValue()).toArray());
                }
            }
        });
    }
}

