/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.examples.pages;

import org.eclipse.rap.examples.ExampleUtil;
import org.eclipse.rap.examples.IExamplePage;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Spinner;

public class FillLayoutExample
implements IExamplePage {
    private Composite contentComp;
    private int propSpacing = 5;
    private boolean propPrefSize;
    private Composite layoutArea;

    public void createControl(Composite parent) {
        this.contentComp = parent;
        this.contentComp.setLayout((Layout)ExampleUtil.createMainLayout((int)1));
        this.createLayoutArea();
        this.createControlButtons(parent);
    }

    private void createLayoutArea() {
        if (this.layoutArea == null || this.layoutArea.isDisposed()) {
            this.layoutArea = new SashForm(this.contentComp, 0);
            GridData layoutData = ExampleUtil.createFillData();
            this.layoutArea.setLayoutData((Object)layoutData);
            FillLayout layout = new FillLayout();
            layout.spacing = 10;
            this.layoutArea.setLayout((Layout)layout);
        }
        Control[] children = this.layoutArea.getChildren();
        int i = 0;
        while (i < children.length) {
            if (!(children[i] instanceof Sash)) {
                children[i].dispose();
            }
            ++i;
        }
        this.createLayoutComp(this.layoutArea, 256);
        this.createLayoutComp(this.layoutArea, 512);
        this.layoutArea.layout();
    }

    private void createLayoutComp(Composite parent, int style) {
        Composite layoutCompContainer = new Composite(parent, 0);
        layoutCompContainer.setLayout((Layout)ExampleUtil.createGridLayout((int)1, (boolean)false, (boolean)false, (boolean)false));
        String orientString = style == 512 ? "Vertical" : "Horizontal";
        String message = orientString + " FillLayout";
        ExampleUtil.createHeading((Composite)layoutCompContainer, (String)message, (int)1);
        Composite layoutComp = new Composite(layoutCompContainer, 2048);
        if (!this.propPrefSize) {
            layoutComp.setLayoutData((Object)ExampleUtil.createFillData());
        }
        FillLayout layout = new FillLayout(style);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.spacing = this.propSpacing;
        layoutComp.setLayout((Layout)layout);
        int count = style == 512 ? 2 : 3;
        Color background = new Color((Device)parent.getDisplay(), 220, 220, 200);
        int i = 0;
        while (i < count) {
            Composite childComp = new Composite(layoutComp, 2048);
            childComp.setBackground(background);
            ++i;
        }
    }

    private void createControlButtons(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(4, 128, true, false);
        gridData.horizontalSpan = 2;
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)ExampleUtil.createGridLayout((int)1, (boolean)false, (boolean)false, (boolean)false));
        Composite spacingComp = new Composite(composite, 0);
        RowLayout spacingLayout = new RowLayout();
        spacingLayout.spacing = 5;
        spacingLayout.center = true;
        spacingComp.setLayout((Layout)spacingLayout);
        new Label(spacingComp, 0).setText("Set spacing:");
        final Spinner spacingSpinner = new Spinner(spacingComp, 2056);
        spacingSpinner.setMaximum(12);
        spacingSpinner.setSelection(this.propSpacing);
        spacingSpinner.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FillLayoutExample.this.propSpacing = spacingSpinner.getSelection();
                FillLayoutExample.this.createLayoutArea();
            }
        });
        final Button preferredSizeButton = new Button(composite, 32);
        preferredSizeButton.setText("Shrink containers to their preferred size");
        preferredSizeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FillLayoutExample.this.propPrefSize = preferredSizeButton.getSelection();
                FillLayoutExample.this.createLayoutArea();
            }
        });
    }
}

