/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.Bytes;
import com.mongodb.CommandResult;
import com.mongodb.DBApiLayer;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.DefaultDBDecoder;
import com.mongodb.Mongo;
import com.mongodb.MongoException;
import com.mongodb.ReadPreference;
import com.mongodb.ServerAddress;
import com.mongodb.WriteConcern;
import com.mongodb.WriteResult;
import com.mongodb.util.Util;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DB {
    final Mongo _mongo;
    final String _name;
    protected boolean _readOnly = false;
    private WriteConcern _concern;
    private ReadPreference _readPref;
    final Bytes.OptionHolder _options;
    String _username;
    byte[] _authhash = null;

    public DB(Mongo mongo, String name) {
        this._mongo = mongo;
        this._name = name;
        this._options = new Bytes.OptionHolder(this._mongo._netOptions);
    }

    public abstract void requestStart();

    public abstract void requestDone();

    public abstract void requestEnsureConnection();

    protected abstract DBCollection doGetCollection(String var1);

    public final DBCollection getCollection(String name) {
        DBCollection c = this.doGetCollection(name);
        return c;
    }

    public final DBCollection createCollection(String name, DBObject options) {
        if (options != null) {
            BasicDBObject createCmd = new BasicDBObject("create", name);
            createCmd.putAll(options);
            CommandResult result = this.command(createCmd);
            result.throwOnError();
        }
        return this.getCollection(name);
    }

    public DBCollection getCollectionFromString(String s) {
        DBCollection foo = null;
        int idx = s.indexOf(".");
        while (idx >= 0) {
            String b = s.substring(0, idx);
            s = s.substring(idx + 1);
            foo = foo == null ? this.getCollection(b) : foo.getCollection(b);
            idx = s.indexOf(".");
        }
        if (foo != null) {
            return foo.getCollection(s);
        }
        return this.getCollection(s);
    }

    public CommandResult command(DBObject cmd) throws MongoException {
        return this.command(cmd, 0);
    }

    public CommandResult command(DBObject cmd, int options, ReadPreference readPrefs) throws MongoException {
        Iterator<DBObject> i = this.getCollection("$cmd").__find(cmd, new BasicDBObject(), 0, -1, 0, options, readPrefs, DefaultDBDecoder.FACTORY.create());
        if (i == null || !i.hasNext()) {
            return null;
        }
        DBObject res = i.next();
        ServerAddress sa = i instanceof DBApiLayer.Result ? ((DBApiLayer.Result)i).getServerAddress() : null;
        CommandResult cr = new CommandResult(sa);
        cr.putAll(res);
        cr._cmd = cmd;
        return cr;
    }

    public CommandResult command(DBObject cmd, int options) throws MongoException {
        return this.command(cmd, options, null);
    }

    public CommandResult command(String cmd) throws MongoException {
        return this.command(new BasicDBObject(cmd, Boolean.TRUE));
    }

    public CommandResult command(String cmd, int options) throws MongoException {
        return this.command(new BasicDBObject(cmd, Boolean.TRUE), options);
    }

    public CommandResult doEval(String code, Object ... args) throws MongoException {
        return this.command(BasicDBObjectBuilder.start().add("$eval", code).add("args", args).get());
    }

    public Object eval(String code, Object ... args) throws MongoException {
        CommandResult res = this.doEval(code, args);
        res.throwOnError();
        return res.get("retval");
    }

    public CommandResult getStats() {
        return this.command("dbstats");
    }

    public String getName() {
        return this._name;
    }

    public void setReadOnly(Boolean b) {
        this._readOnly = b;
    }

    public Set<String> getCollectionNames() throws MongoException {
        DBCollection namespaces = this.getCollection("system.namespaces");
        if (namespaces == null) {
            throw new RuntimeException("this is impossible");
        }
        Iterator<DBObject> i = namespaces.__find(new BasicDBObject(), null, 0, 0, 0, this.getOptions(), null, null);
        if (i == null) {
            return new HashSet<String>();
        }
        ArrayList<String> tables = new ArrayList<String>();
        while (i.hasNext()) {
            int idx;
            DBObject o = i.next();
            if (o.get("name") == null) {
                throw new MongoException("how is name null : " + o);
            }
            String n = o.get("name").toString();
            String root = n.substring(0, idx = n.indexOf("."));
            if (!root.equals(this._name) || n.indexOf("$") >= 0) continue;
            String table = n.substring(idx + 1);
            tables.add(table);
        }
        Collections.sort(tables);
        return new LinkedHashSet<String>(tables);
    }

    public boolean collectionExists(String collectionName) {
        if (collectionName == null || "".equals(collectionName)) {
            return false;
        }
        Set<String> collections = this.getCollectionNames();
        if (collections.isEmpty()) {
            return false;
        }
        for (String collection : collections) {
            if (!collectionName.equalsIgnoreCase(collection)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this._name;
    }

    public CommandResult getLastError() throws MongoException {
        return this.command(new BasicDBObject("getlasterror", (Object)1));
    }

    public CommandResult getLastError(WriteConcern concern) throws MongoException {
        return this.command(concern.getCommand());
    }

    public CommandResult getLastError(int w, int wtimeout, boolean fsync) throws MongoException {
        return this.command(new WriteConcern(w, wtimeout, fsync).getCommand());
    }

    public void setWriteConcern(WriteConcern concern) {
        if (concern == null) {
            throw new IllegalArgumentException();
        }
        this._concern = concern;
    }

    public WriteConcern getWriteConcern() {
        if (this._concern != null) {
            return this._concern;
        }
        return this._mongo.getWriteConcern();
    }

    public void setReadPreference(ReadPreference preference) {
        this._readPref = preference;
    }

    public ReadPreference getReadPreference() {
        if (this._readPref != null) {
            return this._readPref;
        }
        return this._mongo.getReadPreference();
    }

    public void dropDatabase() throws MongoException {
        CommandResult res = this.command(new BasicDBObject("dropDatabase", (Object)1));
        res.throwOnError();
        this._mongo._dbs.remove(this.getName());
    }

    public boolean isAuthenticated() {
        return this._username != null;
    }

    public boolean authenticate(String username, char[] passwd) throws MongoException {
        if (username == null || passwd == null) {
            throw new NullPointerException("username can't be null");
        }
        if (this._username != null) {
            throw new IllegalStateException("can't call authenticate twice on the same DBObject");
        }
        String hash = this._hash(username, passwd);
        CommandResult res = this._doauth(username, hash.getBytes());
        if (!res.ok()) {
            return false;
        }
        this._username = username;
        this._authhash = hash.getBytes();
        return true;
    }

    public CommandResult authenticateCommand(String username, char[] passwd) throws MongoException {
        if (username == null || passwd == null) {
            throw new NullPointerException("username can't be null");
        }
        if (this._username != null) {
            throw new IllegalStateException("can't call authenticate twice on the same DBObject");
        }
        String hash = this._hash(username, passwd);
        CommandResult res = this._doauth(username, hash.getBytes());
        res.throwOnError();
        this._username = username;
        this._authhash = hash.getBytes();
        return res;
    }

    DBObject _authCommand(String nonce) {
        if (this._username == null || this._authhash == null) {
            throw new IllegalStateException("no auth info!");
        }
        return DB._authCommand(nonce, this._username, this._authhash);
    }

    static DBObject _authCommand(String nonce, String username, byte[] hash) {
        String key = nonce + username + new String(hash);
        BasicDBObject cmd = new BasicDBObject();
        cmd.put("authenticate", (Object)1);
        cmd.put("user", (Object)username);
        cmd.put("nonce", (Object)nonce);
        cmd.put("key", (Object)Util.hexMD5(key.getBytes()));
        return cmd;
    }

    private CommandResult _doauth(String username, byte[] hash) {
        CommandResult res = this.command(new BasicDBObject("getnonce", (Object)1));
        res.throwOnError();
        DBObject cmd = DB._authCommand(res.getString("nonce"), username, hash);
        return this.command(cmd);
    }

    public WriteResult addUser(String username, char[] passwd) {
        return this.addUser(username, passwd, false);
    }

    public WriteResult addUser(String username, char[] passwd, boolean readOnly) {
        DBCollection c = this.getCollection("system.users");
        DBObject o = c.findOne(new BasicDBObject("user", username));
        if (o == null) {
            o = new BasicDBObject("user", username);
        }
        o.put("pwd", this._hash(username, passwd));
        o.put("readOnly", readOnly);
        return c.save(o);
    }

    public WriteResult removeUser(String username) {
        DBCollection c = this.getCollection("system.users");
        return c.remove(new BasicDBObject("user", username));
    }

    String _hash(String username, char[] passwd) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream(username.length() + 20 + passwd.length);
        try {
            bout.write(username.getBytes());
            bout.write(":mongo:".getBytes());
            for (int i = 0; i < passwd.length; ++i) {
                if (passwd[i] >= '\u0080') {
                    throw new IllegalArgumentException("can't handle non-ascii passwords yet");
                }
                bout.write((byte)passwd[i]);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException("impossible", ioe);
        }
        return Util.hexMD5(bout.toByteArray());
    }

    public CommandResult getPreviousError() throws MongoException {
        return this.command(new BasicDBObject("getpreverror", (Object)1));
    }

    public void resetError() throws MongoException {
        this.command(new BasicDBObject("reseterror", (Object)1));
    }

    public void forceError() throws MongoException {
        this.command(new BasicDBObject("forceerror", (Object)1));
    }

    public Mongo getMongo() {
        return this._mongo;
    }

    public DB getSisterDB(String name) {
        return this._mongo.getDB(name);
    }

    @Deprecated
    public void slaveOk() {
        this.addOption(4);
    }

    public void addOption(int option) {
        this._options.add(option);
    }

    public void setOptions(int options) {
        this._options.set(options);
    }

    public void resetOptions() {
        this._options.reset();
    }

    public int getOptions() {
        return this._options.get();
    }

    public abstract void cleanCursors(boolean var1) throws MongoException;
}

