/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.queries;

import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.internal.databaseaccess.DatabaseCall;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.CursorPolicy;
import org.eclipse.persistence.queries.CursoredStream;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.queries.ValueReadQuery;
import org.eclipse.persistence.sessions.remote.DistributedSession;

public class CursoredStreamPolicy
extends CursorPolicy {
    protected int initialReadSize;
    protected ValueReadQuery sizeQuery;

    public CursoredStreamPolicy() {
    }

    public CursoredStreamPolicy(ReadQuery query, int pageSize) {
        super(query, pageSize);
        this.setInitialReadSize(pageSize);
    }

    public CursoredStreamPolicy(ReadQuery query, int initialReadSize, int pageSize) {
        this(query, pageSize);
        this.setInitialReadSize(initialReadSize);
    }

    public CursoredStreamPolicy(ReadQuery query, int initialReadSize, int pageSize, ValueReadQuery sizeQuery) {
        this(query, initialReadSize, pageSize);
        this.setSizeQuery(sizeQuery);
    }

    @Override
    public Object execute() {
        DatabaseCall call = this.getQuery().getQueryMechanism().cursorSelectAllRows();
        CursoredStream stream = new CursoredStream(call, this);
        return stream;
    }

    public int getInitialReadSize() {
        return this.initialReadSize;
    }

    public ValueReadQuery getSizeQuery() {
        return this.sizeQuery;
    }

    public boolean hasSizeQuery() {
        return this.sizeQuery != null;
    }

    @Override
    public boolean isCursoredStreamPolicy() {
        return true;
    }

    @Override
    public void prepare(DatabaseQuery query, AbstractSession session) throws QueryException {
        super.prepare(query, session);
    }

    @Override
    public Object remoteExecute() {
        return ((DistributedSession)this.getQuery().getSession()).cursorSelectObjects(this);
    }

    public void setInitialReadSize(int initialReadSize) {
        this.initialReadSize = initialReadSize;
    }

    public void setSizeQuery(ValueReadQuery sizeQuery) {
        this.sizeQuery = sizeQuery;
    }
}

