/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.dbws;

import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.dbws.DBWSModel;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.ClassExtractor;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.oxm.Constants;
import org.eclipse.persistence.internal.xr.Attachment;
import org.eclipse.persistence.internal.xr.BatchQueryOperation;
import org.eclipse.persistence.internal.xr.CollectionResult;
import org.eclipse.persistence.internal.xr.DeleteOperation;
import org.eclipse.persistence.internal.xr.InsertOperation;
import org.eclipse.persistence.internal.xr.JPQLQueryHandler;
import org.eclipse.persistence.internal.xr.NamedQueryHandler;
import org.eclipse.persistence.internal.xr.Operation;
import org.eclipse.persistence.internal.xr.Parameter;
import org.eclipse.persistence.internal.xr.ProcedureArgument;
import org.eclipse.persistence.internal.xr.ProcedureOutputArgument;
import org.eclipse.persistence.internal.xr.QNameTransformer;
import org.eclipse.persistence.internal.xr.QueryOperation;
import org.eclipse.persistence.internal.xr.Result;
import org.eclipse.persistence.internal.xr.SQLQueryHandler;
import org.eclipse.persistence.internal.xr.StoredFunctionQueryHandler;
import org.eclipse.persistence.internal.xr.StoredProcedureQueryHandler;
import org.eclipse.persistence.internal.xr.UpdateOperation;
import org.eclipse.persistence.internal.xr.XRServiceModel;
import org.eclipse.persistence.internal.xr.sxf.SimpleXMLFormat;
import org.eclipse.persistence.mappings.AttributeAccessor;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.transformers.AttributeTransformer;
import org.eclipse.persistence.mappings.transformers.FieldTransformer;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.mappings.XMLChoiceCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLChoiceObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeDirectCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.oxm.mappings.XMLTransformationMapping;
import org.eclipse.persistence.oxm.record.UnmarshalRecord;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.Record;
import org.eclipse.persistence.sessions.Session;
import org.xml.sax.Attributes;

public class DBWSModelProject
extends Project {
    public NamespaceResolver ns;

    public DBWSModelProject() {
        this.setName("DBWSModelProject");
        this.ns = new NamespaceResolver();
        this.ns.put("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        this.ns.put("xsd", "http://www.w3.org/2001/XMLSchema");
        this.addDescriptor((ClassDescriptor)this.buildServiceDescriptor());
        this.addDescriptor((ClassDescriptor)this.buildAttachmentDescriptor());
        this.addDescriptor((ClassDescriptor)this.buildResultDescriptor());
        this.addDescriptor((ClassDescriptor)this.buildCollectionResultDescriptor());
        this.addDescriptor((ClassDescriptor)this.buildParameterDescriptor());
        this.addDescriptor((ClassDescriptor)this.buildSimpleXMLFormatDescriptor());
        this.addDescriptor((ClassDescriptor)this.buildNamedQueryDescriptor());
        this.addDescriptor((ClassDescriptor)this.buildSqlQueryDescriptor());
        this.addDescriptor((ClassDescriptor)this.buildJpqlQueryDescriptor());
        this.addDescriptor((ClassDescriptor)this.buildStoredProcedureQueryDescriptor());
        this.addDescriptor((ClassDescriptor)this.buildProcedureArgumentDescriptor());
        this.addDescriptor((ClassDescriptor)this.buildProcedureOutputArgumentDescriptor());
        this.addDescriptor((ClassDescriptor)this.buildStoredFunctionQueryDescriptor());
        this.addDescriptor((ClassDescriptor)this.buildQueryDescriptor());
        this.addDescriptor((ClassDescriptor)this.buildInsertDescriptor());
        this.addDescriptor((ClassDescriptor)this.buildDeleteDescriptor());
        this.addDescriptor((ClassDescriptor)this.buildUpdateDescriptor());
        this.addDescriptor((ClassDescriptor)this.buildBatchQueryDescriptor());
        for (XMLDescriptor descriptor : this.getDescriptors().values()) {
            descriptor.setNamespaceResolver(this.ns);
        }
    }

    protected XMLDescriptor buildServiceDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(DBWSModel.class);
        descriptor.setDefaultRootElement("dbws");
        XMLDirectMapping name = new XMLDirectMapping();
        name.setAttributeName("name");
        name.setXPath("name/text()");
        descriptor.addMapping((DatabaseMapping)name);
        XMLDirectMapping sessionFile = new XMLDirectMapping();
        sessionFile.setAttributeName("sessionsFile");
        sessionFile.setXPath("sessions-file/text()");
        descriptor.addMapping((DatabaseMapping)sessionFile);
        XMLChoiceCollectionMapping operationsMapping = new XMLChoiceCollectionMapping();
        operationsMapping.setAttributeName("operations");
        operationsMapping.setAttributeAccessor(new AttributeAccessor(){

            public Object getAttributeValueFromObject(Object object) {
                return ((XRServiceModel)object).getOperationsList();
            }

            public void setAttributeValueInObject(Object object, Object value) {
                Vector v = (Vector)value;
                XRServiceModel dbwsModel = (XRServiceModel)object;
                Map<String, Operation> operations = dbwsModel.getOperations();
                for (Object obj : v) {
                    if (!(obj instanceof Operation)) continue;
                    Operation op = (Operation)obj;
                    operations.put(op.getName(), op);
                }
            }
        });
        operationsMapping.addChoiceElement("insert", InsertOperation.class);
        operationsMapping.addChoiceElement("query", QueryOperation.class);
        operationsMapping.addChoiceElement("update", UpdateOperation.class);
        operationsMapping.addChoiceElement("delete", DeleteOperation.class);
        operationsMapping.addChoiceElement("batch-sql-query", BatchQueryOperation.class);
        descriptor.addMapping((DatabaseMapping)operationsMapping);
        return descriptor;
    }

    protected XMLDescriptor buildQueryDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(QueryOperation.class);
        descriptor.setDefaultRootElement("query");
        XMLDirectMapping name = new XMLDirectMapping();
        name.setAttributeName("name");
        name.setXPath("name/text()");
        descriptor.addMapping((DatabaseMapping)name);
        XMLCompositeCollectionMapping parameters = new XMLCompositeCollectionMapping();
        parameters.setAttributeName("parameters");
        parameters.setReferenceClass(Parameter.class);
        parameters.setXPath("parameter");
        descriptor.addMapping((DatabaseMapping)parameters);
        XMLCompositeObjectMapping resultMapping = new XMLCompositeObjectMapping();
        resultMapping.setAttributeName("result");
        resultMapping.setReferenceClass(Result.class);
        resultMapping.setXPath("result");
        descriptor.addMapping((DatabaseMapping)resultMapping);
        XMLChoiceObjectMapping queryHandlerMapping = new XMLChoiceObjectMapping();
        queryHandlerMapping.setAttributeName("queryHandler");
        queryHandlerMapping.addChoiceElement("jpql", JPQLQueryHandler.class);
        queryHandlerMapping.addChoiceElement("named-query", NamedQueryHandler.class);
        queryHandlerMapping.addChoiceElement("sql", SQLQueryHandler.class);
        queryHandlerMapping.addChoiceElement("stored-procedure", StoredProcedureQueryHandler.class);
        queryHandlerMapping.addChoiceElement("stored-function", StoredFunctionQueryHandler.class);
        descriptor.addMapping((DatabaseMapping)queryHandlerMapping);
        return descriptor;
    }

    protected XMLDescriptor buildBatchQueryDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(BatchQueryOperation.class);
        descriptor.setDefaultRootElement("batch-sql-query");
        XMLDirectMapping name = new XMLDirectMapping();
        name.setAttributeName("name");
        name.setXPath("name/text()");
        descriptor.addMapping((DatabaseMapping)name);
        XMLCompositeDirectCollectionMapping statementsMapping = new XMLCompositeDirectCollectionMapping();
        statementsMapping.setAttributeName("batchSql");
        XMLField f1 = new XMLField("batch-statement/text()");
        f1.setIsCDATA(true);
        statementsMapping.setField((DatabaseField)f1);
        descriptor.addMapping((DatabaseMapping)statementsMapping);
        return descriptor;
    }

    protected XMLDescriptor buildParameterDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(Parameter.class);
        XMLDirectMapping name = new XMLDirectMapping();
        name.setAttributeName("name");
        name.setXPath("name/text()");
        descriptor.addMapping((DatabaseMapping)name);
        XMLTransformationMapping type = new XMLTransformationMapping();
        type.setAttributeName("type");
        QNameTransformer qNameTransformer = new QNameTransformer("type/text()");
        type.addFieldTransformer("type/text()", (FieldTransformer)qNameTransformer);
        type.setAttributeTransformer((AttributeTransformer)qNameTransformer);
        descriptor.addMapping((DatabaseMapping)type);
        XMLDirectMapping optional = new XMLDirectMapping();
        optional.setAttributeName("optional");
        optional.setXPath("@optional");
        optional.setNullValue((Object)false);
        descriptor.addMapping((DatabaseMapping)optional);
        return descriptor;
    }

    protected XMLDescriptor buildAttachmentDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(Attachment.class);
        XMLDirectMapping mimeType = new XMLDirectMapping();
        mimeType.setAttributeName("mimeType");
        mimeType.setXPath("mime-type/text()");
        descriptor.addMapping((DatabaseMapping)mimeType);
        return descriptor;
    }

    protected XMLDescriptor buildResultDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(Result.class);
        descriptor.setDefaultRootElement("result");
        XMLTransformationMapping type = new XMLTransformationMapping();
        type.setAttributeName("type");
        QNameTransformer qNameTransformer = new QNameTransformer("type/text()");
        type.addFieldTransformer("type/text()", (FieldTransformer)qNameTransformer);
        type.setAttributeTransformer((AttributeTransformer)qNameTransformer);
        descriptor.addMapping((DatabaseMapping)type);
        XMLCompositeObjectMapping attachment = new XMLCompositeObjectMapping();
        attachment.setAttributeName("attachment");
        attachment.setXPath("attachment");
        attachment.setReferenceClass(Attachment.class);
        descriptor.addMapping((DatabaseMapping)attachment);
        XMLCompositeObjectMapping sxf = new XMLCompositeObjectMapping();
        sxf.setAttributeName("simpleXMLFormat");
        sxf.setXPath("simple-xml-format");
        sxf.setReferenceClass(SimpleXMLFormat.class);
        descriptor.addMapping((DatabaseMapping)sxf);
        XMLDirectMapping isCollection = new XMLDirectMapping();
        isCollection.setAttributeAccessor(new AttributeAccessor(){

            public String getAttributeName() {
                return "isCollection";
            }

            public Object getAttributeValueFromObject(Object object) throws DescriptorException {
                if (object instanceof CollectionResult) {
                    return Boolean.TRUE;
                }
                return null;
            }

            public void setAttributeValueInObject(Object object, Object value) throws DescriptorException {
            }
        });
        isCollection.setXPath("@isCollection");
        descriptor.addMapping((DatabaseMapping)isCollection);
        XMLField isColl = new XMLField("@isCollection");
        isColl.setSchemaType(Constants.BOOLEAN_QNAME);
        descriptor.getInheritancePolicy().setClassIndicatorField((DatabaseField)isColl);
        descriptor.getInheritancePolicy().setClassExtractor(new ClassExtractor(){

            public Class<?> extractClassFromRow(Record record, Session session) {
                Class<Result> clz = Result.class;
                UnmarshalRecord uRecord = (UnmarshalRecord)record;
                Attributes attrs = uRecord.getAttributes();
                if (attrs != null) {
                    int i = 0;
                    int l = attrs.getLength();
                    while (i < l) {
                        String value;
                        String attributeName = attrs.getQName(i);
                        if (attributeName.equals("isCollection") && (value = attrs.getValue(i)).equalsIgnoreCase("true")) {
                            clz = CollectionResult.class;
                            break;
                        }
                        ++i;
                    }
                }
                return clz;
            }
        });
        XMLDirectMapping jdbcTypeMapping = new XMLDirectMapping();
        jdbcTypeMapping.setAttributeName("jdbcType");
        jdbcTypeMapping.setXPath("@jdbcType");
        descriptor.addMapping((DatabaseMapping)jdbcTypeMapping);
        return descriptor;
    }

    protected XMLDescriptor buildCollectionResultDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(CollectionResult.class);
        descriptor.getInheritancePolicy().setParentClass(Result.class);
        descriptor.setDefaultRootElement("result");
        return descriptor;
    }

    protected XMLDescriptor buildSimpleXMLFormatDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(SimpleXMLFormat.class);
        descriptor.setDefaultRootElement("simple-xml-format");
        XMLDirectMapping simpleXMLFormatTag = new XMLDirectMapping();
        simpleXMLFormatTag.setAttributeName("simpleXMLFormatTag");
        simpleXMLFormatTag.setXPath("simple-xml-format-tag/text()");
        descriptor.addMapping((DatabaseMapping)simpleXMLFormatTag);
        XMLDirectMapping xmlTag = new XMLDirectMapping();
        xmlTag.setAttributeName("xmlTag");
        xmlTag.setXPath("simple-xml-tag/text()");
        descriptor.addMapping((DatabaseMapping)xmlTag);
        return descriptor;
    }

    protected XMLDescriptor buildNamedQueryDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(NamedQueryHandler.class);
        descriptor.setDefaultRootElement("named-query");
        XMLDirectMapping queryName = new XMLDirectMapping();
        queryName.setAttributeName("name");
        queryName.setXPath("name/text()");
        descriptor.addMapping((DatabaseMapping)queryName);
        XMLDirectMapping alias = new XMLDirectMapping();
        alias.setAttributeName("descriptor");
        alias.setXPath("descriptor/text()");
        descriptor.addMapping((DatabaseMapping)alias);
        return descriptor;
    }

    protected XMLDescriptor buildSqlQueryDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(SQLQueryHandler.class);
        descriptor.setDefaultRootElement("sql");
        XMLDirectMapping queryName = new XMLDirectMapping();
        queryName.setAttributeName("sqlString");
        queryName.setXPath("text()");
        queryName.setIsCDATA(true);
        descriptor.addMapping((DatabaseMapping)queryName);
        return descriptor;
    }

    protected XMLDescriptor buildJpqlQueryDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(JPQLQueryHandler.class);
        descriptor.setDefaultRootElement("jpql");
        XMLDirectMapping queryName = new XMLDirectMapping();
        queryName.setAttributeName("jpqlString");
        queryName.setXPath("text()");
        queryName.setIsCDATA(true);
        descriptor.addMapping((DatabaseMapping)queryName);
        return descriptor;
    }

    protected XMLDescriptor buildStoredProcedureQueryDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(StoredProcedureQueryHandler.class);
        descriptor.setDefaultRootElement("stored-procedure");
        XMLDirectMapping procedureName = new XMLDirectMapping();
        procedureName.setAttributeName("name");
        procedureName.setXPath("name/text()");
        descriptor.addMapping((DatabaseMapping)procedureName);
        XMLCompositeCollectionMapping inArguments = new XMLCompositeCollectionMapping();
        inArguments.setAttributeName("inArguments");
        inArguments.setXPath("in-argument");
        inArguments.setReferenceClass(ProcedureArgument.class);
        descriptor.addMapping((DatabaseMapping)inArguments);
        XMLCompositeCollectionMapping inOutArguments = new XMLCompositeCollectionMapping();
        inOutArguments.setAttributeName("inOutArguments");
        inOutArguments.setXPath("inout-argument");
        inOutArguments.setReferenceClass(ProcedureOutputArgument.class);
        descriptor.addMapping((DatabaseMapping)inOutArguments);
        XMLCompositeCollectionMapping outArguments = new XMLCompositeCollectionMapping();
        outArguments.setAttributeName("outArguments");
        outArguments.setXPath("out-argument");
        outArguments.setReferenceClass(ProcedureOutputArgument.class);
        descriptor.addMapping((DatabaseMapping)outArguments);
        return descriptor;
    }

    protected XMLDescriptor buildStoredFunctionQueryDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(StoredFunctionQueryHandler.class);
        descriptor.setDefaultRootElement("stored-function");
        XMLDirectMapping procedureName = new XMLDirectMapping();
        procedureName.setAttributeName("name");
        procedureName.setXPath("name/text()");
        descriptor.addMapping((DatabaseMapping)procedureName);
        XMLCompositeCollectionMapping inArguments = new XMLCompositeCollectionMapping();
        inArguments.setAttributeName("inArguments");
        inArguments.setXPath("in-argument");
        inArguments.setReferenceClass(ProcedureArgument.class);
        descriptor.addMapping((DatabaseMapping)inArguments);
        XMLCompositeCollectionMapping inOutArguments = new XMLCompositeCollectionMapping();
        inOutArguments.setAttributeName("inOutArguments");
        inOutArguments.setXPath("inout-argument");
        inOutArguments.setReferenceClass(ProcedureOutputArgument.class);
        descriptor.addMapping((DatabaseMapping)inOutArguments);
        XMLCompositeCollectionMapping outArguments = new XMLCompositeCollectionMapping();
        outArguments.setAttributeName("outArguments");
        outArguments.setXPath("out-argument");
        outArguments.setReferenceClass(ProcedureOutputArgument.class);
        descriptor.addMapping((DatabaseMapping)outArguments);
        return descriptor;
    }

    protected XMLDescriptor buildProcedureArgumentDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(ProcedureArgument.class);
        XMLDirectMapping argumentName = new XMLDirectMapping();
        argumentName.setAttributeName("name");
        argumentName.setXPath("name");
        descriptor.addMapping((DatabaseMapping)argumentName);
        XMLDirectMapping parameterName = new XMLDirectMapping();
        parameterName.setAttributeName("parameterName");
        parameterName.setXPath("parameter");
        descriptor.addMapping((DatabaseMapping)parameterName);
        XMLDirectMapping complexTypeName = new XMLDirectMapping();
        complexTypeName.setAttributeName("complexTypeName");
        complexTypeName.setXPath("complex-type");
        descriptor.addMapping((DatabaseMapping)complexTypeName);
        XMLDirectMapping jdbcTypeMapping = new XMLDirectMapping();
        jdbcTypeMapping.setAttributeName("jdbcType");
        jdbcTypeMapping.setXPath("@jdbcType");
        descriptor.addMapping((DatabaseMapping)jdbcTypeMapping);
        return descriptor;
    }

    protected XMLDescriptor buildProcedureOutputArgumentDescriptor() {
        XMLDescriptor descriptor = this.buildProcedureArgumentDescriptor();
        descriptor.setJavaClass(ProcedureOutputArgument.class);
        XMLTransformationMapping resultType = new XMLTransformationMapping();
        resultType.setAttributeName("resultType");
        QNameTransformer qNameTransformer = new QNameTransformer("type/text()");
        resultType.addFieldTransformer("type/text()", (FieldTransformer)qNameTransformer);
        resultType.setAttributeTransformer((AttributeTransformer)qNameTransformer);
        descriptor.addMapping((DatabaseMapping)resultType);
        return descriptor;
    }

    protected XMLDescriptor buildInsertDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(InsertOperation.class);
        descriptor.setDefaultRootElement("insert");
        XMLDirectMapping name = new XMLDirectMapping();
        name.setAttributeName("name");
        name.setXPath("name/text()");
        descriptor.addMapping((DatabaseMapping)name);
        XMLCompositeCollectionMapping parameters = new XMLCompositeCollectionMapping();
        parameters.setAttributeName("parameters");
        parameters.setReferenceClass(Parameter.class);
        parameters.setXPath("parameter");
        descriptor.addMapping((DatabaseMapping)parameters);
        return descriptor;
    }

    protected XMLDescriptor buildDeleteDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(DeleteOperation.class);
        descriptor.setDefaultRootElement("delete");
        XMLDirectMapping name = new XMLDirectMapping();
        name.setAttributeName("name");
        name.setXPath("name/text()");
        descriptor.addMapping((DatabaseMapping)name);
        XMLDirectMapping descriptorName = new XMLDirectMapping();
        descriptorName.setAttributeName("descriptorName");
        descriptorName.setXPath("descriptor-name/text()");
        descriptor.addMapping((DatabaseMapping)descriptorName);
        XMLDirectMapping findByPKQuery = new XMLDirectMapping();
        findByPKQuery.setAttributeName("findByPKQuery");
        findByPKQuery.setXPath("find-by-pk-query/text()");
        descriptor.addMapping((DatabaseMapping)findByPKQuery);
        XMLCompositeCollectionMapping parameters = new XMLCompositeCollectionMapping();
        parameters.setAttributeName("parameters");
        parameters.setReferenceClass(Parameter.class);
        parameters.setXPath("parameter");
        descriptor.addMapping((DatabaseMapping)parameters);
        return descriptor;
    }

    protected XMLDescriptor buildUpdateDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(UpdateOperation.class);
        descriptor.setDefaultRootElement("update");
        XMLDirectMapping name = new XMLDirectMapping();
        name.setAttributeName("name");
        name.setXPath("name/text()");
        descriptor.addMapping((DatabaseMapping)name);
        XMLCompositeCollectionMapping parameters = new XMLCompositeCollectionMapping();
        parameters.setAttributeName("parameters");
        parameters.setReferenceClass(Parameter.class);
        parameters.setXPath("parameter");
        descriptor.addMapping((DatabaseMapping)parameters);
        return descriptor;
    }
}

