/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sequencing;

import java.util.Vector;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.sequencing.Sequence;

public abstract class StandardSequence
extends Sequence {
    public StandardSequence() {
    }

    public StandardSequence(String name) {
        super(name);
    }

    public StandardSequence(String name, int size) {
        super(name, size);
    }

    public StandardSequence(String name, int size, int initialValue) {
        super(name, size, initialValue);
    }

    @Override
    public void onConnect() {
    }

    @Override
    public void onDisconnect() {
    }

    protected abstract Number updateAndSelectSequence(Accessor var1, AbstractSession var2, String var3, int var4);

    @Override
    public abstract boolean shouldAcquireValueAfterInsert();

    @Override
    public abstract boolean shouldUseTransaction();

    @Override
    public Object getGeneratedValue(Accessor accessor, AbstractSession writeSession, String seqName) {
        if (this.shouldUsePreallocation()) {
            return null;
        }
        Number value = this.updateAndSelectSequence(accessor, writeSession, seqName, 1);
        if (value == null) {
            throw DatabaseException.errorPreallocatingSequenceNumbers();
        }
        return value;
    }

    @Override
    public Vector getGeneratedVector(Accessor accessor, AbstractSession writeSession, String seqName, int size) {
        if (this.shouldUsePreallocation()) {
            Number value = this.updateAndSelectSequence(accessor, writeSession, seqName, size);
            if (value == null) {
                throw DatabaseException.errorPreallocatingSequenceNumbers();
            }
            return this.createVector(value, seqName, size);
        }
        return null;
    }

    protected Vector createVector(Number sequence, String seqName, int size) {
        long nextSequence = sequence.longValue();
        Vector<Long> sequencesForName = new Vector<Long>(size);
        if ((nextSequence -= (long)size) < -1L) {
            throw ValidationException.sequenceSetupIncorrectly(seqName);
        }
        int index = size;
        while (index > 0) {
            sequencesForName.add(++nextSequence);
            --index;
        }
        return sequencesForName;
    }

    @Override
    public void setInitialValue(int initialValue) {
        if (initialValue <= 0) {
            initialValue = 1;
        }
        super.setInitialValue(initialValue);
    }
}

