/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.databaseaccess;

import java.sql.Array;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Struct;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.structures.ObjectRelationalDataTypeDescriptor;
import org.eclipse.persistence.mappings.structures.ObjectRelationalDatabaseField;

public class BindCallCustomParameter {
    protected Object obj;

    public boolean shouldUseUnwrappedConnection() {
        return false;
    }

    public BindCallCustomParameter(Object obj) {
        this.obj = obj;
    }

    protected BindCallCustomParameter() {
    }

    public void set(DatabasePlatform platform, PreparedStatement statement, int index, AbstractSession session) throws SQLException {
        platform.setParameterValueInDatabaseCall(this.obj, statement, index, session);
    }

    public String toString() {
        if (this.obj != null) {
            return this.obj.toString();
        }
        return "null";
    }

    public Object convert(Object parameter, DatabaseField dbField, AbstractSession session, Connection connection) throws SQLException {
        if (parameter == null) {
            return dbField;
        }
        if (dbField == null || !dbField.isObjectRelationalDatabaseField()) {
            return parameter;
        }
        ObjectRelationalDatabaseField ordField = (ObjectRelationalDatabaseField)dbField;
        if (dbField.getSqlType() == 2002) {
            ClassDescriptor descriptor;
            if (!(parameter instanceof Struct) && (descriptor = session.getDescriptor(parameter)) != null && descriptor.isObjectRelationalDataTypeDescriptor()) {
                ObjectRelationalDataTypeDescriptor ord = (ObjectRelationalDataTypeDescriptor)descriptor;
                AbstractRecord nestedRow = ord.getObjectBuilder().buildRow(parameter, session);
                return ord.buildStructureFromRow(nestedRow, session, connection);
            }
            return parameter;
        }
        if (parameter instanceof Object[]) {
            parameter = Arrays.asList((Object[])parameter);
        }
        if (dbField.getSqlType() != 2003 || parameter instanceof Array || !(parameter instanceof Collection)) {
            return parameter;
        }
        Collection container = parameter;
        DatabaseField nestedType = ordField.getNestedTypeField();
        Object[] fields = new Object[container.size()];
        int i = 0;
        for (Object element : container) {
            if (element != null) {
                element = this.convert(element, nestedType, session, connection);
            }
            fields[i++] = element;
        }
        return session.getPlatform().createArray(((ObjectRelationalDatabaseField)dbField).getSqlTypeName(), fields, session, connection);
    }
}

