/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa;

import java.util.Vector;
import javax.persistence.Cache;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.jpa.CMP3Policy;
import org.eclipse.persistence.internal.jpa.EntityManagerFactoryImpl;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.sessions.IdentityMapAccessor;
import org.eclipse.persistence.sessions.server.ServerSession;

public class CacheImpl
implements Cache {
    private IdentityMapAccessor accessor;
    private EntityManagerFactoryImpl emf;
    private ServerSession serversession;

    public CacheImpl(EntityManagerFactoryImpl emf, IdentityMapAccessor accessor) {
        this.accessor = accessor;
        this.emf = emf;
        this.serversession = emf.getServerSession();
    }

    public boolean contains(Class cls, Object primaryKey) {
        this.emf.verifyOpen();
        Vector pk = this.createPKVector(cls, primaryKey);
        ClassDescriptor descriptor = this.serversession.getDescriptor(cls);
        CacheKey key = ((org.eclipse.persistence.internal.sessions.IdentityMapAccessor)this.accessor).getCacheKeyForObject(pk, cls, descriptor);
        return key != null && !descriptor.getCacheInvalidationPolicy().isInvalidated(key);
    }

    public void evict(Class cls, Object primaryKey) {
        this.emf.verifyOpen();
        this.accessor.invalidateObject(this.createPKVector(cls, primaryKey), cls);
    }

    public void evict(Class cls) {
        this.emf.verifyOpen();
        this.accessor.invalidateClass(cls);
    }

    public void evictAll() {
        this.emf.verifyOpen();
        this.accessor.invalidateAll();
    }

    private Vector createPKVector(Class cls, Object primaryKey) {
        ClassDescriptor cdesc = this.serversession.getDescriptor(cls);
        CMP3Policy cmp = (CMP3Policy)cdesc.getCMPPolicy();
        Vector pk = cmp.createPkVectorFromKey(primaryKey, (AbstractSession)this.serversession);
        return pk;
    }
}

