/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.animation;

import org.eclipse.swt.graphics.Point;
import org.eclipse.xwt.XWTException;
import org.eclipse.xwt.animation.AnimationTimeline;
import org.eclipse.xwt.animation.IEasingFunction;
import org.eclipse.xwt.animation.internal.ITimeline;
import org.eclipse.xwt.animation.internal.TridentTimeline;
import org.eclipse.xwt.animation.interpolator.PointPropertyInterpolator;
import org.pushingpixels.trident.TridentConfig;
import org.pushingpixels.trident.interpolator.PropertyInterpolator;

public class PointAnimation
extends AnimationTimeline {
    private Point from;
    private Point to;
    private Point by;
    private IEasingFunction easingFunction;

    static {
        TridentConfig.getInstance().addPropertyInterpolator((PropertyInterpolator)new PointPropertyInterpolator());
    }

    public IEasingFunction getEasingFunction() {
        return this.easingFunction;
    }

    public void setEasingFunction(IEasingFunction easingFunction) {
        this.easingFunction = easingFunction;
    }

    public Point getFrom() {
        return this.from;
    }

    public void setFrom(Point from) {
        this.from = from;
    }

    public Point getTo() {
        return this.to;
    }

    public void setTo(Point to) {
        this.to = to;
    }

    @Override
    protected void updateTimeline(ITimeline timeline, Object target) {
        super.updateTimeline(timeline, target);
        if (timeline instanceof TridentTimeline) {
            TridentTimeline tridentTimeline = (TridentTimeline)timeline;
            Point from = this.getFrom();
            Point to = this.getTo();
            if (from == null && to == null) {
                from = (Point)this.getCacheValue();
                to = (Point)this.getCurrentValue(target);
                if (from.x == 0 && from.y == 0) {
                    this.setCacheValue(to);
                    throw new XWTException("action ignored");
                }
                if (from != null && from.equals((Object)to)) {
                    throw new XWTException("action ignored");
                }
            }
            tridentTimeline.addPropertyToInterpolate(this.getTargetProperty(), from, to);
            tridentTimeline.setEasingFunction(this.getEasingFunction());
        }
    }
}

