/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.internal;

import java.util.Set;
import org.eclipse.sapphire.ElementProperty;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.ListProperty;
import org.eclipse.sapphire.PossibleTypesService;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.Type;

public final class StandardPossibleTypesService
extends PossibleTypesService {
    private boolean ordered;

    @Override
    protected void initPossibleTypesService() {
        PropertyDef property = this.context(PropertyDef.class);
        Type typeAnnotation = property.getAnnotation(Type.class);
        if (typeAnnotation != null) {
            this.ordered = typeAnnotation.ordered();
        }
    }

    @Override
    protected void compute(Set<ElementType> types) {
        PropertyDef property = this.context(PropertyDef.class);
        Type typeAnnotation = property.getAnnotation(Type.class);
        if ((property instanceof ElementProperty || property instanceof ListProperty) && typeAnnotation != null) {
            if (typeAnnotation.possible().length == 0) {
                types.add(ElementType.read(typeAnnotation.base()));
            } else {
                Class<?>[] classArray = typeAnnotation.possible();
                int n = classArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Class<?> cl = classArray[n2];
                    types.add(ElementType.read(cl));
                    ++n2;
                }
            }
        }
    }

    @Override
    public boolean ordered() {
        return this.ordered;
    }
}

