/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementData;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Index;
import org.eclipse.sapphire.ListProperty;
import org.eclipse.sapphire.ListPropertyBinding;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.LoggingService;
import org.eclipse.sapphire.PossibleTypesService;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.Sapphire;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.internal.NonSuspendableListener;
import org.eclipse.sapphire.modeling.ModelPath;
import org.eclipse.sapphire.util.EqualsFactory;
import org.eclipse.sapphire.util.HashCodeFactory;

public final class ElementList<T extends Element>
extends Property
implements List<T> {
    private static final Comparator<String> DEFAULT_COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String str1, String str2) {
            return str1.compareTo(str2);
        }
    };
    private List<T> content;
    private Map<IndexCacheKey, Index<T>> indexes;

    public ElementList(Element element, ListProperty property) {
        super(element, property);
    }

    public static <TX extends Element> Class<ElementList<TX>> of(Class<TX> type) {
        return ElementList.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh() {
        Element element = this.root();
        synchronized (element) {
            this.init();
            this.refreshContent(false);
            if (this.content != null) {
                for (Element element2 : this.content) {
                    element2.refresh();
                }
            }
            this.refreshEnablement(false);
            this.refreshValidation(false);
        }
    }

    private void refreshContent(boolean onlyIfNotInitialized) {
        boolean initialized;
        boolean bl = initialized = (this.initialization & 8) != 0;
        if (!initialized || !onlyIfNotInitialized) {
            boolean proceed;
            ListPropertyBinding binding = this.binding();
            List<? extends Resource> freshResources = binding.read();
            int freshContentSize = freshResources.size();
            boolean bl2 = initialized = (this.initialization & 8) != 0;
            if (initialized) {
                if (this.content.size() == freshContentSize) {
                    proceed = false;
                    int i = 0;
                    while (i < freshContentSize) {
                        if (((Element)this.content.get(i)).resource() != freshResources.get(i)) {
                            proceed = true;
                            break;
                        }
                        ++i;
                    }
                } else {
                    proceed = true;
                }
            } else {
                proceed = true;
            }
            if (proceed) {
                ArrayList<T> freshContent = new ArrayList<T>(freshContentSize);
                for (Resource resource : freshResources) {
                    Object element = null;
                    if (this.content != null) {
                        for (Element x : this.content) {
                            if (resource != x.resource()) continue;
                            element = x;
                            break;
                        }
                    }
                    if (element == null) {
                        ElementType type = binding.type(resource);
                        element = type.instantiate(this, resource);
                    }
                    freshContent.add(element);
                }
                ArrayList<Element> arrayList = new ArrayList<Element>(1);
                if (this.content != null) {
                    for (Element x : this.content) {
                        boolean retained = false;
                        for (Element y : freshContent) {
                            if (x != y) continue;
                            retained = true;
                            break;
                        }
                        if (retained) continue;
                        arrayList.add(x);
                    }
                }
                PropertyContentEvent event = null;
                this.content = freshContent;
                if (initialized) {
                    event = new PropertyContentEvent(this);
                } else {
                    this.initialization = (byte)(this.initialization | 8);
                }
                for (Element x : arrayList) {
                    try {
                        x.dispose();
                    }
                    catch (Exception e) {
                        Sapphire.service(LoggingService.class).log(e);
                    }
                }
                this.broadcast(event);
            }
        }
    }

    @Override
    public ListProperty definition() {
        return (ListProperty)super.definition();
    }

    @Override
    protected ListPropertyBinding binding() {
        return (ListPropertyBinding)super.binding();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void attach(Listener listener, ModelPath path) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        if (path == null) {
            throw new IllegalArgumentException();
        }
        Element element = this.root();
        synchronized (element) {
            ModelPath.Segment head;
            this.assertNotDisposed();
            if (path.length() > 0 && ((head = path.head()) instanceof ModelPath.AllDescendentsSegment || head instanceof ModelPath.PropertySegment || head instanceof ModelPath.TypeFilterSegment)) {
                this.attach(listener);
                this.attach(new PropagationListener(listener, path));
                for (Element element2 : this) {
                    element2.attach(listener, path);
                }
                return;
            }
            super.attach(listener, path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void detach(Listener listener, ModelPath path) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        if (path == null) {
            throw new IllegalArgumentException();
        }
        Element element = this.root();
        synchronized (element) {
            ModelPath.Segment head;
            if (path.length() > 0 && ((head = path.head()) instanceof ModelPath.AllDescendentsSegment || head instanceof ModelPath.PropertySegment || head instanceof ModelPath.TypeFilterSegment)) {
                this.detach(listener);
                this.detach(new PropagationListener(listener, path));
                for (Element element2 : this) {
                    element2.detach(listener, path);
                }
                return;
            }
            super.detach(listener, path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T insert() {
        Element element = this.root();
        synchronized (element) {
            this.init();
            this.refreshContent(true);
            this.ensureNotReadOnly();
            return this.insert$((ElementType)null, this.size$());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T insert(int position) {
        Element element = this.root();
        synchronized (element) {
            this.init();
            this.refreshContent(true);
            this.ensureNotReadOnly();
            return this.insert$((ElementType)null, position);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T insert(ElementType type) {
        Element element = this.root();
        synchronized (element) {
            this.init();
            this.refreshContent(true);
            this.ensureNotReadOnly();
            return this.insert$(type, this.size$());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <C extends Element> C insert(Class<C> cl) {
        Element element = this.root();
        synchronized (element) {
            this.init();
            this.refreshContent(true);
            this.ensureNotReadOnly();
            return this.insert$(cl, this.size$());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T insert(ElementType type, int position) {
        Element element = this.root();
        synchronized (element) {
            this.init();
            this.refreshContent(true);
            this.ensureNotReadOnly();
            return this.insert$(type, position);
        }
    }

    private T insert$(ElementType type, int position) {
        Set<ElementType> possible = this.service(PossibleTypesService.class).types();
        ElementType t = type;
        if (t == null) {
            if (possible.size() > 1) {
                throw new IllegalArgumentException();
            }
            t = possible.iterator().next();
        } else if (!possible.contains(t)) {
            throw new IllegalArgumentException();
        }
        Resource resource = this.binding().insert(t, position);
        this.refresh();
        Element element = null;
        for (Element x : this.content) {
            if (x.resource() != resource) continue;
            element = x;
            element.initialize();
            break;
        }
        if (element == null) {
            throw new IllegalStateException();
        }
        return (T)element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <C extends Element> C insert(Class<C> cl, int position) {
        Element element = this.root();
        synchronized (element) {
            this.init();
            this.refreshContent(true);
            this.ensureNotReadOnly();
            return this.insert$(cl, position);
        }
    }

    private <C extends Element> C insert$(Class<C> cl, int position) {
        ElementType type = null;
        if (cl != null && (type = ElementType.read(cl)) == null) {
            throw new IllegalArgumentException();
        }
        return (C)this.insert$(type, position);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copy(Element source) {
        Element element = this.root();
        synchronized (element) {
            this.init();
            this.refreshContent(true);
            this.ensureNotReadOnly();
            if (source == null) {
                throw new IllegalArgumentException();
            }
            Property p = source.property(this.name());
            if (p instanceof ElementList) {
                this.clear$();
                Set<ElementType> possibleTypes = this.service(PossibleTypesService.class).types();
                for (Element sourceChildElement : (ElementList)p) {
                    ElementType sourceChildElementType = sourceChildElement.type();
                    if (!possibleTypes.contains(sourceChildElementType)) continue;
                    T targetChildElement = this.insert$(sourceChildElement.type(), this.size$());
                    targetChildElement.copy(sourceChildElement);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copy(ElementData source) {
        Element element = this.root();
        synchronized (element) {
            this.init();
            this.refreshContent(true);
            this.ensureNotReadOnly();
            if (source == null) {
                throw new IllegalArgumentException();
            }
            Object content = source.read(this.name());
            this.clear$();
            if (content instanceof List) {
                Set<ElementType> possibleTypes = this.service(PossibleTypesService.class).types();
                for (Object item : (List)content) {
                    ElementData sourceChildElementData = (ElementData)item;
                    ElementType sourceChildElementType = sourceChildElementData.type();
                    if (!possibleTypes.contains(sourceChildElementType)) continue;
                    T targetChildElement = this.insert$(sourceChildElementData.type(), this.size$());
                    targetChildElement.copy(sourceChildElementData);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void move(Element element, int position) {
        Element element2 = this.root();
        synchronized (element2) {
            this.init();
            this.refreshContent(true);
            this.ensureNotReadOnly();
            if (position < 0 || position > this.size()) {
                throw new IllegalArgumentException();
            }
            int oldPosition = this.indexOf$(element);
            if (oldPosition == -1) {
                throw new IllegalArgumentException();
            }
            if (position != oldPosition) {
                this.binding().move(element.resource(), position);
                this.refresh();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveUp(Element element) {
        Element element2 = this.root();
        synchronized (element2) {
            this.init();
            this.refreshContent(true);
            this.ensureNotReadOnly();
            int index = this.indexOf$(element);
            if (index == -1) {
                throw new IllegalArgumentException();
            }
            if (index > 0) {
                Element previous = (Element)this.content.get(index - 1);
                this.swap$(element, previous);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveDown(Element element) {
        Element element2 = this.root();
        synchronized (element2) {
            this.init();
            this.refreshContent(true);
            this.ensureNotReadOnly();
            int index = this.indexOf$(element);
            if (index == -1) {
                throw new IllegalArgumentException();
            }
            if (index < this.content.size() - 1) {
                Element next = (Element)this.content.get(index + 1);
                this.swap$(element, next);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void swap(Element a, Element b) {
        Element element = this.root();
        synchronized (element) {
            this.init();
            this.refreshContent(true);
            this.ensureNotReadOnly();
            this.swap$(a, b);
        }
    }

    private void swap$(Element a, Element b) {
        int aPosition = this.indexOf$(a);
        int bPosition = this.indexOf$(b);
        if (aPosition == -1 || bPosition == -1) {
            throw new IllegalArgumentException();
        }
        if (aPosition != bPosition) {
            ListPropertyBinding binding = this.binding();
            binding.move(a.resource(), bPosition);
            binding.move(b.resource(), aPosition);
            this.refresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object object) {
        Element element = this.root();
        synchronized (element) {
            this.init();
            this.refreshContent(true);
            this.ensureNotReadOnly();
            return this.remove$(object);
        }
    }

    private boolean remove$(Object object) {
        if (this.contains$(object)) {
            Resource resource = ((Element)object).resource();
            this.binding().remove(resource);
            this.refresh();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T remove(int index) {
        Element element = this.root();
        synchronized (element) {
            this.init();
            this.refreshContent(true);
            this.ensureNotReadOnly();
            Element element2 = (Element)this.content.get(index);
            this.remove$(element2);
            return (T)element2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAll(Collection<?> collection) {
        Element element = this.root();
        synchronized (element) {
            this.init();
            this.refreshContent(true);
            this.ensureNotReadOnly();
            boolean changed = false;
            for (Object object : collection) {
                boolean bl = changed = this.remove$(object) || changed;
            }
            return changed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean retainAll(Collection<?> collection) {
        Element element = this.root();
        synchronized (element) {
            this.init();
            this.refreshContent(true);
            this.ensureNotReadOnly();
            boolean changed = false;
            for (Element element2 : this) {
                if (collection.contains(element2)) continue;
                boolean bl = changed = this.remove$(element2) || changed;
            }
            return changed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Element element = this.root();
        synchronized (element) {
            this.init();
            this.refreshContent(true);
            this.ensureNotReadOnly();
            this.clear$();
        }
    }

    private void clear$() {
        for (Element element : this.content) {
            this.remove$(element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get(int index) {
        Element element = this.root();
        synchronized (element) {
            this.init();
            this.refreshContent(true);
            return (T)((Element)this.content.get(index));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int indexOf(Object object) {
        Element element = this.root();
        synchronized (element) {
            this.init();
            this.refreshContent(true);
            return this.indexOf$(object);
        }
    }

    private int indexOf$(Object object) {
        int index = -1;
        int i = 0;
        int n = this.content.size();
        while (i < n) {
            if (this.content.get(i) == object) {
                index = i;
                break;
            }
            ++i;
        }
        return index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int lastIndexOf(Object object) {
        Element element = this.root();
        synchronized (element) {
            this.init();
            this.refreshContent(true);
            int index = -1;
            int i = 0;
            int n = this.content.size();
            while (i < n) {
                if (this.content.get(i) == object) {
                    index = i;
                }
                ++i;
            }
            return index;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object object) {
        Element element = this.root();
        synchronized (element) {
            this.init();
            this.refreshContent(true);
            return this.contains$(object);
        }
    }

    private boolean contains$(Object object) {
        for (T x : this.content) {
            if (x != object) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean containsAll(Collection<?> collection) {
        Element element = this.root();
        synchronized (element) {
            Object x;
            this.init();
            this.refreshContent(true);
            Iterator<?> iterator = collection.iterator();
            do {
                if (iterator.hasNext()) continue;
                return true;
            } while (this.contains$(x = iterator.next()));
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        Element element = this.root();
        synchronized (element) {
            this.init();
            this.refreshContent(true);
            return this.content.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean empty() {
        Element element = this.root();
        synchronized (element) {
            this.init();
            this.refreshContent(true);
            return this.content.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Element element = this.root();
        synchronized (element) {
            this.init();
            this.refreshContent(true);
            return this.size$();
        }
    }

    private int size$() {
        return this.content.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<T> iterator() {
        Element element = this.root();
        synchronized (element) {
            this.init();
            this.refreshContent(true);
            return new Itr<T>(this.content.iterator());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListIterator<T> listIterator() {
        Element element = this.root();
        synchronized (element) {
            this.init();
            this.refreshContent(true);
            return new ListItr<T>(this.content.listIterator());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListIterator<T> listIterator(int index) {
        Element element = this.root();
        synchronized (element) {
            this.init();
            this.refreshContent(true);
            return new ListItr<T>(this.content.listIterator(index));
        }
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] toArray() {
        Element element = this.root();
        synchronized (element) {
            this.init();
            this.refreshContent(true);
            return this.content.toArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <E> E[] toArray(E[] array) {
        Element element = this.root();
        synchronized (element) {
            this.init();
            this.refreshContent(true);
            return this.content.toArray(array);
        }
    }

    @Override
    public boolean add(T object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int index, T element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends T> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public T set(int index, T element) {
        throw new UnsupportedOperationException();
    }

    public Index<T> index(ValueProperty property) {
        if (property == null) {
            throw new IllegalArgumentException();
        }
        return this.index(property.name(), null);
    }

    public Index<T> index(ValueProperty property, Comparator<String> comparator) {
        if (property == null) {
            throw new IllegalArgumentException();
        }
        return this.index(property.name(), comparator);
    }

    public Index<T> index(String property) {
        if (property == null) {
            throw new IllegalArgumentException();
        }
        return this.index(property, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Index<T> index(String property, Comparator<String> comparator) {
        if (property == null) {
            throw new IllegalArgumentException();
        }
        if (property.indexOf(47) != -1) {
            throw new IllegalArgumentException();
        }
        ElementType entryType = this.definition().getType();
        Object p = entryType.property(property);
        if (p == null) {
            throw new IllegalArgumentException();
        }
        if (!(p instanceof ValueProperty)) {
            throw new IllegalArgumentException();
        }
        ValueProperty vp = (ValueProperty)p;
        Comparator<String> c = comparator == null ? DEFAULT_COMPARATOR : comparator;
        Element element = this.root();
        synchronized (element) {
            Index<T> index;
            this.assertNotDisposed();
            IndexCacheKey key = new IndexCacheKey(vp, c);
            if (this.indexes == null) {
                this.indexes = new HashMap<IndexCacheKey, Index<T>>();
            }
            if ((index = this.indexes.get(key)) == null) {
                index = new Index(this, vp, c);
                this.indexes.put(key, index);
            }
            return index;
        }
    }

    @Override
    protected void disposeOther() {
        if (this.content != null) {
            for (Element element : this.content) {
                element.dispose();
            }
            this.content = null;
        }
        this.indexes = null;
    }

    private void ensureNotReadOnly() {
        if (this.definition().isReadOnly()) {
            throw new UnsupportedOperationException();
        }
    }

    private static final class IndexCacheKey {
        private final ValueProperty property;
        private final Comparator<String> comparator;

        public IndexCacheKey(ValueProperty property, Comparator<String> comparator) {
            this.property = property;
            this.comparator = comparator;
        }

        public int hashCode() {
            return HashCodeFactory.start().add(this.property.name()).add(this.comparator).result();
        }

        public boolean equals(Object obj) {
            if (obj instanceof IndexCacheKey) {
                IndexCacheKey key = (IndexCacheKey)obj;
                return EqualsFactory.start().add(this.property, key.property).add(this.comparator, key.comparator).result();
            }
            return false;
        }
    }

    private static class Itr<T>
    implements Iterator<T> {
        private final Iterator<T> baseIterator;

        public Itr(Iterator<T> baseIterator) {
            this.baseIterator = baseIterator;
        }

        @Override
        public boolean hasNext() {
            return this.baseIterator.hasNext();
        }

        @Override
        public T next() {
            return this.baseIterator.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static final class ListItr<T>
    extends Itr<T>
    implements ListIterator<T> {
        private final ListIterator<T> baseIterator;

        public ListItr(ListIterator<T> baseIterator) {
            super(baseIterator);
            this.baseIterator = baseIterator;
        }

        @Override
        public int nextIndex() {
            return this.baseIterator.nextIndex();
        }

        @Override
        public boolean hasPrevious() {
            return this.baseIterator.hasPrevious();
        }

        @Override
        public T previous() {
            return this.baseIterator.previous();
        }

        @Override
        public int previousIndex() {
            return this.baseIterator.previousIndex();
        }

        @Override
        public void add(T object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(T object) {
            throw new UnsupportedOperationException();
        }
    }

    private static final class PropagationListener
    extends FilteredListener<PropertyContentEvent>
    implements NonSuspendableListener {
        private final Listener listener;
        private final ModelPath path;

        public PropagationListener(Listener listener, ModelPath path) {
            this.listener = listener;
            this.path = path;
        }

        public boolean equals(Object obj) {
            if (obj instanceof PropagationListener) {
                PropagationListener pl = (PropagationListener)obj;
                return this.listener.equals(pl.listener) && this.path.equals(pl.path);
            }
            return false;
        }

        public int hashCode() {
            return this.listener.hashCode() ^ this.path.hashCode();
        }

        @Override
        protected void handleTypedEvent(PropertyContentEvent event) {
            for (Element element : (ElementList)event.property()) {
                element.attach(this.listener, this.path);
            }
        }
    }
}

