/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.core.util;

import org.eclipse.reddeer.common.util.Display;
import org.eclipse.reddeer.common.util.ResultRunnable;
import org.eclipse.reddeer.core.handler.ControlHandler;
import org.eclipse.reddeer.core.handler.ShellHandler;
import org.eclipse.reddeer.core.lookup.ShellLookup;
import org.eclipse.reddeer.core.lookup.WidgetLookup;
import org.eclipse.reddeer.core.util.TextWidgetUtil;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class DiagnosticTool {
    public static final String DEFAULT_LINE_DELIMITER = "\n";
    public static final String DEFAULT_INDENT = "\t";
    private int initialIndentation;
    private String indentation;
    private String lineDelimiter;

    public DiagnosticTool() {
        this(0, DEFAULT_INDENT, DEFAULT_LINE_DELIMITER);
    }

    public DiagnosticTool(int initialIndentation, String indentation, String lineDelimiter) {
        this.initialIndentation = initialIndentation;
        this.indentation = indentation;
        this.lineDelimiter = lineDelimiter;
    }

    public String getShellsDiagnosticInformation() {
        StringBuffer result = new StringBuffer();
        result.append("The following shells are available").append(this.lineDelimiter);
        Shell[] shellArray = ShellLookup.getInstance().getShells();
        int n = shellArray.length;
        int n2 = 0;
        while (n2 < n) {
            Shell shell = shellArray[n2];
            result.append(this.indentation).append(this.getWidgetInformation((Control)shell)).append(this.lineDelimiter);
            ++n2;
        }
        return result.toString();
    }

    public String getDiagnosticInformation(final Control parent) {
        return (String)Display.syncExec((ResultRunnable)new ResultRunnable<String>(){

            public String run() {
                return DiagnosticTool.this.getDiagnosticInformation(parent, DiagnosticTool.this.initialIndentation);
            }
        });
    }

    private String getDiagnosticInformation(Control parent, int depth) {
        Composite composite;
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < depth) {
            result.append(this.indentation);
            ++i;
        }
        result.append(this.getWidgetInformation(parent)).append(this.lineDelimiter);
        if (parent instanceof Composite && (composite = (Composite)parent) != null && !composite.isDisposed() && composite.getChildren() != null) {
            Control[] controlArray = composite.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                result.append(this.getDiagnosticInformation(child, depth + 1));
                ++n2;
            }
        }
        return result.toString();
    }

    protected String getWidgetInformation(Control widget) {
        if (widget == null) {
            return "null";
        }
        StringBuffer result = new StringBuffer();
        result.append(widget.getClass());
        try {
            Shell controlShell = ControlHandler.getInstance().getShell(widget);
            if (controlShell != null && !controlShell.isDisposed()) {
                String shellText = null;
                shellText = ShellHandler.getInstance().getText(controlShell);
                result.append("[shell: '" + shellText + "']");
            }
        }
        catch (Exception exception) {}
        try {
            String label = WidgetLookup.getInstance().getLabel(widget);
            if (label != null) {
                result.append(" with label '" + label + "'");
            }
        }
        catch (Exception exception) {}
        try {
            String text = TextWidgetUtil.getText((Widget)widget);
            if (text != null) {
                result.append(" with text '" + text + "'");
            }
        }
        catch (Exception exception) {}
        return result.toString();
    }
}

