/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.core.lookup;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.reddeer.common.condition.AbstractWaitCondition;
import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.wait.TimePeriod;
import org.eclipse.reddeer.common.wait.WaitUntil;
import org.eclipse.reddeer.core.exception.CoreLayerException;
import org.eclipse.reddeer.core.handler.TreeHandler;
import org.eclipse.reddeer.core.handler.TreeItemHandler;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.hamcrest.Matcher;

public class TreeItemLookup {
    private static TreeItemLookup instance = null;

    private TreeItemLookup() {
    }

    public static TreeItemLookup getInstance() {
        if (instance == null) {
            instance = new TreeItemLookup();
        }
        return instance;
    }

    public TreeItem getTreeItem(Tree tree, int index, Matcher<TreeItem> ... matchers) {
        List<TreeItem> result = this.getTreeItems(tree, matchers);
        if (result.size() < index + 1) {
            throw new CoreLayerException("Specified index (" + index + ") is bigger or equal as the number of found items (" + result.size() + ")");
        }
        return result.get(index);
    }

    public List<TreeItem> getTreeItems(Tree tree, Matcher<TreeItem> ... pathItemMatchers) {
        new WaitUntil((WaitCondition)new TreeHasChildren(tree));
        List<TreeItem> items = TreeHandler.getInstance().getSWTItems(tree);
        return this.getTreeItems(items, pathItemMatchers);
    }

    public TreeItem getTreeItem(TreeItem treeItem, int index, Matcher<TreeItem> ... matchers) {
        List<TreeItem> result = this.getTreeItems(treeItem, matchers);
        if (result.size() < index + 1) {
            throw new CoreLayerException("Specified index (" + index + ") is bigger or equal as the number of found items (" + result.size() + ")");
        }
        return result.get(index);
    }

    public List<TreeItem> getTreeItems(TreeItem treeItem, Matcher<TreeItem> ... pathItemMatchers) {
        List<TreeItem> items = TreeItemHandler.getInstance().getChildrenItems(treeItem);
        return this.getTreeItems(items, pathItemMatchers);
    }

    private List<TreeItem> getTreeItems(List<TreeItem> items, Matcher<TreeItem> ... pathItemMatchers) {
        if (pathItemMatchers.length == 0) {
            return items;
        }
        int index = 0;
        while (index < pathItemMatchers.length) {
            List<TreeItem> matchingItems = this.getMatchingTreeItems(items, pathItemMatchers[index]);
            if (matchingItems.isEmpty()) {
                throw new CoreLayerException("There are no items matching matcher " + pathItemMatchers[index]);
            }
            if (index == pathItemMatchers.length - 1) {
                return matchingItems;
            }
            items = this.getChildItems(matchingItems);
            ++index;
        }
        throw new IllegalStateException("It should never get here. This is probably flaw in lookup algoritnus");
    }

    private List<TreeItem> getChildItems(List<TreeItem> parentItems) {
        ArrayList<TreeItem> children = new ArrayList<TreeItem>();
        for (TreeItem parentItem : parentItems) {
            new WaitUntil((WaitCondition)new TreeItemHasChildren(parentItem), TimePeriod.DEFAULT, false);
            children.addAll(TreeItemHandler.getInstance().getChildrenItems(parentItem));
        }
        return children;
    }

    private List<TreeItem> getMatchingTreeItems(List<TreeItem> items, Matcher<TreeItem> matcher) {
        ArrayList<TreeItem> matchingitems = new ArrayList<TreeItem>();
        for (TreeItem item : items) {
            if (!matcher.matches((Object)item)) continue;
            matchingitems.add(item);
        }
        return matchingitems;
    }

    class TreeHasChildren
    extends AbstractWaitCondition {
        private Tree tree;

        public TreeHasChildren(Tree tree) {
            this.tree = tree;
        }

        public boolean test() {
            return TreeHandler.getInstance().getSWTItems(this.tree).size() > 0;
        }

        public String description() {
            return "tree has children";
        }
    }

    public class TreeItemHasChildren
    extends AbstractWaitCondition {
        private final TreeItem treeItem;

        public TreeItemHasChildren(TreeItem treeItem) {
            this.treeItem = treeItem;
        }

        public boolean test() {
            return TreeItemHandler.getInstance().getChildrenItems(this.treeItem).size() > 0;
        }

        public String description() {
            return "treeItem " + TreeItemHandler.getInstance().getText(this.treeItem, 0) + " has children";
        }
    }
}

