/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.preferences;

import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.util.UIUtil;
import org.eclipse.birt.report.viewer.ViewerPlugin;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class PreviewDataPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final int MAX_DATASET_ROW_DEFAULT = 500;
    public static final int MAX_IN_MEMORY_CUBE_SIZE_DEFAULT = 10;
    public static final int DATASET_DISPLAY_ALL_ROW = 0;
    public static final String PREVIEW_MAXROW = "preview_maxrow";
    public static final String PREVIEW_MAX_IN_MEMORY_CUBE_SIZE = "preview_maxinmemorycubesize";
    private transient DisplayNumberFieldEditor txtMaxDataSetRow;
    private transient IntegerFieldEditor txtMaxInMemoryCubeSize;
    private transient Button noLimitBtn;

    protected Control createContents(Composite parent) {
        UIUtil.bindHelp((Control)parent, (String)"org.eclipse.birt.cshelp.Preference_BIRT_Preview_DATA_ID");
        Composite cmpTop = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        cmpTop.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        cmpTop.setLayoutData((Object)gd);
        this.createDispalyRowLimitGroup(cmpTop);
        this.txtMaxInMemoryCubeSize = new IntegerFieldEditor(PREVIEW_MAX_IN_MEMORY_CUBE_SIZE, Messages.getString((String)"designer.preview.preference.resultset.maxinmemorycubesize.description"), cmpTop);
        this.txtMaxInMemoryCubeSize.setPage((DialogPage)this);
        this.txtMaxInMemoryCubeSize.setValidateStrategy(0);
        this.txtMaxInMemoryCubeSize.setEmptyStringAllowed(false);
        this.txtMaxInMemoryCubeSize.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("field_editor_is_valid")) {
                    PreviewDataPreferencePage.this.setValid(PreviewDataPreferencePage.this.txtMaxInMemoryCubeSize.isValid());
                }
            }
        });
        this.initControlValues();
        return cmpTop;
    }

    private void createDispalyRowLimitGroup(Composite cmpTop) {
        Group dispalyRowLimitGroup = new Group(cmpTop, 0);
        dispalyRowLimitGroup.setText(Messages.getString((String)"designer.preview.preference.resultset.groupTitle.DispalyRowLimitsSetting"));
        GridLayout layout = new GridLayout();
        layout.makeColumnsEqualWidth = true;
        layout.marginHeight = 6;
        layout.marginWidth = 6;
        dispalyRowLimitGroup.setLayout((Layout)layout);
        GridData groupData = new GridData(768);
        groupData.horizontalSpan = 2;
        dispalyRowLimitGroup.setLayoutData((Object)groupData);
        Composite container = new Composite((Composite)dispalyRowLimitGroup, 0);
        container.setLayoutData((Object)new GridData(1808));
        this.noLimitBtn = new Button(container, 32);
        GridData noLimitBtnData = new GridData(768);
        noLimitBtnData.horizontalSpan = 2;
        this.noLimitBtn.setText(Messages.getString((String)"designer.preview.preference.resultset.NoLimitOfDispalyRow"));
        this.noLimitBtn.setLayoutData((Object)noLimitBtnData);
        this.noLimitBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreviewDataPreferencePage.this.txtMaxDataSetRow.setEnabled(!PreviewDataPreferencePage.this.noLimitBtn.getSelection(), PreviewDataPreferencePage.this.noLimitBtn.getParent());
                if (!PreviewDataPreferencePage.this.noLimitBtn.getSelection()) {
                    PreviewDataPreferencePage.this.txtMaxDataSetRow.setFocus();
                }
                PreviewDataPreferencePage.this.txtMaxDataSetRow.checkState();
            }
        });
        this.txtMaxDataSetRow = new DisplayNumberFieldEditor(PREVIEW_MAXROW, Messages.getString((String)"designer.preview.preference.resultset.maxrow.description"), container);
        this.txtMaxDataSetRow.setPage((DialogPage)this);
        this.txtMaxDataSetRow.setValidRange(1, Integer.MAX_VALUE);
        this.txtMaxDataSetRow.setValidateStrategy(0);
        this.txtMaxDataSetRow.setEmptyStringAllowed(false);
        this.txtMaxDataSetRow.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("field_editor_is_valid")) {
                    PreviewDataPreferencePage.this.setValid(PreviewDataPreferencePage.this.txtMaxDataSetRow.isValid());
                }
            }
        });
    }

    private void initControlValues() {
        String defaultMaxRow = ViewerPlugin.getDefault().getPluginPreferences().getString(PREVIEW_MAXROW);
        if (defaultMaxRow == null || defaultMaxRow.trim().length() <= 0) {
            defaultMaxRow = String.valueOf(500);
        }
        boolean previewAllRows = String.valueOf(0).equals(defaultMaxRow.trim());
        this.noLimitBtn.setSelection(previewAllRows);
        this.txtMaxDataSetRow.setEnabled(!previewAllRows, this.noLimitBtn.getParent());
        this.txtMaxDataSetRow.setStringValue(previewAllRows ? "" : defaultMaxRow);
        defaultMaxRow = ViewerPlugin.getDefault().getPluginPreferences().getString(PREVIEW_MAX_IN_MEMORY_CUBE_SIZE);
        if (defaultMaxRow == null || defaultMaxRow.trim().length() <= 0) {
            defaultMaxRow = String.valueOf(10);
        }
        this.txtMaxInMemoryCubeSize.setStringValue(defaultMaxRow);
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        this.txtMaxDataSetRow.setStringValue(String.valueOf(500));
        this.txtMaxInMemoryCubeSize.setStringValue(String.valueOf(10));
        super.performDefaults();
    }

    public boolean performOk() {
        int maxRowValue = this.noLimitBtn.getSelection() ? 0 : this.txtMaxDataSetRow.getIntValue();
        ViewerPlugin.getDefault().getPluginPreferences().setValue(PREVIEW_MAXROW, maxRowValue);
        ViewerPlugin.getDefault().getPluginPreferences().setValue(PREVIEW_MAX_IN_MEMORY_CUBE_SIZE, this.txtMaxInMemoryCubeSize.getIntValue());
        ViewerPlugin.getDefault().savePluginPreferences();
        return super.performOk();
    }

    class DisplayNumberFieldEditor
    extends IntegerFieldEditor {
        public DisplayNumberFieldEditor(String s1, String s2, Composite parent) {
            super(s1, s2, parent);
        }

        public boolean checkState() {
            if (PreviewDataPreferencePage.this.noLimitBtn.getSelection()) {
                PreviewDataPreferencePage.this.setValid(true);
                if (!super.checkState()) {
                    this.clearErrorMessage();
                }
                return true;
            }
            PreviewDataPreferencePage.this.setValid(this.isValid());
            return super.checkState();
        }
    }
}

