/**
 * Copyright (c) 2010-2015, Denes Harmath, Istvan Rath and Daniel Varro
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Denes Harmath - initial API and implementation
 */
package org.eclipse.viatra.query.patternlanguage.validation.whitelist;

import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.viatra.query.patternlanguage.validation.whitelist.PureWhitelist;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;

/**
 * Adds pure elements defined by the appropriate extension to the whitelist.
 */
@SuppressWarnings("all")
public class PureWhitelistExtensionLoader {
  public final static String EXTENSION_ID = "org.eclipse.viatra.query.patternlanguage.purewhitelist";
  
  public static void load() {
    IExtensionRegistry _extensionRegistry = Platform.getExtensionRegistry();
    final IConfigurationElement[] configurationElements = _extensionRegistry.getConfigurationElementsFor(PureWhitelistExtensionLoader.EXTENSION_ID);
    final Function1<IConfigurationElement, PureWhitelist.PureElement> _function = new Function1<IConfigurationElement, PureWhitelist.PureElement>() {
      @Override
      public PureWhitelist.PureElement apply(final IConfigurationElement it) {
        PureWhitelist.PureElement _xblockexpression = null;
        {
          String _attribute = it.getAttribute("fully-qualified-name");
          final String fullyQualifiedName = _attribute.replaceAll("\\s", "");
          String _attribute_1 = it.getAttribute("type");
          String _upperCase = _attribute_1.toUpperCase();
          final PureWhitelist.PureElement.Type type = PureWhitelist.PureElement.Type.valueOf(_upperCase);
          _xblockexpression = new PureWhitelist.PureElement(fullyQualifiedName, type);
        }
        return _xblockexpression;
      }
    };
    final List<PureWhitelist.PureElement> pureElements = ListExtensions.<IConfigurationElement, PureWhitelist.PureElement>map(((List<IConfigurationElement>)Conversions.doWrapArray(configurationElements)), _function);
    final Procedure1<PureWhitelist.PureElement> _function_1 = new Procedure1<PureWhitelist.PureElement>() {
      @Override
      public void apply(final PureWhitelist.PureElement it) {
        PureWhitelist.INSTANCE.add(it);
      }
    };
    IterableExtensions.<PureWhitelist.PureElement>forEach(pureElements, _function_1);
  }
}
