/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.pcap.core.event;

import com.google.common.collect.ImmutableList;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.pcap.core.packet.Packet;
import org.eclipse.tracecompass.internal.pcap.core.protocol.PcapProtocol;
import org.eclipse.tracecompass.internal.tmf.pcap.core.protocol.TmfPcapProtocol;
import org.eclipse.tracecompass.internal.tmf.pcap.core.util.ProtocolConversion;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventType;
import org.eclipse.tracecompass.tmf.core.event.TmfEvent;
import org.eclipse.tracecompass.tmf.core.event.TmfEventType;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class PcapEvent
extends TmfEvent {
    public static final String EVENT_FIELD_PACKET_SOURCE = ":packetsource:";
    public static final String EVENT_FIELD_PACKET_DESTINATION = ":packetdestination:";
    public static final String EVENT_FIELD_PACKET_PROTOCOL = ":protocol:";
    private static final String EMPTY_STRING = "";
    private final Packet fPacket;
    private final String fSource;
    private final String fReference;
    private transient @Nullable Collection<TmfPcapProtocol> fProtocols;

    public PcapEvent(ITmfTrace trace, long rank, ITmfTimestamp timestamp, String source, TmfEventType type, ITmfEventField content, String reference, Packet packet) {
        super(trace, rank, timestamp, (ITmfEventType)type, content);
        this.fPacket = packet;
        this.fSource = source;
        this.fReference = reference;
    }

    public String getSource() {
        return this.fSource;
    }

    public String getReference() {
        return this.fReference;
    }

    public @Nullable Map<String, String> getFields(TmfPcapProtocol protocol) {
        PcapProtocol p = ProtocolConversion.unwrap(protocol);
        Packet packet = this.fPacket.getPacket(p);
        if (packet == null) {
            return null;
        }
        return packet.getFields();
    }

    public @Nullable ByteBuffer getPayload(TmfPcapProtocol protocol) {
        PcapProtocol p = ProtocolConversion.unwrap(protocol);
        Packet packet = this.fPacket.getPacket(p);
        if (packet == null) {
            return null;
        }
        return packet.getPayload();
    }

    public @Nullable String getSourceEndpoint(TmfPcapProtocol protocol) {
        PcapProtocol p = ProtocolConversion.unwrap(protocol);
        Packet packet = this.fPacket.getPacket(p);
        if (packet == null) {
            return null;
        }
        return packet.getSourceEndpoint().toString();
    }

    public @Nullable String getDestinationEndpoint(TmfPcapProtocol protocol) {
        PcapProtocol p = ProtocolConversion.unwrap(protocol);
        Packet packet = this.fPacket.getPacket(p);
        if (packet == null) {
            return null;
        }
        return packet.getDestinationEndpoint().toString();
    }

    public TmfPcapProtocol getMostEncapsulatedProtocol() {
        return ProtocolConversion.wrap(this.fPacket.getMostEcapsulatedPacket().getProtocol());
    }

    public Collection<TmfPcapProtocol> getProtocols() {
        if (this.fProtocols != null) {
            return this.fProtocols;
        }
        ImmutableList.Builder builder = new ImmutableList.Builder();
        Packet packet = this.fPacket;
        while (packet != null && packet.getParentPacket() != null) {
            packet = packet.getParentPacket();
        }
        if (packet == null) {
            this.fProtocols = Collections.EMPTY_LIST;
            return this.fProtocols;
        }
        builder.add((Object)ProtocolConversion.wrap(packet.getProtocol()));
        while (packet != null && packet.getChildPacket() != null) {
            if ((packet = packet.getChildPacket()) == null) continue;
            builder.add((Object)ProtocolConversion.wrap(packet.getProtocol()));
        }
        this.fProtocols = builder.build();
        return this.fProtocols;
    }

    Packet getPacket() {
        return this.fPacket;
    }

    public String toString() {
        return this.fPacket.getGlobalSummaryString();
    }

    public String toString(TmfPcapProtocol protocol) {
        PcapProtocol p = ProtocolConversion.unwrap(protocol);
        Packet packet = this.fPacket.getPacket(p);
        if (packet == null) {
            return EMPTY_STRING;
        }
        return packet.getLocalSummaryString();
    }
}

