/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.os.linux.core.kernel.handlers;

import org.eclipse.tracecompass.analysis.os.linux.core.model.ProcessStatus;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelAnalysisEventLayout;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.kernel.Attributes;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.kernel.handlers.KernelEventHandler;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.kernel.handlers.KernelEventHandlerUtils;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;

public class ProcessForkHandler
extends KernelEventHandler {
    public ProcessForkHandler(IKernelAnalysisEventLayout layout) {
        super(layout);
    }

    @Override
    public void handleEvent(ITmfStateSystemBuilder ss, ITmfEvent event) throws AttributeNotFoundException {
        ITmfEventField content = event.getContent();
        Integer cpu = KernelEventHandlerUtils.getCpu(event);
        String childProcessName = (String)content.getField(new String[]{this.getLayout().fieldChildComm()}).getValue();
        Integer parentTid = ((Long)content.getField(new String[]{this.getLayout().fieldParentTid()}).getValue()).intValue();
        Integer childTid = ((Long)content.getField(new String[]{this.getLayout().fieldChildTid()}).getValue()).intValue();
        Long childPid = (Long)content.getFieldValue(Long.class, new String[]{this.getLayout().fieldChildPid()});
        String parentThreadAttributeName = Attributes.buildThreadAttributeName(parentTid, cpu);
        if (parentThreadAttributeName == null) {
            return;
        }
        String childThreadAttributeName = Attributes.buildThreadAttributeName(childTid, cpu);
        if (childThreadAttributeName == null) {
            return;
        }
        int threadsNode = KernelEventHandlerUtils.getNodeThreads(ss);
        Integer parentTidNode = ss.getQuarkRelativeAndAdd(threadsNode, new String[]{parentThreadAttributeName});
        Integer childTidNode = ss.getQuarkRelativeAndAdd(threadsNode, new String[]{childThreadAttributeName});
        int quark = ss.getQuarkRelativeAndAdd(childTidNode.intValue(), new String[]{"PPID"});
        TmfStateValue value = TmfStateValue.newValueInt((int)parentTid);
        long timestamp = KernelEventHandlerUtils.getTimestamp(event);
        ss.modifyAttribute(timestamp, (ITmfStateValue)value, quark);
        if (childPid != null && childPid.intValue() != childTid.intValue()) {
            quark = ss.getQuarkRelativeAndAdd(childTidNode.intValue(), new String[]{"PID"});
            ss.modifyAttribute(timestamp, (Object)childPid.intValue(), quark);
        }
        quark = ss.getQuarkRelativeAndAdd(childTidNode.intValue(), new String[]{"Exec_name"});
        value = TmfStateValue.newValueString((String)childProcessName);
        ss.modifyAttribute(timestamp, (ITmfStateValue)value, quark);
        value = ProcessStatus.WAIT_CPU.getStateValue();
        ss.modifyAttribute(timestamp, (ITmfStateValue)value, childTidNode.intValue());
        quark = ss.optQuarkRelative(parentTidNode.intValue(), new String[]{"Current_cpu_rq"});
        if (quark != -2) {
            value = ss.queryOngoingState(quark);
            quark = ss.getQuarkRelativeAndAdd(childTidNode.intValue(), new String[]{"Current_cpu_rq"});
            ss.modifyAttribute(timestamp, (ITmfStateValue)value, quark);
        }
        if (!(value = ss.queryOngoingState(quark = ss.getQuarkRelativeAndAdd(parentTidNode.intValue(), new String[]{"System_call"}))).isNull()) {
            quark = ss.getQuarkRelativeAndAdd(childTidNode.intValue(), new String[]{"System_call"});
            ss.modifyAttribute(timestamp, (ITmfStateValue)value, quark);
        }
    }
}

