/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.gef.parts;

import java.beans.PropertyChangeEvent;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gef.requests.SelectionRequest;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.sapphire.ui.diagram.editor.TextPart;
import org.eclipse.sapphire.ui.swt.gef.DiagramConfigurationManager;
import org.eclipse.sapphire.ui.swt.gef.figures.TextFigure;
import org.eclipse.sapphire.ui.swt.gef.internal.DirectEditorManagerFactory;
import org.eclipse.sapphire.ui.swt.gef.model.TextModel;
import org.eclipse.sapphire.ui.swt.gef.parts.NodeCellEditorLocator;
import org.eclipse.sapphire.ui.swt.gef.parts.ShapeEditPart;
import org.eclipse.sapphire.ui.swt.gef.policies.NodeLabelDirectEditPolicy;
import org.eclipse.sapphire.ui.swt.gef.tools.SapphireDragEditPartsTracker;

public class TextEditPart
extends ShapeEditPart {
    public TextEditPart(DiagramConfigurationManager configManager) {
        super(configManager);
    }

    @Override
    protected void createEditPolicies() {
        TextModel textModel = (TextModel)this.getModel();
        TextPart textPart = (TextPart)textModel.getSapphirePart();
        if (textPart.isEditable()) {
            this.installEditPolicy("DirectEditPolicy", (EditPolicy)new NodeLabelDirectEditPolicy());
        }
    }

    protected void refreshVisuals() {
        TextModel textModel = (TextModel)this.getModel();
        TextPart textPart = (TextPart)textModel.getSapphirePart();
        ((TextFigure)this.getFigure()).setText(textPart.getContent());
    }

    public void performRequest(Request request) {
        if (request.getType() == "direct edit") {
            if (!(request instanceof DirectEditRequest)) {
                this.performDirectEdit();
            }
        } else if (request.getType().equals("open") && request instanceof SelectionRequest) {
            this.performDirectEdit();
        } else {
            super.performRequest(request);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String prop = evt.getPropertyName();
        if (prop.equals("SHAPE_START_EDITING")) {
            this.performDirectEdit();
        }
    }

    private void performDirectEdit() {
        TextFigure textFigure;
        TextModel textModel = (TextModel)this.getModel();
        TextPart textPart = (TextPart)textModel.getSapphirePart();
        if (textPart.isEditable() && (textFigure = (TextFigure)this.getFigure()) != null) {
            DirectEditManager manager = DirectEditorManagerFactory.createDirectEditorManager((GraphicalEditPart)this, textPart, new NodeCellEditorLocator(this.getConfigurationManager(), textFigure), textFigure);
            manager.show();
        }
    }

    public DragTracker getDragTracker(Request request) {
        return new SapphireDragEditPartsTracker((EditPart)this);
    }
}

