/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.gef.figures;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutListener;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.RoundedRectangle;
import org.eclipse.draw2d.TextUtilities;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.sapphire.Color;
import org.eclipse.sapphire.ui.Bounds;
import org.eclipse.sapphire.ui.swt.gef.model.DiagramResourceCache;
import org.eclipse.swt.graphics.Image;

public class NodeFigure
extends RoundedRectangle {
    private static final Color DEFAULT_TEXT_FOREGROUND = new Color(51, 51, 153);
    private static final Color DEFAULT_NODE_FOREGROUND = new Color(51, 51, 153);
    private static final Color DEFAULT_BACKGROUND_START = new Color(255, 255, 255);
    private static final Color DEFAULT_BACKGROUND_END = new Color(212, 231, 248);
    private static final Color SELECTED_BACKGROUND = new Color(172, 210, 244);
    private boolean hasImage;
    private DiagramResourceCache resourceCache;
    private Label labelFigure;
    private Label iconFigure;
    private boolean selected;
    private boolean hasFocus;

    public NodeFigure(boolean hasImage, DiagramResourceCache resourceCache) {
        this.hasImage = hasImage;
        this.resourceCache = resourceCache;
        this.setForegroundColor(resourceCache.getColor(DEFAULT_NODE_FOREGROUND));
        this.setLayoutManager((LayoutManager)new XYLayout());
        this.labelFigure = new Label();
        this.labelFigure.setForegroundColor(resourceCache.getColor(DEFAULT_TEXT_FOREGROUND));
        this.labelFigure.setLabelAlignment(2);
        this.labelFigure.setFont(resourceCache.getDefaultFont());
        this.add((IFigure)this.labelFigure);
        if (hasImage) {
            this.iconFigure = new Label();
            this.add((IFigure)this.iconFigure);
        }
        this.addLayoutListener((LayoutListener)new LayoutListener.Stub(){

            public void postLayout(IFigure container) {
                NodeFigure.this.setTooltipText();
            }
        });
    }

    public boolean hasBorder() {
        return !this.hasImage;
    }

    public void refreshConstraints(Bounds labelBounds, Bounds iconBounds) {
        Rectangle labelFigureConstraint = new Rectangle(labelBounds.getX(), labelBounds.getY(), labelBounds.getWidth(), labelBounds.getHeight());
        this.getLayoutManager().setConstraint((IFigure)this.labelFigure, (Object)labelFigureConstraint);
        if (iconBounds != null) {
            Rectangle iconFigureConstraint = new Rectangle(iconBounds.getX(), iconBounds.getY(), iconBounds.getWidth(), iconBounds.getHeight());
            this.getLayoutManager().setConstraint((IFigure)this.iconFigure, (Object)iconFigureConstraint);
        }
    }

    public DiagramResourceCache getDiagramResourceCache() {
        return this.resourceCache;
    }

    public Label getLabelFigure() {
        return this.labelFigure;
    }

    public void setText(String text) {
        this.labelFigure.setText(text);
        this.setTooltipText(text);
    }

    private void setTooltipText() {
        this.setTooltipText(this.labelFigure.getText());
    }

    private void setTooltipText(String text) {
        Dimension d = TextUtilities.INSTANCE.getStringExtents(text, this.labelFigure.getFont());
        if (d.width + 5 >= this.getBounds().width) {
            this.setToolTip((IFigure)new Label(text));
        } else {
            this.setToolTip(null);
        }
    }

    public void setImage(Image image) {
        if (this.iconFigure != null && image != null) {
            this.iconFigure.setIcon(image);
        }
    }

    protected void fillShape(Graphics graphics) {
        if (this.hasImage) {
            return;
        }
        Dimension cornerDimension = new Dimension(1, 1);
        Rectangle fillRectangle = new Rectangle(this.getBounds());
        fillRectangle = fillRectangle.shrink(cornerDimension.width, cornerDimension.height);
        org.eclipse.swt.graphics.Color foregroundSave = graphics.getForegroundColor();
        org.eclipse.swt.graphics.Color backgroundSave = graphics.getBackgroundColor();
        if (this.selected) {
            graphics.setBackgroundColor(this.resourceCache.getColor(SELECTED_BACKGROUND));
            graphics.fillRectangle(fillRectangle);
        } else {
            graphics.setForegroundColor(this.resourceCache.getColor(DEFAULT_BACKGROUND_END));
            graphics.setBackgroundColor(this.resourceCache.getColor(DEFAULT_BACKGROUND_START));
            graphics.fillGradient(fillRectangle.x, fillRectangle.y, fillRectangle.width, fillRectangle.height, true);
        }
        graphics.setForegroundColor(foregroundSave);
        graphics.setBackgroundColor(backgroundSave);
    }

    protected void outlineShape(Graphics graphics) {
        float lineInset = Math.max(1.0f, this.getLineWidthFloat()) / 2.0f;
        int inset1 = (int)Math.floor(lineInset) + 1;
        int inset2 = (int)Math.ceil(lineInset) + 1;
        Rectangle r = Rectangle.SINGLETON.setBounds(this.getBounds());
        r.x += inset1;
        r.y += inset1;
        r.width -= inset1 + inset2;
        r.height -= inset1 + inset2;
        Dimension cornerDimension = new Dimension(8, 8);
        if (!this.hasImage) {
            graphics.drawRoundRectangle(r, Math.max(0, cornerDimension.width - (int)lineInset), Math.max(0, cornerDimension.height - (int)lineInset));
        }
        if (this.hasFocus || this.selected) {
            org.eclipse.swt.graphics.Color foregroundSave = graphics.getForegroundColor();
            graphics.setForegroundColor(this.resourceCache.getOutlineColor());
            Rectangle expanded = r.getExpanded(1, 1);
            graphics.setLineStyle(2);
            graphics.drawRoundRectangle(expanded, Math.max(0, cornerDimension.width - (int)lineInset), Math.max(0, cornerDimension.height - (int)lineInset));
            graphics.setForegroundColor(foregroundSave);
        }
    }

    public void setSelected(boolean b) {
        this.selected = b;
        this.repaint();
    }

    public void setFocus(boolean b) {
        this.hasFocus = b;
        this.repaint();
    }
}

