/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.gef.commands;

import org.eclipse.gef.commands.Command;
import org.eclipse.sapphire.ui.diagram.ConnectionService;
import org.eclipse.sapphire.ui.diagram.DiagramConnectionPart;
import org.eclipse.sapphire.ui.diagram.editor.SapphireDiagramEditorPagePart;
import org.eclipse.sapphire.ui.swt.gef.model.DiagramConnectionModel;
import org.eclipse.sapphire.ui.swt.gef.model.DiagramNodeModel;

public class ReconnectConnectionCommand
extends Command {
    private final DiagramConnectionModel connection;
    private final DiagramNodeModel oldSource;
    private final DiagramNodeModel oldTarget;
    private DiagramNodeModel newSource;
    private DiagramNodeModel newTarget;

    public ReconnectConnectionCommand(DiagramConnectionModel connection) {
        this.setLabel("connection creation");
        this.connection = connection;
        this.oldSource = connection.getSourceNode();
        this.oldTarget = connection.getTargetNode();
    }

    public boolean canExecute() {
        DiagramConnectionPart connectionPart = this.connection.getModelPart();
        if (!connectionPart.removable()) {
            return false;
        }
        if (this.newSource != null) {
            return this.checkSourceReconnection();
        }
        if (this.newTarget != null) {
            return this.checkTargetReconnection();
        }
        return false;
    }

    private boolean checkSourceReconnection() {
        DiagramConnectionPart connectionPart = this.connection.getModelPart();
        ConnectionService connService = (ConnectionService)((SapphireDiagramEditorPagePart)connectionPart.nearest(SapphireDiagramEditorPagePart.class)).service(ConnectionService.class);
        return connService.valid(this.newSource.getModelPart(), this.oldTarget.getModelPart(), connectionPart.getConnectionTypeId());
    }

    private boolean checkTargetReconnection() {
        DiagramConnectionPart connectionPart = this.connection.getModelPart();
        ConnectionService connService = (ConnectionService)((SapphireDiagramEditorPagePart)connectionPart.nearest(SapphireDiagramEditorPagePart.class)).service(ConnectionService.class);
        return connService.valid(this.oldSource.getModelPart(), this.newTarget.getModelPart(), connectionPart.getConnectionTypeId());
    }

    public void execute() {
        if (this.newSource != null && this.newSource == this.oldSource || this.newTarget != null && this.newTarget == this.oldTarget) {
            return;
        }
        DiagramConnectionPart connectionPart = this.connection.getModelPart();
        connectionPart.reconnect(this.newSource != null ? this.newSource.getModelPart() : this.oldSource.getModelPart(), this.newTarget != null ? this.newTarget.getModelPart() : this.oldTarget.getModelPart());
    }

    public void setNewTarget(DiagramNodeModel target) {
        if (target == null) {
            throw new IllegalArgumentException();
        }
        this.newTarget = target;
        this.newSource = null;
    }

    public void setNewSource(DiagramNodeModel source) {
        if (source == null) {
            throw new IllegalArgumentException();
        }
        this.newSource = source;
        this.newTarget = null;
    }
}

