/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.el;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionContext;
import org.eclipse.sapphire.modeling.el.FunctionException;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.modeling.el.internal.FunctionUtils;

public final class ArithmeticNegationFunction
extends Function {
    @Text(value="Cannot apply arithmetic negation operator to {0} type.")
    private static LocalizableText cannotApplyMessage;

    static {
        LocalizableText.init(ArithmeticNegationFunction.class);
    }

    public static ArithmeticNegationFunction create(Function operand) {
        ArithmeticNegationFunction function = new ArithmeticNegationFunction();
        function.init(operand);
        return function;
    }

    @Override
    public String name() {
        return "-";
    }

    @Override
    public boolean operator() {
        return true;
    }

    @Override
    public int precedence() {
        return 2;
    }

    @Override
    public FunctionResult evaluate(FunctionContext context) {
        return new FunctionResult(this, context){

            @Override
            protected Object evaluate() {
                Object a = this.operand(0);
                if (a instanceof Value) {
                    a = ((Value)a).content();
                }
                if (a == null) {
                    return 0L;
                }
                if (a instanceof BigDecimal) {
                    return ((BigDecimal)a).negate();
                }
                if (a instanceof BigInteger) {
                    return ((BigInteger)a).negate();
                }
                if (a instanceof String) {
                    if (FunctionUtils.isDecimalString(a)) {
                        return -this.cast(a, Double.class).doubleValue();
                    }
                    return -this.cast(a, Long.class).longValue();
                }
                if (a instanceof Byte) {
                    return (int)(-((Byte)a).byteValue());
                }
                if (a instanceof Short) {
                    return (int)(-((Short)a).shortValue());
                }
                if (a instanceof Integer) {
                    return -((Integer)a).intValue();
                }
                if (a instanceof Long) {
                    return -((Long)a).longValue();
                }
                if (a instanceof Float) {
                    return Float.valueOf(-((Float)a).floatValue());
                }
                if (a instanceof Double) {
                    return -((Double)a).doubleValue();
                }
                throw new FunctionException(cannotApplyMessage.format(a.getClass().getName()));
            }
        };
    }
}

