/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import org.eclipse.sapphire.Context;
import org.eclipse.sapphire.LoggingService;
import org.eclipse.sapphire.Sapphire;

public abstract class ExtensionsLocator {
    protected static final String DEFAULT_PATH = "META-INF/sapphire-extension.xml";
    private static ExtensionsLocator instance;

    public static final synchronized ExtensionsLocator instance() {
        if (instance == null) {
            final ClassLoader cl = ExtensionsLocator.class.getClassLoader();
            Class<?> implClass = null;
            try {
                implClass = cl.loadClass("org.eclipse.sapphire.modeling.ExtensionsLocatorFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {}
            if (implClass != null) {
                try {
                    Factory factory = (Factory)implClass.newInstance();
                    if (factory.applicable()) {
                        instance = factory.create();
                    }
                }
                catch (Exception e) {
                    Sapphire.service(LoggingService.class).log(e);
                }
            }
            if (instance == null) {
                instance = new ExtensionsLocator(){

                    @Override
                    public List<Handle> find() {
                        ArrayList<Handle> handles = new ArrayList<Handle>();
                        try {
                            Enumeration<URL> urls = cl.getResources(ExtensionsLocator.DEFAULT_PATH);
                            while (urls.hasMoreElements()) {
                                URL url = urls.nextElement();
                                if (url == null) continue;
                                handles.add(new Handle(url, Context.adapt(cl)));
                            }
                        }
                        catch (IOException e) {
                            Sapphire.service(LoggingService.class).log(e);
                        }
                        return Collections.unmodifiableList(handles);
                    }
                };
            }
        }
        return instance;
    }

    public abstract List<Handle> find();

    public static abstract class Factory {
        public abstract boolean applicable();

        public abstract ExtensionsLocator create();
    }

    public static final class Handle {
        private final URL extension;
        private final Context context;

        public Handle(URL extension, Context context) {
            this.extension = extension;
            this.context = context;
        }

        public URL extension() {
            return this.extension;
        }

        public Context context() {
            return this.context;
        }
    }
}

