/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.extensionpoints.editors.ui;

import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.reconciler.AbstractReconciler;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiReconciler
extends AbstractReconciler {
    private final List<IReconcilingStrategy> fStrategies;

    public MultiReconciler(List<IReconcilingStrategy> strategies, boolean isIncremental) {
        Assert.isNotNull(strategies);
        this.fStrategies = strategies;
        for (IReconcilingStrategy strategy : this.fStrategies) {
            if (!(strategy instanceof IReconcilingStrategyExtension)) continue;
            IReconcilingStrategyExtension extension = (IReconcilingStrategyExtension)strategy;
            extension.setProgressMonitor(this.getProgressMonitor());
        }
        this.setIsIncrementalReconciler(isIncremental);
    }

    public IReconcilingStrategy getReconcilingStrategy(String contentType) {
        Assert.isNotNull((Object)contentType);
        return this.fStrategies.get(0);
    }

    protected void process(DirtyRegion dirtyRegion) {
        for (IReconcilingStrategy strategy : this.fStrategies) {
            if (dirtyRegion != null) {
                strategy.reconcile(dirtyRegion, (IRegion)dirtyRegion);
                continue;
            }
            IDocument document = this.getDocument();
            if (document == null) continue;
            strategy.reconcile((IRegion)new Region(0, document.getLength()));
        }
    }

    protected void reconcilerDocumentChanged(IDocument document) {
        for (IReconcilingStrategy strategy : this.fStrategies) {
            strategy.setDocument(document);
        }
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
        super.setProgressMonitor(monitor);
        for (IReconcilingStrategy strategy : this.fStrategies) {
            if (!(strategy instanceof IReconcilingStrategyExtension)) continue;
            IReconcilingStrategyExtension extension = (IReconcilingStrategyExtension)strategy;
            extension.setProgressMonitor(monitor);
        }
    }

    protected void initialProcess() {
        for (IReconcilingStrategy strategy : this.fStrategies) {
            if (!(strategy instanceof IReconcilingStrategyExtension)) continue;
            IReconcilingStrategyExtension extension = (IReconcilingStrategyExtension)strategy;
            extension.initialReconcile();
        }
    }
}

