/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.query.results;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.ResultMetaData;
import org.eclipse.mat.report.ITestResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CompositeResult
implements IResult {
    private List<Entry> entries = new ArrayList<Entry>();
    private boolean asHtml = false;
    private ITestResult.Status status;
    private String name;

    public CompositeResult(IResult ... results) {
        IResult[] iResultArray = results;
        int n = results.length;
        int n2 = 0;
        while (n2 < n) {
            IResult result = iResultArray[n2];
            this.entries.add(new Entry(null, result));
            ++n2;
        }
    }

    @Override
    public ResultMetaData getResultMetaData() {
        return null;
    }

    @Deprecated
    public List<IResult> getResults() {
        ArrayList<IResult> answer = new ArrayList<IResult>(this.entries.size());
        for (Entry entry : this.entries) {
            answer.add(entry.getResult());
        }
        return answer;
    }

    public List<Entry> getResultEntries() {
        return Collections.unmodifiableList(this.entries);
    }

    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    public void addResult(IResult result) {
        this.entries.add(new Entry(null, result));
    }

    public void addResult(String name, IResult result) {
        this.entries.add(new Entry(name, result));
    }

    public ITestResult.Status getStatus() {
        return this.status;
    }

    public void setStatus(ITestResult.Status status) {
        this.status = status;
    }

    public boolean asHtml() {
        return this.asHtml;
    }

    public void setAsHtml(boolean asHtml) {
        this.asHtml = asHtml;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static class Entry {
        String name;
        IResult result;

        private Entry(String name, IResult result) {
            this.name = name;
            this.result = result;
        }

        public String getName() {
            return this.name;
        }

        public IResult getResult() {
            return this.result;
        }
    }
}

