/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.runtime.launch;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.variables.IDynamicVariable;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.emf.common.util.URI;
import org.eclipse.m2m.internal.qvt.oml.common.MdaException;
import org.eclipse.m2m.internal.qvt.oml.common.launch.BaseProcess;
import org.eclipse.m2m.internal.qvt.oml.common.launch.ShallowProcess;
import org.eclipse.m2m.internal.qvt.oml.common.launch.StreamsProxy;
import org.eclipse.m2m.internal.qvt.oml.common.launch.TargetUriData;
import org.eclipse.m2m.internal.qvt.oml.emf.util.EmfUtil;
import org.eclipse.m2m.internal.qvt.oml.emf.util.Logger;
import org.eclipse.m2m.internal.qvt.oml.emf.util.StatusUtil;
import org.eclipse.m2m.internal.qvt.oml.emf.util.URIUtils;
import org.eclipse.m2m.internal.qvt.oml.runtime.launch.Messages;
import org.eclipse.m2m.internal.qvt.oml.runtime.launch.QvtLaunchConfigurationDelegateBase;
import org.eclipse.m2m.internal.qvt.oml.runtime.launch.QvtLaunchUtil;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.QvtInterpretedTransformation;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.QvtModule;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.QvtTransformation;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.TransformationUtil;
import org.eclipse.m2m.internal.qvt.oml.runtime.util.MiscUtil;
import org.eclipse.m2m.qvt.oml.ExecutionContext;
import org.eclipse.m2m.qvt.oml.util.Log;
import org.eclipse.m2m.qvt.oml.util.WriterLog;
import org.eclipse.osgi.util.NLS;

public class QvtBuilderLaunchConfigurationDelegate
extends LaunchConfigurationDelegate {
    public static final String QVTO_BUILDER_MARKER = "org.eclipse.m2m.qvt.oml.runtime.qvtBuilderMarker";
    public static final String BUILD_TYPE_INCREMENTAL = "incremental";
    public static final String BUILD_TYPE_FULL = "full";
    public static final String BUILD_TYPE_AUTO = "auto";
    public static final String BUILD_TYPE_CLEAN = "clean";
    private static final String PLUGIN_ID = "org.eclipse.ui.externaltools";
    public static final String ATTR_RUN_BUILD_KINDS = "org.eclipse.ui.externaltools.ATTR_RUN_BUILD_KINDS";

    public void launch(final ILaunchConfiguration configuration, String mode, ILaunch launch, final IProgressMonitor monitor) throws CoreException {
        try {
            final String buildType = this.getVariableValue("build_type");
            Path path = new Path(this.getVariableValue("build_project"));
            final IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(path.lastSegment());
            StreamsProxy streamsProxy = new StreamsProxy();
            final PrintWriter printWriter = new PrintWriter(streamsProxy.getOutputWriter());
            BaseProcess.IRunnable r = new BaseProcess.IRunnable(){

                public void run() throws Exception {
                    if (QvtBuilderLaunchConfigurationDelegate.BUILD_TYPE_CLEAN.equals(buildType)) {
                        QvtBuilderLaunchConfigurationDelegate.this.clean(project, configuration);
                    } else {
                        QvtBuilderLaunchConfigurationDelegate.this.build(project, configuration, printWriter, monitor);
                    }
                }
            };
            ShallowProcess shallowProcess = new ShallowProcess(launch, r);
            shallowProcess.setStreamsProxy((IStreamsProxy)streamsProxy);
            shallowProcess.run();
        }
        catch (Exception e) {
            throw new CoreException(MiscUtil.makeErrorStatus(StatusUtil.getExceptionMessages((Throwable)e), e));
        }
    }

    private void build(final IProject project, final ILaunchConfiguration configuration, final PrintWriter printWriter, final IProgressMonitor monitor) throws Exception {
        QvtInterpretedTransformation transformation;
        String moduleUri = QvtLaunchUtil.getTransformationURI(configuration);
        try {
            QvtModule qvtModule = TransformationUtil.getQvtModule(EmfUtil.makeUri((String)moduleUri));
            transformation = new QvtInterpretedTransformation(qvtModule);
        }
        catch (MdaException e) {
            this.createMarker(project, NLS.bind((String)Messages.QvtBuilderLaunchTab_TransformationNotFound, (Object)moduleUri));
            return;
        }
        BaseProcess.IRunnable r = new BaseProcess.IRunnable(){

            public void run() throws Exception {
                try {
                    IStatus status = QvtLaunchConfigurationDelegateBase.validate(transformation, configuration);
                    if (status.getSeverity() > 2) {
                        QvtBuilderLaunchConfigurationDelegate.this.createMarker(project, status.getMessage());
                        return;
                    }
                    ExecutionContext context = QvtLaunchUtil.createContext(configuration, (Log)new WriterLog((Writer)printWriter), monitor);
                    QvtLaunchUtil.doLaunch(transformation, configuration, context);
                }
                finally {
                    transformation.cleanup();
                }
            }
        };
        r = QvtLaunchConfigurationDelegateBase.getSafeRunnable(transformation, r);
        r.run();
    }

    private void clean(IProject project, ILaunchConfiguration configuration) throws Exception {
        IFile file;
        URI traceUri;
        QvtInterpretedTransformation transformation;
        String moduleUri = QvtLaunchUtil.getTransformationURI(configuration);
        try {
            transformation = new QvtInterpretedTransformation(TransformationUtil.getQvtModule(EmfUtil.makeUri((String)moduleUri)));
        }
        catch (MdaException e) {
            this.createMarker(project, NLS.bind((String)Messages.QvtBuilderLaunchTab_TransformationNotFound, (Object)moduleUri));
            return;
        }
        List<QvtTransformation.TransformationParameter> transfParams = transformation.getParameters();
        List<TargetUriData> targetUris = QvtLaunchUtil.getTargetUris(configuration);
        int i = 0;
        int n = targetUris.size();
        while (i < n) {
            IFile file2;
            URI outUri;
            if (transfParams.size() > i && transfParams.get(i).getDirectionKind() == QvtTransformation.TransformationParameter.DirectionKind.OUT && (outUri = URI.createURI((String)targetUris.get(i).getUriString())) != null && (file2 = URIUtils.getFile((URI)outUri)) != null) {
                file2.delete(true, true, null);
            }
            ++i;
        }
        String traceFile = QvtLaunchUtil.getTraceFileURI(configuration);
        if (traceFile != null && (traceUri = URI.createPlatformResourceURI((String)traceFile, (boolean)false)) != null && (file = URIUtils.getFile((URI)traceUri)) != null) {
            file.delete(true, true, null);
        }
    }

    private void createMarker(IProject project, String message) {
        if (project == null) {
            return;
        }
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("message", message);
        attributes.put("severity", new Integer(2));
        try {
            IMarker marker = project.createMarker(QVTO_BUILDER_MARKER);
            marker.setAttributes(attributes);
        }
        catch (CoreException e) {
            Logger.getLogger().log(Logger.SEVERE, "Failed to create marker on " + project, e);
        }
    }

    private String getVariableValue(String variableName) throws CoreException {
        IDynamicVariable dynamicVar = VariablesPlugin.getDefault().getStringVariableManager().getDynamicVariable(variableName);
        return dynamicVar.getValue(null);
    }
}

