/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.plugins.viewbpmn;

import org.eclipse.emf.common.ui.EclipseUIPlugin;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jwt.we.IFactoryRegistry;
import org.eclipse.jwt.we.Plugin;
import org.eclipse.jwt.we.editors.palette.IPaletteFactory;
import org.eclipse.jwt.we.figures.IFigureFactory;
import org.eclipse.jwt.we.figures.IImageFactory;
import org.eclipse.jwt.we.figures.StandardFigureFactory;
import org.eclipse.jwt.we.figures.internal.CompositeFigureFactory;
import org.eclipse.jwt.we.figures.internal.CompositeImageFactory;
import org.eclipse.jwt.we.figures.internal.ImageFactory;
import org.eclipse.jwt.we.misc.logging.Logger;
import org.eclipse.jwt.we.parts.CompositeEditPartFactory;
import org.eclipse.jwt.we.parts.JWTEditPartFactory;
import org.eclipse.jwt.we.plugins.viewbpmn.Activator;
import org.eclipse.jwt.we.plugins.viewbpmn.figures.BPMNFigureFactory;
import org.eclipse.jwt.we.plugins.viewbpmn.palette.BPMNPaletteFactory;
import org.eclipse.jwt.we.plugins.viewbpmn.parts.BPMNEditPartFactory;

public class BPMNFactoryRegistry
implements IFactoryRegistry {
    private static final Logger logger = Logger.getLogger(BPMNFactoryRegistry.class);
    private static final String ICONS_BASE_PATH = "icons/";
    protected IImageFactory imageFactory;
    protected IFigureFactory figureFactory;
    protected EditPartFactory editPartFactory;
    protected IPaletteFactory paletteFactory;

    public IImageFactory getImageFactory(Object ... objects) {
        if (this.imageFactory == null) {
            ImageRegistry imageRegistry = Plugin.getInstance().getImageRegistry();
            CompositeImageFactory compositeImageFactory = new CompositeImageFactory();
            this.imageFactory = new ImageFactory(imageRegistry, (EclipseUIPlugin)Activator.getDefault(), ICONS_BASE_PATH);
            compositeImageFactory.addImageFactory(this.imageFactory);
            this.imageFactory = new ImageFactory(imageRegistry, (EclipseUIPlugin)Plugin.getDefault(), ICONS_BASE_PATH);
            compositeImageFactory.addImageFactory(this.imageFactory);
            this.imageFactory = compositeImageFactory;
            return compositeImageFactory;
        }
        return this.imageFactory;
    }

    public IPaletteFactory getPaletteFactory() {
        if (this.paletteFactory == null) {
            this.paletteFactory = new BPMNPaletteFactory();
        }
        return this.paletteFactory;
    }

    public IFigureFactory getFigureFactory() {
        if (this.figureFactory == null) {
            CompositeFigureFactory compositeFigureFactory = new CompositeFigureFactory();
            BPMNFigureFactory figureFactory = new BPMNFigureFactory();
            compositeFigureFactory.addFigureFactory((IFigureFactory)figureFactory);
            figureFactory = new StandardFigureFactory();
            compositeFigureFactory.addFigureFactory((IFigureFactory)figureFactory);
            this.figureFactory = compositeFigureFactory;
        }
        return this.figureFactory;
    }

    public EditPartFactory getEditPartFactory() {
        if (this.editPartFactory == null) {
            CompositeEditPartFactory compositeEditPartFactory = new CompositeEditPartFactory();
            BPMNEditPartFactory editPartFactory = new BPMNEditPartFactory();
            compositeEditPartFactory.addEditPartFactory((EditPartFactory)editPartFactory);
            editPartFactory = new JWTEditPartFactory();
            compositeEditPartFactory.addEditPartFactory((EditPartFactory)editPartFactory);
            this.editPartFactory = compositeEditPartFactory;
        }
        return this.editPartFactory;
    }
}

