/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.meta.commands.processes;

import org.eclipse.emf.common.command.AbstractCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ReconnectEdgeCommand<M, S, T>
extends AbstractCommand {
    private M edge;
    private S oldSource;
    private T oldTarget;
    private S newSource;
    private T newTarget;
    private Object newObject;

    public ReconnectEdgeCommand(String label, M edge) {
        super(label);
        this.edge = edge;
    }

    public ReconnectEdgeCommand(String label, Object newObject, int x) {
        super(label);
        this.newObject = newObject;
    }

    public M getEdge() {
        if (this.edge == null && this.newObject != null) {
            this.edge = this.newObject;
        }
        return this.edge;
    }

    public S getOldSource() {
        return this.oldSource;
    }

    protected void setOldSource(S oldSource) {
        this.oldSource = oldSource;
    }

    public void initSource(S source) {
        this.oldSource = source;
        this.newSource = source;
    }

    public T getOldTarget() {
        return this.oldTarget;
    }

    protected void setOldTarget(T oldTarget) {
        this.oldTarget = oldTarget;
    }

    public void initTarget(T target) {
        this.oldTarget = target;
        this.newTarget = target;
    }

    public S getNewSource() {
        return this.newSource;
    }

    public void setNewSource(S newSource) {
        this.newSource = newSource;
    }

    public T getNewTarget() {
        return this.newTarget;
    }

    public void setNewTarget(T newTarget) {
        this.newTarget = newTarget;
    }

    protected abstract void setSourceEndpoint(M var1, S var2);

    protected abstract void setTargetEndpoint(M var1, T var2);

    public boolean checkSourceConnection() {
        return true;
    }

    public boolean checkTargetConnection() {
        return true;
    }

    public boolean checkConnection() {
        return this.newTarget == null || this.newTarget != this.newSource;
    }

    public boolean canExecute() {
        if (this.edge == null && this.newObject == null) {
            return false;
        }
        if (this.newSource == this.oldSource && this.newTarget == this.oldTarget) {
            return true;
        }
        return this.checkSourceConnection() && this.checkTargetConnection() && this.checkConnection();
    }

    public void execute() {
        if (this.newSource != this.oldSource) {
            this.setSourceEndpoint(this.getEdge(), this.getNewSource());
        }
        if (this.newTarget != this.oldTarget) {
            this.setTargetEndpoint(this.getEdge(), this.getNewTarget());
        }
    }

    public void undo() {
        if (this.newSource != this.oldSource) {
            this.setSourceEndpoint(this.getEdge(), this.getOldSource());
        }
        if (this.newTarget != this.oldTarget) {
            this.setTargetEndpoint(this.getEdge(), this.getOldTarget());
        }
    }
}

