/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.preview.adapter.internal.core;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jst.server.core.IWebModule;
import org.eclipse.jst.server.preview.adapter.internal.IMemento;
import org.eclipse.jst.server.preview.adapter.internal.Messages;
import org.eclipse.jst.server.preview.adapter.internal.ProgressUtil;
import org.eclipse.jst.server.preview.adapter.internal.Trace;
import org.eclipse.jst.server.preview.adapter.internal.XMLMemento;
import org.eclipse.jst.server.preview.adapter.internal.core.PingThread;
import org.eclipse.jst.server.preview.adapter.internal.core.PreviewRuntime;
import org.eclipse.jst.server.preview.adapter.internal.core.PreviewServer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.ServerPort;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.model.IModuleResourceDelta;
import org.eclipse.wst.server.core.model.ServerBehaviourDelegate;
import org.eclipse.wst.server.core.util.IStaticWeb;
import org.eclipse.wst.server.core.util.ProjectModule;
import org.eclipse.wst.server.core.util.PublishUtil;
import org.eclipse.wst.server.core.util.SocketUtil;

public class PreviewServerBehaviour
extends ServerBehaviourDelegate {
    protected transient PingThread ping = null;
    protected transient IDebugEventSetListener processListener;

    public void initialize(IProgressMonitor monitor) {
    }

    public PreviewRuntime getPreviewRuntime() {
        if (this.getServer().getRuntime() == null) {
            return null;
        }
        return (PreviewRuntime)((Object)this.getServer().getRuntime().loadAdapter(PreviewRuntime.class, null));
    }

    public PreviewServer getPreviewServer() {
        return (PreviewServer)((Object)this.getServer().getAdapter(PreviewServer.class));
    }

    public IPath getRuntimeBaseDirectory() {
        return this.getServer().getRuntime().getLocation();
    }

    protected void setupLaunch(ILaunch launch, String launchMode, IProgressMonitor monitor) throws CoreException {
        IModule[] modules;
        ServerPort[] ports = this.getPreviewServer().getServerPorts();
        int port = ports[0].getPort();
        if (SocketUtil.isPortInUse((int)port, (int)5)) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jst.server.preview.adapter", 0, NLS.bind((String)Messages.errorPortInUse, (Object[])new String[]{String.valueOf(port), this.getServer().getName()}), null));
        }
        XMLMemento memento = XMLMemento.createWriteRoot("server");
        memento.putInteger("port", port);
        IModule[] iModuleArray = modules = this.getServer().getModules();
        int n = modules.length;
        int n2 = 0;
        while (n2 < n) {
            IModule module = iModuleArray[n2];
            IMemento mod = memento.createChild("module");
            mod.putString("name", module.getName());
            String type = module.getModuleType().getId();
            if ("wst.web".equals(type)) {
                IStaticWeb staticWeb = (IStaticWeb)module.loadAdapter(IStaticWeb.class, null);
                if (staticWeb != null) {
                    mod.putString("context", staticWeb.getContextRoot());
                }
                mod.putString("type", "static");
            } else if ("jst.web".equals(type)) {
                IWebModule webModule = (IWebModule)module.loadAdapter(IWebModule.class, null);
                if (webModule != null) {
                    mod.putString("context", webModule.getContextRoot());
                }
                mod.putString("type", "j2ee");
            }
            mod.putString("path", this.getModulePublishDirectory(module).toPortableString());
            ++n2;
        }
        try {
            memento.saveToFile(this.getTempDirectory().append("preview.xml").toOSString());
        }
        catch (IOException e) {
            Trace.trace((byte)2, "Could not write preview config", e);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jst.server.preview.adapter", 0, "Could not write preview configuration", null));
        }
        this.setServerRestartState(false);
        this.setServerState(1);
        this.setMode(launchMode);
        try {
            String url = "http://localhost";
            if (port != 80) {
                url = String.valueOf(url) + ":" + port;
            }
            this.ping = new PingThread(this.getServer(), url, this);
        }
        catch (Exception exception) {
            Trace.trace((byte)2, "Can't ping for Tomcat startup.");
        }
    }

    protected void addProcessListener(final IProcess newProcess) {
        if (this.processListener != null || newProcess == null) {
            return;
        }
        this.processListener = new IDebugEventSetListener(){

            public void handleDebugEvents(DebugEvent[] events) {
                if (events != null) {
                    DebugEvent[] debugEventArray = events;
                    int n = events.length;
                    int n2 = 0;
                    while (n2 < n) {
                        DebugEvent event = debugEventArray[n2];
                        if (newProcess != null && newProcess.equals(event.getSource()) && event.getKind() == 8) {
                            PreviewServerBehaviour.this.stop(true);
                        }
                        ++n2;
                    }
                }
            }
        };
        DebugPlugin.getDefault().addDebugEventListener(this.processListener);
    }

    protected void setServerStarted() {
        this.setServerState(2);
    }

    protected void publishServer(int kind, IProgressMonitor monitor) throws CoreException {
        monitor = ProgressUtil.getMonitorFor(monitor);
        monitor.done();
        this.setServerPublishState(1);
    }

    protected void publishModule(int kind, int deltaKind, IModule[] moduleTree, IProgressMonitor monitor) throws CoreException {
        IModule module = moduleTree[moduleTree.length - 1];
        if (this.isSingleRootStructure(module)) {
            this.setModulePublishState(moduleTree, 1);
            return;
        }
        IPath to = this.getModulePublishDirectory(module);
        if (kind == 4 || deltaKind == 3) {
            IStatus[] status = PublishUtil.deleteDirectory((File)to.toFile(), (IProgressMonitor)monitor);
            PreviewServerBehaviour.throwException(status);
        }
        IModuleResource[] res = this.getResources(moduleTree);
        IStatus[] status = PublishUtil.publishSmart((IModuleResource[])res, (IPath)to, (IProgressMonitor)monitor);
        PreviewServerBehaviour.throwException(status);
        this.setModulePublishState(moduleTree, 1);
    }

    private static void throwException(IStatus[] status) throws CoreException {
        if (status == null || status.length == 0) {
            return;
        }
        if (status.length == 1) {
            throw new CoreException(status[0]);
        }
        String message = Messages.errorPublish;
        MultiStatus status2 = new MultiStatus("org.eclipse.jst.server.preview.adapter", 0, status, message, null);
        throw new CoreException((IStatus)status2);
    }

    public void restart(String launchMode) throws CoreException {
        this.setServerState(4);
        this.setServerState(2);
    }

    public void stop(boolean force) {
        int state = this.getServer().getServerState();
        if (state == 4) {
            return;
        }
        this.setServerState(3);
        if (this.ping != null) {
            this.ping.stop();
            this.ping = null;
        }
        if (this.processListener != null) {
            DebugPlugin.getDefault().removeDebugEventListener(this.processListener);
            this.processListener = null;
        }
        try {
            Trace.trace((byte)3, "Killing the process");
            ILaunch launch = this.getServer().getLaunch();
            if (launch != null) {
                launch.terminate();
            }
        }
        catch (Exception e) {
            Trace.trace((byte)2, "Error killing the process", e);
        }
        this.setServerState(4);
    }

    protected IPath getTempDirectory() {
        return super.getTempDirectory();
    }

    protected boolean isSingleRootStructure(IModule module) {
        ProjectModule pm = (ProjectModule)module.loadAdapter(ProjectModule.class, null);
        if (pm == null) {
            return false;
        }
        return pm.isSingleRootStructure();
    }

    protected IPath getModulePublishDirectory(IModule module) {
        if (this.isSingleRootStructure(module)) {
            IContainer[] moduleFolder;
            IWebModule webModule;
            String type = module.getModuleType().getId();
            if ("wst.web".equals(type)) {
                IStaticWeb iStaticWeb = (IStaticWeb)module.loadAdapter(IStaticWeb.class, null);
            } else if ("jst.web".equals(type) && (webModule = (IWebModule)module.loadAdapter(IWebModule.class, null)) != null && (moduleFolder = webModule.getResourceFolders()) != null && moduleFolder.length > 0) {
                return moduleFolder[0].getLocation();
            }
        }
        return this.getTempDirectory().append(module.getName());
    }

    public String toString() {
        return "PreviewServer";
    }

    protected IModuleResourceDelta[] getPublishedResourceDelta(IModule[] module) {
        return super.getPublishedResourceDelta(module);
    }
}

