/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.sirius;

import java.util.Arrays;
import java.util.Collection;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.diffmerge.gmf.GMFScope;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.sirius.diagram.DiagramPackage;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.ViewpointPackage;
import org.eclipse.sirius.viewpoint.description.style.StylePackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SiriusScope
extends GMFScope {
    public static final String SESSION_RESOURCE_FRAGMENT_EXTENSION = "airdfragment";
    public static final Collection<String> SIRIUS_FILE_EXTENSIONS = Arrays.asList("aird", "airdfragment");
    protected static final Collection<? extends EPackage> SIRIUS_PACKAGES = Arrays.asList(ViewpointPackage.eINSTANCE, StylePackage.eINSTANCE, NotationPackage.eINSTANCE, DiagramPackage.eINSTANCE);

    public SiriusScope(URI uri_p, EditingDomain domain, boolean readOnly_p) {
        super(uri_p, domain, readOnly_p);
    }

    public SiriusScope(URI uri_p, ResourceSet resourceSet_p, boolean readOnly_p) {
        super(uri_p, resourceSet_p, readOnly_p);
    }

    protected Collection<EReference> getCrossReferencesInScope(EObject element_p) {
        Collection result = super.getCrossReferencesInScope(element_p);
        if (element_p instanceof DSemanticDecorator) {
            result.add(ViewpointPackage.eINSTANCE.getDSemanticDecorator_Target());
        } else if (element_p instanceof DAnalysis) {
            result.add(ViewpointPackage.eINSTANCE.getDAnalysis_ReferencedAnalysis());
            result.add(ViewpointPackage.eINSTANCE.getDAnalysis_Models());
        }
        return result;
    }

    protected boolean isSiriusElement(EObject element_p) {
        EPackage pack = element_p.eClass().getEPackage();
        return SIRIUS_PACKAGES.contains(pack) || element_p instanceof DRepresentation;
    }

    protected boolean isSiriusResource(Resource resource_p) {
        String extension;
        boolean result = false;
        if (resource_p.getURI() != null && (extension = resource_p.getURI().fileExtension()) != null) {
            extension = extension.toLowerCase();
            result = SIRIUS_FILE_EXTENSIONS.contains(extension);
        }
        return result;
    }

    protected boolean isSuitableFor(Resource resource_p, EObject root_p) {
        boolean result = this.isSiriusResource(resource_p) == this.isSiriusElement(root_p);
        return result;
    }
}

