/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.internal.common.objectdata;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.e4.tools.emf.ui.common.IScriptingSupport;
import org.eclipse.e4.tools.emf.ui.internal.Messages;
import org.eclipse.e4.tools.emf.ui.internal.common.objectdata.JavaAttribute;
import org.eclipse.e4.tools.emf.ui.internal.common.objectdata.JavaObject;
import org.eclipse.e4.tools.services.IResourcePool;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.internal.ModelUtils;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.databinding.IEMFValueProperty;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ObjectViewer {
    public TreeViewer createViewer(Composite parent, EStructuralFeature feature, final IObservableValue master, IResourcePool resourcePool, final Messages messages) {
        final TreeViewer viewer = new TreeViewer(parent);
        viewer.setContentProvider((IContentProvider)new ContentProviderImpl());
        viewer.setLabelProvider((IBaseLabelProvider)new LabelProviderImpl(resourcePool));
        viewer.setComparator((ViewerComparator)new ViewerComparatorImpl());
        IEMFValueProperty property = EMFProperties.value((EStructuralFeature)feature);
        IObservableValue value = property.observeDetail(master);
        value.addValueChangeListener(new IValueChangeListener(){

            public void handleValueChange(ValueChangeEvent event) {
                if (event.diff.getNewValue() != null) {
                    viewer.setInput(Collections.singleton(new JavaObject(event.diff.getNewValue())));
                    viewer.expandToLevel(2);
                } else {
                    viewer.setInput(Collections.emptyList());
                }
            }
        });
        IExtensionRegistry registry = RegistryFactory.getRegistry();
        IExtensionPoint extPoint = registry.getExtensionPoint("org.eclipse.e4.tools.emf.ui.scripting");
        final IConfigurationElement[] elements = extPoint.getConfigurationElements();
        if (elements.length > 0) {
            final MenuManager mgr = new MenuManager();
            mgr.setRemoveAllWhenShown(true);
            mgr.addMenuListener(new IMenuListener(){

                public void menuAboutToShow(IMenuManager manager) {
                    if (viewer.getSelection().isEmpty()) {
                        return;
                    }
                    MenuManager scriptExecute = new MenuManager(messages.ObjectViewer_Script);
                    mgr.add((IContributionItem)scriptExecute);
                    IConfigurationElement[] iConfigurationElementArray = elements;
                    int n = elements.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IConfigurationElement e;
                        final IConfigurationElement le = e = iConfigurationElementArray[n2];
                        scriptExecute.add((IAction)new Action(e.getAttribute("label")){

                            public void run() {
                                try {
                                    IScriptingSupport support = (IScriptingSupport)le.createExecutableExtension("class");
                                    Object o = ((IStructuredSelection)viewer.getSelection()).getFirstElement();
                                    Object mainObject = null;
                                    if (o instanceof JavaObject) {
                                        mainObject = ((JavaObject)o).getInstance();
                                    } else if (o instanceof JavaAttribute) {
                                        mainObject = ((JavaAttribute)o).getFieldValue();
                                    }
                                    if (mainObject != null) {
                                        MApplicationElement value = (MApplicationElement)master.getValue();
                                        support.openEditor(viewer.getControl().getShell(), mainObject, ModelUtils.getContainingContext((MApplicationElement)value));
                                    }
                                }
                                catch (CoreException e) {
                                    e.printStackTrace();
                                }
                            }
                        });
                        ++n2;
                    }
                }
            });
            viewer.getControl().setMenu(mgr.createContextMenu(viewer.getControl()));
        }
        new TooltipSupportImpl((ColumnViewer)viewer, 2, false, resourcePool, messages);
        return viewer;
    }

    class ContentProviderImpl
    implements ITreeContentProvider {
        ContentProviderImpl() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return ((Collection)inputElement).toArray();
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof JavaObject) {
                return ((JavaObject)parentElement).getAttributes().toArray();
            }
            if (parentElement instanceof JavaAttribute) {
                return ((JavaAttribute)parentElement).getAttributes().toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }
    }

    class LabelProviderImpl
    extends StyledCellLabelProvider {
        private final IResourcePool resourcePool;

        public LabelProviderImpl(IResourcePool resourcePool) {
            this.resourcePool = resourcePool;
        }

        public String getToolTipText(Object element) {
            if (element instanceof JavaAttribute && ((JavaAttribute)element).isInjected()) {
                return "Show Tooltip";
            }
            return super.getToolTipText(element);
        }

        public void update(ViewerCell cell) {
            if (cell.getElement() instanceof JavaObject) {
                JavaObject o = (JavaObject)cell.getElement();
                cell.setImage(this.resourcePool.getImageUnchecked("IMG_org.eclipse.e4.tools.emf.ui.obj16.class_obj"));
                cell.setText(o.getName());
            } else if (cell.getElement() instanceof JavaAttribute) {
                JavaAttribute o = (JavaAttribute)cell.getElement();
                StyledString string = new StyledString();
                if (o.isInjected()) {
                    string.append("<injected> ", StyledString.COUNTER_STYLER);
                }
                string.append(o.getName());
                string.append(" : " + o.getType() + " - " + o.getValue(), StyledString.DECORATIONS_STYLER);
                cell.setText(string.getString());
                cell.setStyleRanges(string.getStyleRanges());
                switch (o.getAccessLevel()) {
                    case PUBLIC: {
                        cell.setImage(this.resourcePool.getImageUnchecked("IMG_org.eclipse.e4.tools.emf.ui.obj16.field_public_obj"));
                        break;
                    }
                    case PRIVATE: {
                        cell.setImage(this.resourcePool.getImageUnchecked("IMG_org.eclipse.e4.tools.emf.ui.obj16.field_private_obj"));
                        break;
                    }
                    case DEFAULT: {
                        cell.setImage(this.resourcePool.getImageUnchecked("IMG_org.eclipse.e4.tools.emf.ui.obj16.field_default_obj"));
                        break;
                    }
                    default: {
                        cell.setImage(this.resourcePool.getImageUnchecked("IMG_org.eclipse.e4.tools.emf.ui.obj16.field_protected_obj"));
                    }
                }
            }
            super.update(cell);
        }
    }

    class TooltipSupportImpl
    extends ColumnViewerToolTipSupport {
        private final IResourcePool resourcePool;
        private final Messages messages;

        protected TooltipSupportImpl(ColumnViewer viewer, int style, boolean manualActivation, IResourcePool resourcePool, Messages messages) {
            super(viewer, style, manualActivation);
            this.resourcePool = resourcePool;
            this.messages = messages;
        }

        protected Composite createViewerToolTipContentArea(Event event, ViewerCell cell, Composite parent) {
            JavaAttribute attribute = (JavaAttribute)cell.getElement();
            Composite container = new Composite(parent, 0);
            container.setBackground(container.getDisplay().getSystemColor(1));
            container.setLayout((Layout)new GridLayout(2, false));
            Composite headerContainer = new Composite(container, 0);
            headerContainer.setBackgroundMode(1);
            headerContainer.setData("org.eclipse.e4.ui.css.CssClassName", (Object)"headerSectionContainer");
            GridLayout fl = new GridLayout(2, false);
            fl.marginHeight = 5;
            fl.marginWidth = 5;
            headerContainer.setLayout((Layout)fl);
            headerContainer.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
            Label iconLabel = new Label(headerContainer, 0);
            iconLabel.setImage(this.resourcePool.getImageUnchecked("IMG_org.eclipse.e4.tools.emf.ui.obj16.bullet_go"));
            Label textLabel = new Label(headerContainer, 0);
            textLabel.setText(attribute.getName());
            textLabel.setData("org.eclipse.e4.ui.css.CssClassName", (Object)"sectionHeader");
            Label l = new Label(container, 0);
            l.setText(this.messages.ObjectViewer_Tooltip_Value);
            l = new Label(container, 0);
            l.setText(attribute.getValue());
            l = new Label(container, 0);
            l.setText(this.messages.ObjectViewer_Tooltip_InjectionKey);
            l = new Label(container, 0);
            l.setText(attribute.getContextKey());
            return container;
        }
    }

    class ViewerComparatorImpl
    extends ViewerComparator {
        ViewerComparatorImpl() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof JavaAttribute) {
                if (e2 instanceof JavaAttribute) {
                    JavaAttribute a1 = (JavaAttribute)e1;
                    JavaAttribute a2 = (JavaAttribute)e2;
                    if (a1.isStatic() && !a2.isStatic()) {
                        return -1;
                    }
                    if (!a1.isStatic() && a2.isStatic()) {
                        return 1;
                    }
                    int rv = Integer.valueOf(a1.getAccessLevel().value).compareTo(a2.getAccessLevel().value);
                    if (rv == 0) {
                        return a1.getName().compareTo(a2.getName());
                    }
                    return rv;
                }
                return -1;
            }
            return super.compare(viewer, e1, e2);
        }
    }
}

