/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.common;

import java.text.MessageFormat;
import org.eclipse.e4.tools.emf.ui.common.component.AbstractComponentEditor;
import org.eclipse.e4.tools.emf.ui.internal.Messages;
import org.eclipse.e4.ui.model.application.ui.MUILabel;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.window.ToolTip;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ImageTooltip
extends ToolTip {
    private final Messages Messages;
    private final AbstractComponentEditor editor;

    public ImageTooltip(Control control, Messages Messages2, AbstractComponentEditor editor) {
        super(control);
        this.Messages = Messages2;
        this.editor = editor;
    }

    protected boolean shouldCreateToolTip(Event event) {
        if (this.getImageURI() != null) {
            return super.shouldCreateToolTip(event);
        }
        return false;
    }

    protected Composite createToolTipContentArea(Event event, Composite parent) {
        parent = new Composite(parent, 0);
        parent.setBackground(event.widget.getDisplay().getSystemColor(29));
        parent.setBackgroundMode(1);
        parent.setLayout((Layout)new GridLayout(2, false));
        String imageUri = this.getImageURI();
        Image image = imageUri != null ? this.getImage() : null;
        Label l = new Label(parent, 0);
        l.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont"));
        l.setText(String.valueOf(this.Messages.ImageTooltip_Icon) + ":");
        l = new Label(parent, 0);
        if (image == null && imageUri != null) {
            String errorMessage = MessageFormat.format(this.Messages.ImageTooltip_FileNotFound, imageUri);
            l.setText(errorMessage);
        } else {
            l.setImage(image);
        }
        l = new Label(parent, 0);
        l.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont"));
        l.setText(String.valueOf(this.Messages.ImageTooltip_Name) + ":");
        l = new Label(parent, 0);
        int pos = imageUri.lastIndexOf(47);
        l.setText(imageUri.substring(pos));
        l = new Label(parent, 0);
        l.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont"));
        l.setText(String.valueOf(this.Messages.ImageTooltip_Dimension) + ":");
        l = new Label(parent, 0);
        if (image != null) {
            l.setText(String.valueOf(image.getBounds().width) + "x" + image.getBounds().height + " px");
        } else {
            l.setText("0x0 px");
        }
        return parent;
    }

    protected void afterHideToolTip(Event event) {
        super.afterHideToolTip(event);
    }

    private String getImageURI() {
        MUILabel part = (MUILabel)this.editor.getMaster().getValue();
        return part.getIconURI();
    }

    protected Image getImage() {
        MUILabel part = (MUILabel)this.editor.getMaster().getValue();
        String iconUri = this.getImageURI();
        return iconUri != null ? this.editor.getImageFromIconURI(part) : null;
    }
}

