/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.internal.common.resourcelocator.dialogs;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.tools.emf.ui.internal.common.component.dialogs.BundleImageCache;
import org.eclipse.e4.tools.emf.ui.internal.common.resourcelocator.Messages;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class PickProjectPage
extends WizardPage {
    private TableViewer viewer;
    private BundleImageCache imageCache;
    private Image imgProject;
    private IProject[] projects;
    private final IEclipseContext context;

    protected PickProjectPage(IEclipseContext context) {
        super(Messages.PickProjectPage_SelectReferencedProject);
        this.context = context;
        try {
            this.projects = ((IProject)context.get(IProject.class)).getReferencedProjects();
        }
        catch (CoreException e) {
            this.setErrorMessage(e.getMessage());
            e.printStackTrace();
        }
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        this.imageCache = new BundleImageCache(parent.getDisplay(), ((Object)((Object)this)).getClass().getClassLoader());
        this.getShell().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                PickProjectPage.this.imageCache.dispose();
                PickProjectPage.this.imgProject = null;
            }
        });
        this.imgProject = this.imageCache.create("/icons/full/obj16/projects.png");
        Composite comp = new Composite(parent, 0);
        comp.setLayoutData((Object)new GridData(4, 4, true, true));
        comp.setLayout((Layout)new GridLayout(1, false));
        this.viewer = new TableViewer(comp, 68352);
        this.viewer.getTable().setLayoutData((Object)new GridData(1808));
        this.viewer.setLabelProvider((IBaseLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                IProject project = (IProject)element;
                return project.getName();
            }

            public Image getImage(Object element) {
                return PickProjectPage.this.imgProject;
            }
        });
        this.viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.viewer.setInput((Object)this.projects);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object firstElement = ((StructuredSelection)event.getSelection()).getFirstElement();
                PickProjectPage.this.context.set("projectToCopyTo", firstElement);
                PickProjectPage.this.setPageComplete(firstElement != null);
                PickProjectPage.this.getContainer().updateButtons();
            }
        });
        String message = Messages.ReferencedProjectPickerDialog_selectReferencedProject;
        this.setMessage(message);
        this.getShell().setText(message);
        this.setTitle(message);
        Image image = ((BundleImageCache)this.context.get(BundleImageCache.class)).create("/icons/full/obj16/projects.png");
        this.setImageDescriptor(ImageDescriptor.createFromImage((Image)image));
        this.setControl((Control)comp);
    }

    public void setVisible(boolean visible) {
        Object object = this.context.get("projectToCopyTo");
        if (visible) {
            if (object != null) {
                this.viewer.setSelection((ISelection)new StructuredSelection(object));
            } else {
                this.viewer.setSelection((ISelection)new StructuredSelection());
            }
        }
        this.setPageComplete(!this.viewer.getSelection().isEmpty());
        super.setVisible(visible);
    }
}

