/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.internal.common.component;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.list.IListProperty;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.emf.xpath.EcoreXPathContextFactory;
import org.eclipse.e4.emf.xpath.XPathContext;
import org.eclipse.e4.emf.xpath.XPathContextFactory;
import org.eclipse.e4.tools.emf.ui.common.IEditorFeature;
import org.eclipse.e4.tools.emf.ui.common.Util;
import org.eclipse.e4.tools.emf.ui.common.component.AbstractComponentEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.E4PickList;
import org.eclipse.e4.tools.emf.ui.internal.common.component.ControlFactory;
import org.eclipse.e4.tools.emf.ui.internal.common.component.dialogs.FeatureSelectionDialog;
import org.eclipse.e4.tools.emf.ui.internal.common.component.dialogs.FindParentReferenceElementDialog;
import org.eclipse.e4.tools.emf.ui.internal.common.component.tabs.empty.E;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.impl.ApplicationElementImpl;
import org.eclipse.e4.ui.model.application.impl.ApplicationPackageImpl;
import org.eclipse.e4.ui.model.fragment.MStringModelFragment;
import org.eclipse.e4.ui.model.fragment.impl.FragmentPackageImpl;
import org.eclipse.e4.ui.model.fragment.impl.StringModelFragmentImpl;
import org.eclipse.e4.ui.model.internal.ModelUtils;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.databinding.EMFDataBindingContext;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.databinding.IEMFListProperty;
import org.eclipse.emf.databinding.edit.EMFEditProperties;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.ParseException;
import org.eclipse.jface.databinding.swt.IWidgetValueProperty;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.fieldassist.ContentProposal;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class StringModelFragment
extends AbstractComponentEditor {
    private Composite composite;
    private EMFDataBindingContext context;
    private EClass selectedContainer;
    private final IListProperty MODEL_FRAGMENT__ELEMENTS = EMFProperties.list((EStructuralFeature)FragmentPackageImpl.Literals.MODEL_FRAGMENT__ELEMENTS);
    private final List<Action> actions = new ArrayList<Action>();
    @Inject
    IEclipseContext eclipseContext;
    private E4PickList pickList;

    @Inject
    public StringModelFragment() {
    }

    @PostConstruct
    public void init() {
    }

    @Override
    public Image getImage(Object element) {
        return this.getImage(element, "IMG_org.eclipse.e4.tools.emf.ui.modelelements.StringModelFragment");
    }

    @Override
    public String getLabel(Object element) {
        if (this.selectedContainer == null) {
            return this.Messages.StringModelFragment_Label;
        }
        return String.valueOf(this.Messages.StringModelFragment_LabelFor) + this.selectedContainer.getName();
    }

    @Override
    public FeaturePath[] getLabelProperties() {
        return new FeaturePath[]{FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{FragmentPackageImpl.Literals.STRING_MODEL_FRAGMENT__FEATURENAME}), FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{FragmentPackageImpl.Literals.STRING_MODEL_FRAGMENT__PARENT_ELEMENT_ID})};
    }

    @Override
    public String getDetailLabel(Object element) {
        if (element instanceof StringModelFragmentImpl) {
            StringModelFragmentImpl fragment = (StringModelFragmentImpl)element;
            String ret = "";
            if (E.notEmpty(fragment.getFeaturename())) {
                ret = String.valueOf(ret) + fragment.getFeaturename();
            }
            if (E.notEmpty(fragment.getParentElementId())) {
                ret = String.valueOf(ret) + " (" + fragment.getParentElementId() + ")";
            }
            return ret;
        }
        return null;
    }

    @Override
    public String getDescription(Object element) {
        return this.Messages.StringModelFragment_Description;
    }

    @Override
    public Composite doGetEditor(Composite parent, Object object) {
        if (this.composite == null) {
            this.context = new EMFDataBindingContext();
            this.composite = this.createForm(parent);
        }
        this.selectedContainer = null;
        this.getMaster().setValue(object);
        this.updateChildrenChoice();
        this.getEditor().setHeaderTitle(this.getLabel(null));
        return this.composite;
    }

    private EClass getSelectedContainer() {
        if (this.selectedContainer != null) {
            return this.selectedContainer;
        }
        StringModelFragmentImpl modelFragment = this.getStringModelFragment();
        if (modelFragment == null) {
            return null;
        }
        String parentElementId = modelFragment.getParentElementId();
        if (parentElementId == null || parentElementId.isEmpty()) {
            return null;
        }
        if ("xpath:/".equals(parentElementId) || "org.eclipse.e4.legacy.ide.application".equals(parentElementId)) {
            this.selectedContainer = ApplicationPackageImpl.eINSTANCE.getApplication();
            return this.selectedContainer;
        }
        ResourceSet resourceSet = Util.getModelElementResources();
        String xpath = parentElementId.startsWith("xpath:") ? parentElementId.substring(6) : null;
        for (Resource res : resourceSet.getResources()) {
            TreeIterator it = EcoreUtil.getAllContents((Resource)res, (boolean)true);
            while (it.hasNext()) {
                EObject o = (EObject)it.next();
                if (xpath != null) {
                    EClass found;
                    if (!(o instanceof MApplication) || (found = this.getTargetClassFromXPath((MApplication)o, xpath)) == null) continue;
                    this.selectedContainer = found;
                    return this.selectedContainer;
                }
                if (!(o instanceof MApplicationElement) || o.eContainingFeature() == FragmentPackageImpl.Literals.MODEL_FRAGMENTS__IMPORTS || !parentElementId.equals(((MApplicationElement)o).getElementId())) continue;
                this.selectedContainer = o.eClass();
                return this.selectedContainer;
            }
        }
        this.updateTitle();
        return this.selectedContainer;
    }

    private void updateTitle() {
        this.getEditor().setHeaderTitle(this.getLabel(null));
    }

    private StringModelFragmentImpl getStringModelFragment() {
        return (StringModelFragmentImpl)this.getMaster().getValue();
    }

    private Composite createForm(Composite parent) {
        CTabFolder folder = new CTabFolder(parent, 1024);
        CTabItem item = new CTabItem(folder, 0);
        item.setText(this.Messages.ModelTooling_Common_TabDefault);
        parent = this.createScrollableContainer((Composite)folder);
        item.setControl((Control)parent.getParent());
        if (this.getEditor().isShowXMIId() || this.getEditor().isLiveModel()) {
            ControlFactory.createXMIId(parent, this);
        }
        IWidgetValueProperty textProp = WidgetProperties.text((int)24);
        Label l = new Label(parent, 0);
        l.setText(this.Messages.StringModelFragment_ParentId);
        l.setToolTipText(this.Messages.StringModelFragment_ParentIdTooltip);
        l.setLayoutData((Object)new GridData(128));
        Composite comp = new Composite(parent, 0);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        comp.setLayoutData((Object)gd);
        GridLayout gl = new GridLayout(2, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.verticalSpacing = 0;
        gl.marginTop = 0;
        gl.marginRight = 0;
        gl.marginBottom = 0;
        gl.marginLeft = 0;
        comp.setLayout((Layout)gl);
        Text t = new Text(comp, 2048);
        ControlFactory.TextPasteHandler.createFor(t);
        gd = new GridData(768);
        t.setLayoutData((Object)gd);
        this.context.bindValue((IObservableValue)textProp.observeDelayed(200, (Widget)t), EMFEditProperties.value((EditingDomain)this.getEditingDomain(), (EStructuralFeature)FragmentPackageImpl.Literals.STRING_MODEL_FRAGMENT__PARENT_ELEMENT_ID).observeDetail((IObservableValue)this.getMaster()));
        t.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                StringModelFragment.this.selectedContainer = null;
            }
        });
        final Button b = new Button(comp, 0x800008);
        b.setText(this.Messages.ModelTooling_Common_FindEllipsis);
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FindParentReferenceElementDialog dialog = new FindParentReferenceElementDialog(b.getShell(), StringModelFragment.this, (MStringModelFragment)StringModelFragment.this.getMaster().getValue(), StringModelFragment.this.Messages, StringModelFragment.this.getSelectedContainer());
                dialog.open();
                StringModelFragment.this.selectedContainer = dialog.getSelectedContainer();
                StringModelFragment.this.updateTitle();
            }
        });
        l = new Label(parent, 0);
        l.setText(this.Messages.StringModelFragment_Featurename);
        l.setToolTipText(this.Messages.StringModelFragment_FeaturenameTooltip);
        l.setLayoutData((Object)new GridData(128));
        comp = new Composite(parent, 0);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        comp.setLayoutData((Object)gd);
        gl = new GridLayout(2, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.verticalSpacing = 0;
        gl.marginTop = 0;
        gl.marginRight = 0;
        gl.marginBottom = 0;
        gl.marginLeft = 0;
        comp.setLayout((Layout)gl);
        t = new Text(comp, 2048);
        ControlFactory.TextPasteHandler.createFor(t);
        gd = new GridData(768);
        t.setLayoutData((Object)gd);
        this.context.bindValue((IObservableValue)textProp.observeDelayed(200, (Widget)t), EMFEditProperties.value((EditingDomain)this.getEditingDomain(), (EStructuralFeature)FragmentPackageImpl.Literals.STRING_MODEL_FRAGMENT__FEATURENAME).observeDetail((IObservableValue)this.getMaster()));
        final ControlDecoration deco = new ControlDecoration((Control)t, 16512);
        Image image = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_INFORMATION").getImage();
        deco.setDescriptionText(this.Messages.StringModelFragment_Ctrl_Space);
        deco.setImage(image);
        deco.setShowOnlyOnFocus(false);
        t.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Text text = (Text)e.getSource();
                if (!text.getText().isEmpty()) {
                    deco.hide();
                } else {
                    deco.show();
                }
            }
        });
        try {
            KeyStroke keyStroke = KeyStroke.getInstance((String)"Ctrl+Space");
            ContentProposalAdapter adapter = new ContentProposalAdapter((Control)t, (IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)new StringModelFragmentProposalProvider(this, t), keyStroke, null);
            adapter.setProposalAcceptanceStyle(2);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        t.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                StringModelFragment.this.updateChildrenChoice();
            }
        });
        final Button button = new Button(comp, 0x800008);
        button.setText(this.Messages.ModelTooling_Common_FindEllipsis);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FeatureSelectionDialog dialog = new FeatureSelectionDialog(button.getShell(), StringModelFragment.this.getEditingDomain(), (MStringModelFragment)StringModelFragment.this.getMaster().getValue(), StringModelFragment.this.Messages, StringModelFragment.this.getSelectedContainer());
                dialog.open();
            }
        });
        ControlFactory.createTextField(parent, this.Messages.StringModelFragment_PositionInList, (IObservableValue)this.getMaster(), this.context, textProp, EMFEditProperties.value((EditingDomain)this.getEditingDomain(), (EStructuralFeature)FragmentPackageImpl.Literals.STRING_MODEL_FRAGMENT__POSITION_IN_LIST));
        this.pickList = new E4PickList(parent, 0, null, this.Messages, this, (EStructuralFeature)FragmentPackageImpl.Literals.MODEL_FRAGMENT__ELEMENTS){

            @Override
            protected void addPressed() {
                EClass eClass = ((IEditorFeature.FeatureClass)((IStructuredSelection)this.getSelection()).getFirstElement()).eClass;
                StringModelFragment.this.handleAdd(eClass, false);
            }

            @Override
            protected List<?> getContainerChildren(Object master) {
                return ((StringModelFragmentImpl)master).getElements();
            }
        };
        this.pickList.setLayoutData(new GridData(4, 4, true, true, 3, 1));
        this.pickList.setText("");
        this.pickList.setLabelProvider((ILabelProvider)new LabelProvider(){

            public String getText(Object element) {
                IEditorFeature.FeatureClass eclass = (IEditorFeature.FeatureClass)element;
                return eclass.label;
            }
        });
        this.pickList.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                IEditorFeature.FeatureClass eClass1 = (IEditorFeature.FeatureClass)e1;
                IEditorFeature.FeatureClass eClass2 = (IEditorFeature.FeatureClass)e2;
                return eClass1.label.compareTo(eClass2.label);
            }
        });
        this.createContributedEditorTabs(folder, this.context, this.getMaster(), MStringModelFragment.class);
        folder.setSelection(0);
        this.updateChildrenChoice();
        return folder;
    }

    public void dispose() {
        if (this.composite != null) {
            this.composite.dispose();
            this.composite = null;
        }
        if (this.context != null) {
            this.context.dispose();
            this.context = null;
        }
    }

    private void updateChildrenChoice() {
        this.selectedContainer = this.getSelectedContainer();
        List<IEditorFeature.FeatureClass> list = this.getTargetChildrenClasses();
        this.pickList.setInput(list);
        if (list.size() > 0) {
            this.pickList.setSelection((ISelection)new StructuredSelection((Object)list.get(0)));
        }
        IEMFListProperty prop = EMFProperties.list((EStructuralFeature)FragmentPackageImpl.Literals.MODEL_FRAGMENT__ELEMENTS);
        this.pickList.getList().setInput((Object)prop.observeDetail((IObservableValue)this.getMaster()));
        this.actions.clear();
        for (final IEditorFeature.FeatureClass featureClass : list) {
            this.actions.add(new Action(featureClass.label){

                public void run() {
                    StringModelFragment.this.handleAdd(featureClass.eClass, false);
                }
            });
        }
    }

    @Override
    public IObservableList getChildList(Object element) {
        return this.MODEL_FRAGMENT__ELEMENTS.observe(element);
    }

    protected void handleAdd(EClass eClass, boolean separator) {
        EObject eObject = EcoreUtil.create((EClass)eClass);
        this.setElementId(eObject);
        Command cmd = AddCommand.create((EditingDomain)this.getEditingDomain(), (Object)this.getMaster().getValue(), (Object)FragmentPackageImpl.Literals.MODEL_FRAGMENT__ELEMENTS, (Object)eObject);
        if (cmd.canExecute()) {
            this.getEditingDomain().getCommandStack().execute(cmd);
            this.getEditor().setSelection(eObject);
        }
    }

    @Override
    public List<Action> getActions(Object element) {
        ArrayList<Action> l = new ArrayList<Action>(super.getActions(element));
        l.addAll(this.actions);
        Collections.sort(l, new Comparator<Action>(){

            @Override
            public int compare(Action o1, Action o2) {
                return o1.getText().compareTo(o2.getText());
            }
        });
        return l;
    }

    private EClass getTargetClassFromXPath(MApplication application, String xpath) {
        XPathContextFactory f = EcoreXPathContextFactory.newInstance();
        XPathContext xpathContext = f.newContext((Object)((EObject)application));
        Iterator i = xpathContext.iterate(xpath);
        try {
            while (i.hasNext()) {
                Object obj = i.next();
                if (!(obj instanceof MApplicationElement)) continue;
                ApplicationElementImpl ae = (ApplicationElementImpl)obj;
                return ae.eClass();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public List<IEditorFeature.FeatureClass> getTargetChildrenClasses() {
        List<IEditorFeature.FeatureClass> result = Collections.emptyList();
        if (this.selectedContainer != null) {
            EReference childRef = null;
            String featurename = this.getStringModelFragment().getFeaturename();
            for (EReference ref : this.selectedContainer.getEAllReferences()) {
                if (!ref.getName().equals(featurename)) continue;
                childRef = ref;
                break;
            }
            if (childRef == null) {
                return result;
            }
            EClass childClass = (EClass)ModelUtils.getTypeArgument((EClass)this.selectedContainer, (EGenericType)childRef.getEGenericType());
            result = new ArrayList<IEditorFeature.FeatureClass>();
            for (Util.InternalPackage p : Util.loadPackages()) {
                for (EClass c : p.getAllClasses()) {
                    if (!childClass.isSuperTypeOf(c)) continue;
                    result.add(new IEditorFeature.FeatureClass(c.getName(), c));
                }
            }
        }
        return result;
    }

    static class StringModelFragmentProposalProvider
    implements IContentProposalProvider {
        private StringModelFragment fragment;
        private Text text;

        public StringModelFragmentProposalProvider(StringModelFragment fragment, Text t) {
            this.fragment = fragment;
            this.text = t;
        }

        public IContentProposal[] getProposals(String cont, int position) {
            ArrayList<String[]> contents = new ArrayList<String[]>();
            StringBuilder sb = new StringBuilder(256);
            if (this.fragment.getSelectedContainer() != null) {
                for (EReference r : this.fragment.getSelectedContainer().getEAllReferences()) {
                    if (!Util.referenceIsModelFragmentCompliant(r) || !r.getName().startsWith(this.text.getText())) continue;
                    String content = r.getName();
                    sb.setLength(0);
                    sb.append(content).append(": ");
                    EClassifier type = ModelUtils.getTypeArgument((EClass)this.fragment.getSelectedContainer(), (EGenericType)r.getEGenericType());
                    if (r.isMany()) {
                        sb.append("List<").append(type.getName()).append(">");
                    } else {
                        sb.append(type.getName());
                    }
                    contents.add(new String[]{content, sb.toString()});
                }
            }
            Collections.sort(contents, new Comparator<String[]>(){

                @Override
                public int compare(String[] o1, String[] o2) {
                    return o1[0].compareTo(o2[0]);
                }
            });
            IContentProposal[] contentProposals = new IContentProposal[contents.size()];
            int i = 0;
            while (i < contents.size()) {
                contentProposals[i] = new ContentProposal(((String[])contents.get(i))[0], ((String[])contents.get(i))[1], null);
                ++i;
            }
            return contentProposals;
        }
    }
}

