/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal.wizards;

import java.util.List;
import org.eclipse.cft.server.core.CFServiceInstance;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.ui.internal.Messages;
import org.eclipse.cft.server.ui.internal.wizards.CloudFoundryServiceWizardPage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.statushandlers.StatusManager;

public class CloudFoundryServiceWizard
extends Wizard {
    private WizardDialog parent;
    private final CloudFoundryServer cloudServer;
    private CloudFoundryServiceWizardPage page;
    private List<CFServiceInstance> resultServices = null;
    private final boolean deferServiceAddition;

    public CloudFoundryServiceWizard(CloudFoundryServer cloudServer) {
        this(cloudServer, false);
    }

    public CloudFoundryServiceWizard(CloudFoundryServer cloudServer, boolean deferServiceAddition) {
        this.cloudServer = cloudServer;
        this.setWindowTitle(Messages.COMMONTXT_ADD_SERVICE);
        this.setNeedsProgressMonitor(true);
        this.deferServiceAddition = deferServiceAddition;
    }

    public void addPages() {
        this.page = new CloudFoundryServiceWizardPage(this.cloudServer, this);
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        List<CFServiceInstance> localServices = this.page.getServices();
        if (!this.deferServiceAddition && localServices != null) {
            ServiceCreationJob job = new ServiceCreationJob(localServices, this.cloudServer);
            job.setUser(true);
            job.setPriority(20);
            job.schedule();
        }
        return true;
    }

    public List<CFServiceInstance> getServices() {
        if (this.resultServices != null) {
            return this.resultServices;
        }
        return this.page != null ? this.page.getServices() : null;
    }

    public void setParent(WizardDialog parent) {
        this.parent = parent;
    }

    protected WizardDialog getParent() {
        return this.parent;
    }

    private static class ServiceCreationJob
    extends Job {
        final CloudFoundryServer cloudServer;
        final List<CFServiceInstance> servicesToCreate;

        public ServiceCreationJob(List<CFServiceInstance> servicesToCreate, CloudFoundryServer cloudServer) {
            super(Messages.CloudFoundryServiceWizard_JOB_TASK_CREATING_SERVICES);
            this.servicesToCreate = servicesToCreate;
            this.cloudServer = cloudServer;
        }

        protected IStatus run(IProgressMonitor monitorParam) {
            SubMonitor monitor = SubMonitor.convert((IProgressMonitor)monitorParam, (int)(this.servicesToCreate.size() * 100 + 100));
            Status status = null;
            try {
                for (CFServiceInstance cs : this.servicesToCreate) {
                    this.cloudServer.getBehaviour().operations().createServices(new CFServiceInstance[]{cs}).run((IProgressMonitor)monitor.newChild(100));
                }
                monitor.subTask(Messages.CloudFoundryServiceWizard_JOB_SUBTASK_VERIFYING_SERVICES);
                List allServices = this.cloudServer.getBehaviour().getServices((IProgressMonitor)monitor.newChild(100));
                if (allServices != null) {
                    for (CFServiceInstance localService : this.servicesToCreate) {
                        boolean matchFound = false;
                        for (CFServiceInstance existingService : allServices) {
                            if (!existingService.getName().equals(localService.getName())) continue;
                            allServices.add(existingService);
                            matchFound = true;
                            break;
                        }
                        if (matchFound) continue;
                        status = new Status(4, "org.eclipse.cft.server.core", NLS.bind((String)Messages.CloudFoundryServiceWizard_ERROR_ADD_SERVICE, (Object)this.cloudServer.getServer().getName(), (Object)localService.getName()));
                        break;
                    }
                    monitor.worked(100);
                }
            }
            catch (CoreException e) {
                status = new Status(4, "org.eclipse.cft.server.core", NLS.bind((String)Messages.CloudFoundryServiceWizard_ERROR_ADD_SERVICE, (Object)this.cloudServer.getServer().getName(), (Object)(e.getCause() != null && e.getCause().getMessage() != null ? e.getCause().getMessage() : e.toString())), (Throwable)e);
            }
            monitor.done();
            if (status != null && !status.isOK()) {
                Status statusToDisplay = status;
                Display.getDefault().asyncExec(new Runnable((IStatus)statusToDisplay){
                    private final /* synthetic */ IStatus val$statusToDisplay;
                    {
                        this.val$statusToDisplay = iStatus;
                    }

                    @Override
                    public void run() {
                        StatusManager.getManager().handle(this.val$statusToDisplay, 7);
                    }
                });
                return Status.CANCEL_STATUS;
            }
            return Status.OK_STATUS;
        }
    }
}

