/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal.actions;

import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.core.internal.client.CloudFoundryApplicationModule;
import org.eclipse.cft.server.ui.internal.Messages;
import org.eclipse.cft.server.ui.internal.actions.UnmapProjectOperation;
import org.eclipse.cft.server.ui.internal.editor.CloudFoundryApplicationsEditorPage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IModule;

public class UnmapProjectEditorAction
extends Action {
    private final CloudFoundryApplicationsEditorPage editorPage;
    private final IModule module;

    public UnmapProjectEditorAction(CloudFoundryApplicationsEditorPage editorPage, IModule module) {
        this.setText(Messages.UnmapProjectEditorAction_ACTION_LABEL);
        this.editorPage = editorPage;
        this.module = module;
    }

    public void run() {
        CloudFoundryServer cloudServer = this.editorPage.getCloudServer();
        final CloudFoundryApplicationModule appModule = cloudServer.getExistingCloudModule(this.module);
        if (appModule != null && this.editorPage.getSite() != null && this.editorPage.getSite().getShell() != null) {
            Job job = new Job(NLS.bind((String)Messages.REMOVE_PROJECT_MAPPING, (Object)appModule.getDeployedApplicationName())){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        new UnmapProjectOperation(appModule, UnmapProjectEditorAction.this.editorPage.getCloudServer()).run(monitor);
                    }
                    catch (CoreException e) {
                        CloudFoundryPlugin.logError((Throwable)e);
                        return Status.CANCEL_STATUS;
                    }
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }
    }
}

