/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal;

import java.io.File;
import java.util.Arrays;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.ui.internal.Messages;
import org.eclipse.cft.server.ui.internal.ServerDescriptor;
import org.eclipse.cft.server.ui.internal.ServerHandlerCallback;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerListener;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerEvent;
import org.eclipse.wst.server.core.ServerPort;
import org.eclipse.wst.server.core.ServerUtil;

public class ServerHandler {
    public static final IOverwriteQuery ALWAYS_OVERWRITE = new IOverwriteQuery(){

        public String queryOverwrite(String arg0) {
            return "YES";
        }
    };
    public static final IOverwriteQuery NEVER_OVERWRITE = new IOverwriteQuery(){

        public String queryOverwrite(String arg0) {
            return "NO";
        }
    };
    private final String serverType;
    private String runtimeName;
    private String serverName;
    private String serverPath;
    private String verifyPath;
    private boolean forceCreateRuntime;

    public ServerHandler(ServerDescriptor descriptor) {
        this(descriptor, null);
    }

    public ServerHandler(ServerDescriptor descriptor, File path) {
        this(descriptor.getServerTypeId());
        this.setRuntimeName(descriptor.getRuntimeName());
        this.setServerName(descriptor.getServerName());
        this.setForceCreateRuntime(descriptor.getForceCreateRuntime());
        if (path != null) {
            this.setServerPath(path.getAbsolutePath());
        }
    }

    public ServerHandler(String serverType) {
        this.serverType = serverType;
        this.verifyPath = "conf";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IServer getExistingServer() {
        NullProgressMonitor monitor = new NullProgressMonitor();
        try {
            IRuntime runtime;
            IServerType st = ServerCore.findServerType((String)this.serverType);
            if (st == null) {
                return null;
            }
            if (this.serverPath != null || this.forceCreateRuntime) {
                runtime = ServerCore.findRuntime((String)this.runtimeName);
                if (runtime == null) {
                    return null;
                }
            } else {
                runtime = this.findRuntime(st, (IProgressMonitor)monitor);
            }
            if (this.serverName != null) {
                return ServerCore.findServer((String)this.serverName);
            }
            return this.findServer(st, runtime, (IProgressMonitor)monitor);
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public IServer createServer(IProgressMonitor monitor, IOverwriteQuery query) throws CoreException {
        return this.createServer(monitor, query, null);
    }

    public IServer createServer(IProgressMonitor monitor, IOverwriteQuery query, ServerHandlerCallback callback) throws CoreException {
        try {
            monitor.beginTask("Creating server configuration", 4);
            IServerType st = ServerCore.findServerType((String)this.serverType);
            if (st == null) {
                throw new CoreException(CloudFoundryPlugin.getErrorStatus((String)("Could not find server type \"" + this.serverType + "\"")));
            }
            IRuntime runtime = this.serverPath != null ? this.createRuntime(st, (IPath)new Path(this.serverPath), monitor, query) : (this.forceCreateRuntime ? this.createRuntime(st, null, monitor, query) : this.findRuntime(st, monitor));
            if (this.serverName != null) {
                IServer iServer = this.createServer(st, runtime, monitor, query, callback);
                return iServer;
            }
            IServer iServer = this.findServer(st, runtime, monitor);
            return iServer;
        }
        finally {
            monitor.done();
        }
    }

    public void deleteServerAndRuntime(IProgressMonitor monitor) throws CoreException {
        try {
            IRuntime runtime;
            monitor.beginTask("Deleting server configuration", 4);
            IServer server = ServerCore.findServer((String)this.serverName);
            if (server != null) {
                IFolder serverConfiguration = server.getServerConfiguration();
                server.delete();
                if (serverConfiguration != null) {
                    serverConfiguration.delete(true, true, monitor);
                }
            }
            if ((runtime = ServerCore.findRuntime((String)this.runtimeName)) != null) {
                runtime.delete();
            }
        }
        finally {
            monitor.done();
        }
    }

    public int getHttpPort(IServer server, IProgressMonitor monitor) {
        ServerPort[] ports = server.getServerPorts(monitor);
        if (ports != null) {
            ServerPort[] serverPortArray = ports;
            int n = ports.length;
            int n2 = 0;
            while (n2 < n) {
                ServerPort serverPort = serverPortArray[n2];
                if ("http".equals(serverPort.getProtocol())) {
                    return serverPort.getPort();
                }
                ++n2;
            }
        }
        return -1;
    }

    public String getRuntimeName() {
        return this.runtimeName;
    }

    public String getVerifyPath() {
        return this.verifyPath;
    }

    public IServer launch(IProject project, IProgressMonitor monitor) throws CoreException {
        try {
            monitor.beginTask("Launching " + project.getName(), -1);
            IServer server = this.createServer((IProgressMonitor)new SubProgressMonitor(monitor, 1), NEVER_OVERWRITE);
            IServerWorkingCopy wc = server.createWorkingCopy();
            IModule[] modules = ServerUtil.getModules((IProject)project);
            if (modules == null || modules.length == 0) {
                throw new CoreException(CloudFoundryPlugin.getErrorStatus((String)("Sample project does not contain web modules: " + project)));
            }
            if (!Arrays.asList(wc.getModules()).contains(modules[0])) {
                wc.modifyModules(modules, new IModule[0], monitor);
                server = wc.save(true, monitor);
            }
            server.publish(1, monitor);
            this.restartServer(server, monitor);
            IServer iServer = server;
            return iServer;
        }
        finally {
            monitor.done();
        }
    }

    protected void setForceCreateRuntime(boolean forceCreateRuntime) {
        this.forceCreateRuntime = forceCreateRuntime;
    }

    protected void setRuntimeName(String runtimeName) {
        this.runtimeName = runtimeName;
    }

    protected void setServerName(String serverName) {
        this.serverName = serverName;
    }

    protected void setServerPath(String serverPath) {
        this.serverPath = serverPath;
    }

    protected void setVerifyPath(String verifyPath) {
        this.verifyPath = verifyPath;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getServerPath() {
        return this.serverPath;
    }

    protected IRuntime createRuntime(IServerType st, IPath path, IProgressMonitor monitor, IOverwriteQuery query) throws CoreException {
        IRuntime runtime = ServerCore.findRuntime((String)this.runtimeName);
        if (runtime != null) {
            if (!this.query(query, NLS.bind((String)Messages.ServerHandler_QUERY_RUNTIME_EXISTS, (Object)this.runtimeName))) {
                monitor.worked(1);
                return runtime;
            }
            runtime.delete();
        }
        IRuntimeWorkingCopy wc = st.getRuntimeType().createRuntime(this.runtimeName, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        wc.setName(this.runtimeName);
        if (path != null) {
            wc.setLocation(path);
        }
        runtime = wc.save(true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        return runtime;
    }

    private IServer createServer(IServerType st, IRuntime runtime, IProgressMonitor monitor, IOverwriteQuery query, ServerHandlerCallback callback) throws CoreException {
        IServer server = ServerCore.findServer((String)this.serverName);
        if (server != null) {
            if (!this.query(query, NLS.bind((String)Messages.ServerHandler_QUERY_SERVER_EXISTS, (Object)this.serverName))) {
                monitor.worked(1);
                return server;
            }
            IFolder serverConfiguration = server.getServerConfiguration();
            server.delete();
            if (serverConfiguration != null) {
                serverConfiguration.delete(true, true, monitor);
            }
        }
        IServerWorkingCopy wc = st.createServer(this.serverName, null, runtime, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        wc.setName(this.serverName);
        if (callback != null) {
            callback.configureServer(wc);
        }
        server = wc.save(true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        return server;
    }

    private IRuntime findRuntime(IServerType st, IProgressMonitor monitor) throws CoreException {
        IRuntime[] runtimes = ServerCore.getRuntimes();
        if (runtimes != null) {
            IRuntime[] iRuntimeArray = runtimes;
            int n = runtimes.length;
            int n2 = 0;
            while (n2 < n) {
                IRuntime runtime = iRuntimeArray[n2];
                if (runtime.getRuntimeType().equals(st.getRuntimeType())) {
                    return runtime;
                }
                ++n2;
            }
        }
        throw new CoreException(CloudFoundryPlugin.getErrorStatus((String)"No matching runtime found"));
    }

    private IServer findServer(IServerType st, IRuntime runtime, IProgressMonitor monitor) throws CoreException {
        IServer[] servers = ServerCore.getServers();
        if (servers != null) {
            IServer[] iServerArray = servers;
            int n = servers.length;
            int n2 = 0;
            while (n2 < n) {
                IServer server = iServerArray[n2];
                if (server.getRuntime().getRuntimeType().equals(st.getRuntimeType())) {
                    return server;
                }
                ++n2;
            }
        }
        throw new CoreException(CloudFoundryPlugin.getErrorStatus((String)"No matching server found"));
    }

    private boolean query(IOverwriteQuery query, String message) {
        String response = query.queryOverwrite(message);
        if ("CANCEL".equals(response)) {
            throw new OperationCanceledException();
        }
        return "YES".equals(response);
    }

    private void restartServer(IServer server, IProgressMonitor monitor) throws CoreException {
        monitor.subTask("Restarting server");
        final CountDownLatch eventLatch = new CountDownLatch(1);
        IServerListener serverListener = new IServerListener(){

            public void serverChanged(ServerEvent event) {
                if (event.getState() == 2) {
                    eventLatch.countDown();
                }
            }
        };
        try {
            server.addServerListener(serverListener);
            if (server.getServerState() != 2) {
                server.start("debug", monitor);
            } else if (server.getServerRestartState()) {
                server.restart("debug", monitor);
            } else {
                return;
            }
            monitor.subTask("Waiting for server to start");
            int i = 0;
            while (i < 50) {
                block12: {
                    try {
                        if (!eventLatch.await(200L, TimeUnit.MILLISECONDS)) break block12;
                        break;
                    }
                    catch (InterruptedException interruptedException) {
                        throw new OperationCanceledException();
                    }
                }
                if (monitor != null && monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                ++i;
            }
        }
        finally {
            server.removeServerListener(serverListener);
        }
    }
}

