/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.internal.checkers.ui.quickfix;

import org.eclipse.cdt.codan.internal.checkers.ui.CheckersUiActivator;
import org.eclipse.cdt.codan.internal.checkers.ui.quickfix.QuickFixMessages;
import org.eclipse.cdt.codan.ui.AbstractAstRewriteQuickFix;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;

public class QuickFixAddSemicolon
extends AbstractAstRewriteQuickFix {
    public String getLabel() {
        return QuickFixMessages.QuickFixAddSemicolon_add_semicolon;
    }

    public void modifyAST(IIndex index, IMarker marker) {
        IRegion region;
        int lineLength;
        int lineOffset;
        IASTTranslationUnit ast;
        try {
            ITranslationUnit tu = this.getTranslationUnitViaEditor(marker);
            ast = tu.getAST(index, 2);
        }
        catch (CoreException e) {
            CheckersUiActivator.log(e);
            return;
        }
        IASTNode astNode = null;
        if (this.isCodanProblem()) {
            return;
        }
        int lineNum = marker.getAttribute("lineNumber", 0) - 1;
        if (lineNum < 1) {
            return;
        }
        IDocument document = this.getDocument();
        try {
            lineOffset = document.getLineOffset(lineNum);
            lineLength = document.getLineLength(lineNum);
        }
        catch (BadLocationException e2) {
            return;
        }
        int pos = this.getOffset(marker, this.getDocument());
        String name = null;
        try {
            name = this.getProblemArgument(marker, 0);
        }
        catch (Exception e) {
            return;
        }
        if (name == null) {
            return;
        }
        FindReplaceDocumentAdapter dad = new FindReplaceDocumentAdapter(this.getDocument());
        try {
            region = dad.find(pos, name, true, true, false, false);
        }
        catch (BadLocationException e) {
            return;
        }
        if (region == null) {
            return;
        }
        int offset = region.getOffset();
        IASTNode prevNode = null;
        if (lineOffset < offset && (astNode = this.getASTFirstContainedNodeFromPosition(ast, lineOffset, lineLength)) != null) {
            IASTFileLocation fileLoc = astNode.getFileLocation();
            if (fileLoc == null) {
                return;
            }
            int length = lineLength;
            while (fileLoc.getNodeOffset() < offset) {
                prevNode = astNode;
                astNode = this.getASTFirstContainedNodeFromPosition(ast, fileLoc.getNodeOffset() + fileLoc.getNodeLength(), length);
                if ((fileLoc = astNode.getFileLocation()) == null) {
                    return;
                }
                length -= fileLoc.getNodeLength();
            }
        }
        block15: while (prevNode == null) {
            if (--lineNum < 0) {
                return;
            }
            try {
                lineOffset = document.getLineOffset(lineNum);
                lineLength = document.getLineLength(lineNum);
            }
            catch (BadLocationException e) {
                return;
            }
            int x = lineOffset;
            int leftover = lineLength;
            while (x < lineOffset + lineLength) {
                astNode = this.getASTFirstContainedNodeFromPosition(ast, x, leftover);
                if (astNode == null) continue block15;
                prevNode = astNode;
                IASTFileLocation fileLoc = astNode.getFileLocation();
                if (fileLoc == null) continue block15;
                x += fileLoc.getNodeLength();
                leftover -= fileLoc.getNodeLength();
            }
        }
        IASTFileLocation location = prevNode.getFileLocation();
        if (location == null) {
            return;
        }
        int replacementLoc = location.getNodeOffset() + location.getNodeLength();
        if (replacementLoc == offset) {
            replacementLoc -= System.lineSeparator().length();
        }
        try {
            document.replace(replacementLoc, 0, ";");
        }
        catch (BadLocationException e1) {
            return;
        }
        try {
            marker.delete();
        }
        catch (CoreException e) {
            CheckersUiActivator.log(e);
        }
    }

    private IASTNode getASTFirstContainedNodeFromPosition(IASTTranslationUnit ast, int charStart, int length) {
        IASTNode node = ast.getNodeSelector(null).findFirstContainedNode(charStart, length);
        return node;
    }
}

