/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.commands;

import org.eclipse.bpel.common.ui.editmodel.AbstractEditModelCommand;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;

public class RestoreSelectionCommand
extends AbstractEditModelCommand {
    ISelectionProvider selectionProvider;
    ISelection storedSelection;
    boolean restoreOnUndo;
    boolean restoreOnRedo;

    public RestoreSelectionCommand(ISelectionProvider selectionProvider, boolean restoreOnUndo, boolean restoreOnRedo) {
        this.selectionProvider = selectionProvider;
        this.restoreOnUndo = restoreOnUndo;
        this.restoreOnRedo = restoreOnRedo;
    }

    public void captureSelection() {
        this.storedSelection = this.selectionProvider.getSelection();
    }

    public void execute() {
        if (this.storedSelection == null) {
            this.captureSelection();
        }
    }

    protected void restoreSelection() {
        this.selectionProvider.setSelection(this.storedSelection);
    }

    public void undo() {
        if (this.restoreOnUndo) {
            this.restoreSelection();
        }
    }

    public void redo() {
        if (this.restoreOnRedo) {
            this.restoreSelection();
        }
    }

    public Resource[] getResources() {
        return EMPTY_RESOURCE_ARRAY;
    }

    public Resource[] getModifiedResources() {
        return EMPTY_RESOURCE_ARRAY;
    }
}

